/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.js;

import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

public class DevUIWebSocketHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger((String)DevUIWebSocketHandler.class.getName());
    private static final String UPGRADE = "Upgrade";
    private static final String WEBSOCKET = "websocket";

    public void handle(RoutingContext event) {
        if (WEBSOCKET.equalsIgnoreCase(event.request().getHeader(UPGRADE)) && !event.request().isEnded()) {
            event.request().toWebSocket((Handler)new Handler<AsyncResult<ServerWebSocket>>(){

                public void handle(AsyncResult<ServerWebSocket> event) {
                    if (event.succeeded()) {
                        ServerWebSocket socket = (ServerWebSocket)event.result();
                        DevUIWebSocketHandler.this.addSocket(socket);
                    } else {
                        LOG.debug((Object)"Failed to connect to dev ui ws server", event.cause());
                    }
                }
            });
            return;
        }
        event.next();
    }

    private void addSocket(ServerWebSocket session) {
        try {
            JsonRpcRouter jsonRpcRouter = (JsonRpcRouter)CDI.current().select(JsonRpcRouter.class, new Annotation[0]).get();
            jsonRpcRouter.addSocket(session);
        }
        catch (IllegalStateException ise) {
            LOG.debug((Object)("Failed to connect to dev ui ws server, " + ise.getMessage()));
        }
    }
}

