/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.utilities;

import io.quarkus.utilities.OS;
import java.io.File;

public class JavaBinFinder {
    public static String findBin() {
        Object java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File javaCheck = new File((String)java);
        if (!javaCheck.canExecute()) {
            java = null;
            if (OS.determineOS() == OS.WINDOWS && System.getenv().containsKey("PATHEXT")) {
                String[] exts;
                String extpath = System.getenv("PATHEXT");
                for (String ext : exts = extpath.split(";")) {
                    File winExe = new File(javaCheck.getAbsolutePath() + ext);
                    if (!winExe.canExecute()) continue;
                    java = winExe.getAbsolutePath();
                    break;
                }
            }
            if (java == null) {
                java = JavaBinFinder.simpleBinaryName();
            }
        }
        return java;
    }

    public static String simpleBinaryName() {
        if (OS.determineOS() == OS.WINDOWS) {
            return "java.exe";
        }
        return "java";
    }
}

