/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RegistryDescriptorConfigImpl
implements RegistryDescriptorConfig {
    private final ArtifactCoords artifact;
    @JsonIgnore
    private final boolean generated;

    RegistryDescriptorConfigImpl(ArtifactCoords artifact, boolean generated) {
        this.artifact = artifact;
        this.generated = generated;
    }

    @Override
    public ArtifactCoords getArtifact() {
        return this.artifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegistryDescriptorConfig)) {
            return false;
        }
        RegistryDescriptorConfig that = (RegistryDescriptorConfig)o;
        return Objects.equals(this.artifact, that.getArtifact());
    }

    public int hashCode() {
        return Objects.hash(this.artifact);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{artifact=" + String.valueOf(this.artifact) + "}";
    }

    static boolean isGenerated(Object config) {
        return config instanceof RegistryDescriptorConfigImpl && ((RegistryDescriptorConfigImpl)config).generated;
    }

    public static class Builder
    implements RegistryDescriptorConfig.Mutable {
        protected ArtifactCoords artifact;

        public Builder() {
        }

        @JsonIgnore
        Builder(RegistryDescriptorConfig config) {
            this.artifact = config.getArtifact();
        }

        @Override
        public ArtifactCoords getArtifact() {
            return this.artifact;
        }

        @Override
        public Builder setArtifact(ArtifactCoords artifact) {
            this.artifact = artifact;
            return this;
        }

        @Override
        public RegistryDescriptorConfigImpl build() {
            return new RegistryDescriptorConfigImpl(this.artifact, false);
        }
    }
}

