/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.selection;

import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.catalog.selection.ExtensionOrigins;
import io.quarkus.registry.catalog.selection.OriginCombination;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.catalog.selection.OriginSelector;
import io.quarkus.registry.catalog.selection.OriginWithPreference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultOriginSelector
implements OriginSelector {
    private OriginCombination recommended;
    private double recommendedScore = -1.0;
    private int recommendedRegistryPreference = -1;

    public DefaultOriginSelector(Collection<ExtensionOrigins> extOrigins) {
        ArrayList<ArtifactKey> extKeys = new ArrayList<ArtifactKey>(extOrigins.size());
        for (ExtensionOrigins eo : extOrigins) {
            extKeys.add(eo.getExtensionKey());
        }
        int highestRegistryPreference = 0;
        TreeMap<OriginPreference, WorkingCombination> map = new TreeMap<OriginPreference, WorkingCombination>();
        for (ExtensionOrigins eo : extOrigins) {
            for (OriginWithPreference op : eo.getOrigins()) {
                map.computeIfAbsent(op.getPreference(), k -> new WorkingCombination((OriginPreference)k, (Collection<ArtifactKey>)extKeys)).addExtension(eo.getExtensionKey(), op);
                highestRegistryPreference = Math.max(op.getPreference().registryPreference, highestRegistryPreference);
            }
        }
        ArrayList<WorkingCombination> list = new ArrayList<WorkingCombination>(map.values());
        for (int i = 0; i < list.size(); ++i) {
            WorkingCombination combination = (WorkingCombination)list.get(i);
            if (this.recommendedRegistryPreference >= 0 && combination.preferences.get((int)0).registryPreference > this.recommendedRegistryPreference) break;
            if (combination.isComplete()) {
                this.evaluateCandidate(extOrigins, highestRegistryPreference, combination);
                break;
            }
            if ((combination = DefaultOriginSelector.complete(combination, list, i + 1)) == null) continue;
            this.evaluateCandidate(extOrigins, highestRegistryPreference, combination);
        }
    }

    private void evaluateCandidate(Collection<ExtensionOrigins> extOrigins, int highestRegistryPreference, WorkingCombination combination) {
        if (this.recommended != null) {
            OriginCombination candidate;
            double candidateScore;
            if (this.recommendedScore < 0.0) {
                this.recommendedScore = OriginCombination.calculateScore(this.recommended, highestRegistryPreference, extOrigins.size());
            }
            if (this.recommendedScore < (candidateScore = OriginCombination.calculateScore(candidate = combination.toCombination(), highestRegistryPreference, extOrigins.size()))) {
                this.recommended = candidate;
                this.recommendedScore = candidateScore;
            }
        } else {
            this.recommended = combination.toCombination();
            this.recommendedRegistryPreference = combination.preferences.get((int)0).registryPreference;
        }
    }

    private static WorkingCombination complete(WorkingCombination combination, List<WorkingCombination> list, int fromIndex) {
        for (int i = fromIndex; i < list.size(); ++i) {
            WorkingCombination augmented;
            WorkingCombination candidate = list.get(i);
            if (!combination.canBeCombinedWith(candidate.preferences) || (augmented = combination.addMissing(candidate)) == null) continue;
            if (augmented.isComplete()) {
                return augmented;
            }
            if ((augmented = DefaultOriginSelector.complete(augmented, list, i + 1)) == null) continue;
            return augmented;
        }
        return null;
    }

    @Override
    public OriginCombination calculateRecommendedCombination() {
        return this.recommended;
    }

    private static class WorkingCombination {
        final List<OriginPreference> preferences;
        final Set<ArtifactKey> missingExtensions;
        final Map<ArtifactKey, OriginWithPreference> extensions;

        private WorkingCombination(OriginPreference preference, Collection<ArtifactKey> allExtKeys) {
            this.preferences = Collections.singletonList(preference);
            this.missingExtensions = new HashSet<ArtifactKey>(allExtKeys);
            this.extensions = new HashMap<ArtifactKey, OriginWithPreference>();
        }

        private WorkingCombination(WorkingCombination original) {
            this.preferences = new ArrayList<OriginPreference>(original.preferences);
            this.missingExtensions = new HashSet<ArtifactKey>(original.missingExtensions);
            this.extensions = new HashMap<ArtifactKey, OriginWithPreference>(original.extensions);
        }

        boolean isComplete() {
            return this.missingExtensions.isEmpty();
        }

        boolean canBeCombinedWith(OriginPreference other) {
            for (OriginPreference p : this.preferences) {
                if (p.canBeCombinedWith(other)) continue;
                return false;
            }
            return true;
        }

        boolean canBeCombinedWith(Collection<OriginPreference> other) {
            for (OriginPreference o : other) {
                if (this.canBeCombinedWith(o)) continue;
                return false;
            }
            return true;
        }

        WorkingCombination addMissing(WorkingCombination other) {
            WorkingCombination augmented = null;
            for (ArtifactKey missingKey : this.missingExtensions) {
                OriginWithPreference missing = other.extensions.get(missingKey);
                if (missing == null || !this.canBeCombinedWith(missing.getPreference())) continue;
                if (augmented == null) {
                    augmented = new WorkingCombination(this);
                }
                augmented.addExtension(missingKey, missing);
            }
            return augmented;
        }

        void addExtension(ArtifactKey ext, OriginWithPreference origin) {
            this.extensions.put(ext, origin);
            this.missingExtensions.remove(ext);
        }

        OriginCombination toCombination() {
            return new OriginCombination(this.extensions.values().toArray(new OriginWithPreference[0]));
        }
    }
}

