/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.config.RegistryArtifactConfig;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RegistryArtifactConfigImpl
implements RegistryArtifactConfig {
    protected final boolean disabled;
    protected final ArtifactCoords artifact;

    protected RegistryArtifactConfigImpl(boolean disabled, ArtifactCoords artifact) {
        this.disabled = disabled;
        this.artifact = artifact;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public ArtifactCoords getArtifact() {
        return this.artifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistryArtifactConfigImpl that = (RegistryArtifactConfigImpl)o;
        return this.disabled == that.disabled && Objects.equals(this.artifact, that.artifact);
    }

    public int hashCode() {
        return Objects.hash(this.disabled, this.artifact);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{disabled=" + this.disabled + ", artifact=" + this.artifact + "}";
    }

    public static class Builder
    implements RegistryArtifactConfig.Mutable {
        protected boolean disabled;
        protected ArtifactCoords artifact;

        public Builder() {
        }

        @JsonIgnore
        Builder(RegistryArtifactConfig config) {
            this.artifact = config.getArtifact();
            this.disabled = config.isDisabled();
        }

        @Override
        public boolean isDisabled() {
            return this.disabled;
        }

        @Override
        public RegistryArtifactConfig.Mutable setDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public ArtifactCoords getArtifact() {
            return this.artifact;
        }

        @Override
        public RegistryArtifactConfig.Mutable setArtifact(ArtifactCoords artifact) {
            this.artifact = artifact;
            return this;
        }

        @Override
        public RegistryArtifactConfigImpl build() {
            return new RegistryArtifactConfigImpl(this.disabled, this.artifact);
        }
    }
}

