/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update.rewrite.operations;

import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.update.rewrite.RewriteOperation;
import java.util.List;
import java.util.Map;

public class UpdateJavaVersionOperation
implements RewriteOperation {
    private final String newVersion;

    public UpdateJavaVersionOperation(String newVersion) {
        this.newVersion = newVersion;
    }

    @Override
    public List<Map<String, Object>> multi(BuildTool buildTool) {
        switch (buildTool) {
            case MAVEN: {
                return List.of(Map.of("org.openrewrite.maven.ChangePropertyValue", Map.of("key", "maven.compiler.source", "newValue", this.newVersion)), Map.of("org.openrewrite.maven.ChangePropertyValue", Map.of("key", "maven.compiler.target", "newValue", this.newVersion)), Map.of("org.openrewrite.maven.ChangePropertyValue", Map.of("key", "maven.compiler.release", "newValue", this.newVersion)));
            }
            case GRADLE: {
                return List.of(Map.of("org.openrewrite.gradle.UpdateJavaCompatibility", Map.of("version", this.newVersion)));
            }
        }
        return List.of();
    }
}

