/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.devtools.project.update.ExtensionUpdateInfo;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;

public class ProjectExtensionsUpdateInfo {
    private final Map<String, List<ExtensionUpdateInfo>> managedExtensions;
    final Map<String, List<ExtensionUpdateInfo>> versionedManagedExtensions;
    final Map<String, List<ExtensionUpdateInfo>> removedExtensions;
    final Map<String, List<ExtensionUpdateInfo>> addedExtensions;
    final Map<String, List<ExtensionUpdateInfo>> nonPlatformExtensions;

    public ProjectExtensionsUpdateInfo(Map<String, List<ExtensionUpdateInfo>> managedExtensions, Map<String, List<ExtensionUpdateInfo>> versionedManagedExtensions, Map<String, List<ExtensionUpdateInfo>> removedExtensions, Map<String, List<ExtensionUpdateInfo>> addedExtensions, Map<String, List<ExtensionUpdateInfo>> nonPlatformExtensionUpdate) {
        this.managedExtensions = managedExtensions;
        this.versionedManagedExtensions = versionedManagedExtensions;
        this.removedExtensions = removedExtensions;
        this.addedExtensions = addedExtensions;
        this.nonPlatformExtensions = nonPlatformExtensionUpdate;
    }

    public Map<String, List<ExtensionUpdateInfo>> getManagedExtensions() {
        return this.managedExtensions;
    }

    public Map<String, List<ExtensionUpdateInfo>> getVersionedManagedExtensions() {
        return this.versionedManagedExtensions;
    }

    public Map<String, List<ExtensionUpdateInfo>> getRemovedExtensions() {
        return this.removedExtensions;
    }

    public Map<String, List<ExtensionUpdateInfo>> getAddedExtensions() {
        return this.addedExtensions;
    }

    public Map<String, List<ExtensionUpdateInfo>> getNonPlatformExtensions() {
        return this.nonPlatformExtensions;
    }

    public OptionalInt getMinJavaVersion() {
        return Stream.of(this.getManagedExtensions().values(), this.getVersionedManagedExtensions().values(), this.getNonPlatformExtensions().values(), this.getAddedExtensions().values()).flatMap(Collection::stream).flatMap(Collection::stream).mapToInt(e -> Optional.ofNullable(ExtensionProcessor.getMinimumJavaVersion(e.getRecommendedMetadata())).orElse(11)).max();
    }

    public boolean isUpToDate() {
        return this.versionedManagedExtensions.isEmpty() && this.removedExtensions.isEmpty() && this.addedExtensions.isEmpty() && this.nonPlatformExtensions.isEmpty();
    }
}

