/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.devtools.project.SourceType;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaVersion {
    public static final JavaVersion NA = new JavaVersion();
    private final String version;
    public static final SortedSet<Integer> JAVA_VERSIONS_LTS = new TreeSet<Integer>(List.of(Integer.valueOf(11), Integer.valueOf(17), Integer.valueOf(21)));
    public static final int DEFAULT_JAVA_VERSION = 11;
    public static final int MAX_LTS_SUPPORTED_BY_KOTLIN = 17;
    public static final String DETECT_JAVA_RUNTIME_VERSION = "<<detect java runtime version>>";
    public static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\..*)?");

    private JavaVersion() {
        this(null);
    }

    public JavaVersion(String version) {
        this.version = version;
    }

    public boolean isEmpty() {
        return this.version == null;
    }

    public String getVersion() {
        return this.version;
    }

    public int getAsInt() {
        return Integer.parseInt(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaVersion that = (JavaVersion)o;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return this.version;
    }

    public static int determineBestJavaLtsVersion() {
        return JavaVersion.determineBestJavaLtsVersion(Runtime.version().feature());
    }

    public static int determineBestJavaLtsVersion(int runtimeVersion) {
        int ltsVersion;
        int bestLtsVersion = 11;
        Iterator iterator = JAVA_VERSIONS_LTS.iterator();
        while (iterator.hasNext() && (ltsVersion = ((Integer)iterator.next()).intValue()) <= runtimeVersion) {
            bestLtsVersion = ltsVersion;
        }
        return bestLtsVersion;
    }

    public static String computeJavaVersion(SourceType sourceType, String inputJavaVersion) {
        Matcher matcher;
        Integer javaFeatureVersionTarget = null;
        if (inputJavaVersion != null && !DETECT_JAVA_RUNTIME_VERSION.equals(inputJavaVersion) && (matcher = JAVA_VERSION_PATTERN.matcher(inputJavaVersion)).matches()) {
            javaFeatureVersionTarget = Integer.valueOf(matcher.group(1));
        }
        if (javaFeatureVersionTarget == null) {
            javaFeatureVersionTarget = Runtime.version().feature();
        }
        int bestJavaLtsVersion = JavaVersion.determineBestJavaLtsVersion(javaFeatureVersionTarget);
        if (SourceType.KOTLIN.equals((Object)sourceType) && bestJavaLtsVersion > 17) {
            bestJavaLtsVersion = 17;
        }
        return String.valueOf(bestJavaLtsVersion);
    }
}

