/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.cli.plugin.Catalog;
import io.quarkus.cli.plugin.Plugin;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PluginCatalog
implements Catalog<PluginCatalog> {
    public static final String VERSION = "v1";
    protected static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private final String version;
    private final String lastUpdate;
    private final Map<String, Plugin> plugins;
    @JsonIgnore
    private final Optional<Path> catalogLocation;

    public static PluginCatalog empty() {
        return new PluginCatalog();
    }

    public static PluginCatalog combine(Optional<PluginCatalog> userCatalog, Optional<PluginCatalog> projectCatalog) {
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        plugins.putAll(userCatalog.map(PluginCatalog::getPlugins).orElse(Collections.emptyMap()));
        plugins.putAll(projectCatalog.map(PluginCatalog::getPlugins).orElse(Collections.emptyMap()));
        Optional<LocalDateTime> projectCatalogDate = projectCatalog.map(c -> c.getLastUpdateDate());
        Optional<LocalDateTime> userCatalogDate = projectCatalog.map(c -> c.getLastUpdateDate());
        LocalDateTime lastUpdated = Stream.of(projectCatalogDate, userCatalogDate).filter(Optional::isPresent).map(Optional::get).max(Comparator.naturalOrder()).orElse(LocalDateTime.now());
        return new PluginCatalog(VERSION, lastUpdated, plugins, Optional.empty());
    }

    public PluginCatalog() {
        this(Collections.emptyMap());
    }

    public PluginCatalog(Map<String, Plugin> plugins) {
        this(VERSION, PluginCatalog.now(), plugins, Optional.empty());
    }

    public PluginCatalog(String version, LocalDateTime lastUpdate, Map<String, Plugin> plugins, Optional<Path> catalogLocation) {
        this(version, DATETIME_FORMATTER.format(lastUpdate), plugins, catalogLocation);
    }

    public PluginCatalog(String version, String lastUpdate, Map<String, Plugin> plugins, Optional<Path> catalogLocation) {
        this.version = version;
        this.lastUpdate = lastUpdate;
        this.catalogLocation = catalogLocation;
        this.plugins = Collections.unmodifiableMap(plugins.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> catalogLocation.isPresent() ? ((Plugin)e.getValue()).withCatalogLocation(catalogLocation) : (Plugin)e.getValue())));
    }

    public String getVersion() {
        return this.version;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonIgnore
    public LocalDateTime getLastUpdateDate() {
        return LocalDateTime.from(DATETIME_FORMATTER.parse(this.lastUpdate));
    }

    public Map<String, Plugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public Optional<Path> getCatalogLocation() {
        return this.catalogLocation;
    }

    @Override
    public PluginCatalog withCatalogLocation(Optional<Path> catalogLocation) {
        return new PluginCatalog(this.version, this.lastUpdate, this.plugins, catalogLocation);
    }

    @Override
    public PluginCatalog refreshLastUpdate() {
        return new PluginCatalog(this.version, PluginCatalog.now(), this.plugins, this.catalogLocation);
    }

    public PluginCatalog addPlugin(Plugin plugin) {
        HashMap<String, Plugin> newPlugins = new HashMap<String, Plugin>(this.plugins);
        newPlugins.put(plugin.getName(), plugin);
        return new PluginCatalog(this.version, PluginCatalog.now(), newPlugins, this.catalogLocation);
    }

    public PluginCatalog removePlugin(Plugin plugin) {
        HashMap<String, Plugin> newPlugins = new HashMap<String, Plugin>(this.plugins);
        newPlugins.remove(plugin.getName());
        return new PluginCatalog(this.version, PluginCatalog.now(), newPlugins, this.catalogLocation);
    }

    public PluginCatalog removePlugin(String pluginName) {
        HashMap<String, Plugin> newPlugins = new HashMap<String, Plugin>(this.plugins);
        newPlugins.remove(pluginName);
        return new PluginCatalog(this.version, PluginCatalog.now(), newPlugins, this.catalogLocation);
    }

    private static String now() {
        return LocalDateTime.now().format(DATETIME_FORMATTER);
    }
}

