/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update.rewrite;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.update.ExtensionUpdateInfo;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoaders;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;

public final class QuarkusUpdatesRepository {
    private static final String QUARKUS_UPDATE_RECIPES_GA = "io.quarkus:quarkus-update-recipes";
    private static final Pattern VERSION_EXTRACTION_PATTERN = Pattern.compile("[.][^.]+$");
    public static final String DEFAULT_UPDATE_RECIPES_VERSION = "LATEST";
    public static final String DEFAULT_MAVEN_REWRITE_PLUGIN_VERSION = "4.46.0";
    public static final String DEFAULT_GRADLE_REWRITE_PLUGIN_VERSION = "5.38.0";
    public static final String PROP_REWRITE_MAVEN_PLUGIN_VERSION = "rewrite-maven-plugin-version";
    public static final String PROP_REWRITE_GRADLE_PLUGIN_VERSION = "rewrite-gradle-plugin-version";

    private QuarkusUpdatesRepository() {
    }

    public static FetchResult fetchRecipes(MessageWriter log, MavenArtifactResolver artifactResolver, BuildTool buildTool, String quarkusUpdateRecipes, String additionalUpdateRecipes, String currentVersion, String targetVersion, List<ExtensionUpdateInfo> topExtensionDependency) {
        ArrayList<Object> gavs = new ArrayList<Object>();
        gavs.add(quarkusUpdateRecipes.contains(":") ? quarkusUpdateRecipes : "io.quarkus:quarkus-update-recipes:" + quarkusUpdateRecipes);
        if (additionalUpdateRecipes != null) {
            gavs.addAll(Arrays.stream(additionalUpdateRecipes.split(",")).map(String::strip).toList());
        }
        ArrayList<CallSite> artifacts = new ArrayList<CallSite>();
        LinkedHashMap<String, String> recipes = new LinkedHashMap<String, String>();
        String propRewritePluginVersion = null;
        for (String string : gavs) {
            LinkedHashMap<String, String[]> recipeDirectoryNames = new LinkedHashMap<String, String[]>();
            recipeDirectoryNames.put("core", new String[]{currentVersion, targetVersion});
            for (ExtensionUpdateInfo dep : topExtensionDependency) {
                recipeDirectoryNames.put(QuarkusUpdatesRepository.toKey(dep), new String[]{dep.getCurrentDep().getVersion(), dep.getRecommendedDependency().getVersion()});
            }
            try {
                Artifact artifact = artifactResolver.resolve(DependencyUtils.toArtifact((String)string)).getArtifact();
                String resolvedGAV = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
                artifacts.add((CallSite)((Object)resolvedGAV));
                ResourceLoader resourceLoader = ResourceLoaders.resolveFileResourceLoader(artifact.getFile());
                Map<String, String> newRecipes = QuarkusUpdatesRepository.fetchUpdateRecipes(resourceLoader, "quarkus-updates", recipeDirectoryNames);
                recipes.putAll(newRecipes);
                Properties props = resourceLoader.loadResourceAsPath("quarkus-updates/", p -> {
                    Properties properties = new Properties();
                    Path propPath = p.resolve("recipes.properties");
                    if (Files.isRegularFile(propPath, new LinkOption[0])) {
                        try (InputStream inStream = Files.newInputStream(propPath, new OpenOption[0]);){
                            properties.load(inStream);
                        }
                    }
                    return properties;
                });
                String pluginVersion = QuarkusUpdatesRepository.getPropRewritePluginVersion(props, buildTool);
                if (propRewritePluginVersion == null) {
                    propRewritePluginVersion = pluginVersion;
                } else if (!propRewritePluginVersion.equals(pluginVersion)) {
                    throw new RuntimeException("quarkus update artifacts require multiple rewrite plugin versions: " + propRewritePluginVersion + " and " + pluginVersion);
                }
                log.info(String.format("Resolved %s with %s recipe(s) to update from %s to %s (initially made for OpenRewrite %s plugin version: %s) ", new Object[]{string, recipes.size(), currentVersion, targetVersion, buildTool, propRewritePluginVersion}));
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve artifact: " + string, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load recipes in artifact: " + string, e);
            }
        }
        return new FetchResult(String.join((CharSequence)",", artifacts), new ArrayList<String>(recipes.values()), propRewritePluginVersion);
    }

    private static String getPropRewritePluginVersion(Properties props, BuildTool buildTool) {
        switch (buildTool) {
            case MAVEN: {
                return Optional.ofNullable(props.getProperty(PROP_REWRITE_MAVEN_PLUGIN_VERSION)).orElse(DEFAULT_MAVEN_REWRITE_PLUGIN_VERSION);
            }
            case GRADLE: 
            case GRADLE_KOTLIN_DSL: {
                return Optional.ofNullable(props.getProperty(PROP_REWRITE_GRADLE_PLUGIN_VERSION)).orElse(DEFAULT_GRADLE_REWRITE_PLUGIN_VERSION);
            }
        }
        throw new IllegalStateException("This build tool does not support update " + String.valueOf((Object)buildTool));
    }

    static boolean shouldApplyRecipe(String recipeFileName, String currentVersion, String targetVersion) {
        String recipeVersion = VERSION_EXTRACTION_PATTERN.matcher(recipeFileName).replaceFirst("");
        DefaultArtifactVersion recipeAVersion = new DefaultArtifactVersion(recipeVersion);
        DefaultArtifactVersion currentAVersion = new DefaultArtifactVersion(currentVersion);
        DefaultArtifactVersion targetAVersion = new DefaultArtifactVersion(targetVersion);
        return currentAVersion.compareTo((ArtifactVersion)recipeAVersion) < 0 && targetAVersion.compareTo((ArtifactVersion)recipeAVersion) >= 0;
    }

    static Map<String, String> fetchUpdateRecipes(ResourceLoader resourceLoader, String location, Map<String, String[]> recipeDirectoryNames) throws IOException {
        return resourceLoader.loadResourceAsPath(location, path -> {
            LinkedHashMap linkedHashMap;
            block8: {
                Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);
                try {
                    linkedHashMap = pathStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(dir -> QuarkusUpdatesRepository.applyStartsWith(QuarkusUpdatesRepository.toKey(path, dir), recipeDirectoryNames).stream().flatMap(key -> {
                        String[] versions = (String[])recipeDirectoryNames.get(key);
                        if (versions != null && versions.length != 0) {
                            try {
                                Stream<Path> recipePath = Files.walk(dir, new FileVisitOption[0]);
                                return (Stream)recipePath.filter(p -> p.getFileName().toString().matches("^\\d\\H+.ya?ml$")).filter(p -> QuarkusUpdatesRepository.shouldApplyRecipe(p.getFileName().toString(), versions[0], versions[1])).sorted(RecipeVersionComparator.INSTANCE).map(p -> {
                                    try {
                                        return new String[]{p.toString(), new String(Files.readAllBytes(p))};
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException("Error reading file: " + String.valueOf(p), e);
                                    }
                                }).onClose(() -> recipePath.close());
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Error traversing directory: " + String.valueOf(dir), e);
                            }
                        }
                        return null;
                    })).filter(Objects::nonNull).collect(Collectors.toMap(sa -> sa[0], sa -> sa[1], (v1, v2) -> {
                        if (!v1.equals(v2)) {
                            return v1 + "\n" + v2;
                        }
                        return v1;
                    }, LinkedHashMap::new));
                    if (pathStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (pathStream != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error traversing base directory", e);
                    }
                }
                pathStream.close();
            }
            return linkedHashMap;
        });
    }

    private static String toKey(ExtensionUpdateInfo dep) {
        return String.format("%s:%s", dep.getCurrentDep().getArtifact().getGroupId(), dep.getCurrentDep().getArtifact().getArtifactId());
    }

    static String toKey(Path parentDir, Path recipeDir) {
        String _path = parentDir.relativize(recipeDir).toString();
        return _path.replaceAll("(^[/\\\\])|([/\\\\]$)", "").replaceAll("[/\\\\]", ":");
    }

    static List<String> applyStartsWith(String key, Map<String, String[]> recipeDirectoryNames) {
        return recipeDirectoryNames.keySet().stream().filter(k -> k.startsWith(key)).collect(Collectors.toList());
    }

    public static class FetchResult {
        private final String recipesGAV;
        private final List<String> recipes;
        private final String rewritePluginVersion;

        public FetchResult(String recipesGAV, List<String> recipes, String rewritePluginVersion) {
            this.recipesGAV = recipesGAV;
            this.rewritePluginVersion = rewritePluginVersion;
            this.recipes = recipes;
        }

        public String getRecipesGAV() {
            return this.recipesGAV;
        }

        public List<String> getRecipes() {
            return this.recipes;
        }

        public String getRewritePluginVersion() {
            return this.rewritePluginVersion;
        }
    }

    private static class RecipeVersionComparator
    implements Comparator<Path> {
        private static final RecipeVersionComparator INSTANCE = new RecipeVersionComparator();

        private RecipeVersionComparator() {
        }

        @Override
        public int compare(Path recipePath1, Path recipePath2) {
            DefaultArtifactVersion recipeVersion1 = new DefaultArtifactVersion(VERSION_EXTRACTION_PATTERN.matcher(recipePath1.getFileName().toString()).replaceFirst(""));
            DefaultArtifactVersion recipeVersion2 = new DefaultArtifactVersion(VERSION_EXTRACTION_PATTERN.matcher(recipePath2.getFileName().toString()).replaceFirst(""));
            return recipeVersion1.compareTo((ArtifactVersion)recipeVersion2);
        }
    }
}

