/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import java.nio.file.Path;
import java.util.Set;
import java.util.function.Function;

public class PluginManagerSettings {
    public static String DEFAULT_PLUGIN_PREFIX = "quarkus";
    public static String[] DEFAULT_REMOTE_JBANG_CATALOGS = new String[]{"quarkusio"};
    public static Function<Path, Path> DEFAULT_RELATIVE_PATH_FUNC = p -> p.resolve(".quarkus").resolve("cli").resolve("plugins").resolve("quarkus-cli-catalog.json");
    private final boolean interactiveMode;
    private final String pluginPrefix;
    private final String[] remoteJBangCatalogs;
    private final Function<Path, Path> toRelativePath;

    public PluginManagerSettings(boolean interactiveMode, String pluginPrefix, String[] remoteJBangCatalogs, Function<Path, Path> toRelativePath) {
        this.interactiveMode = interactiveMode;
        this.pluginPrefix = pluginPrefix;
        this.remoteJBangCatalogs = remoteJBangCatalogs;
        this.toRelativePath = toRelativePath;
    }

    public static PluginManagerSettings defaultSettings() {
        return new PluginManagerSettings(false, DEFAULT_PLUGIN_PREFIX, DEFAULT_REMOTE_JBANG_CATALOGS, DEFAULT_RELATIVE_PATH_FUNC);
    }

    public PluginManagerSettings withPluignPrefix(String pluginPrefix) {
        return new PluginManagerSettings(this.interactiveMode, pluginPrefix, this.remoteJBangCatalogs, this.toRelativePath);
    }

    public PluginManagerSettings withCatalogs(Set<String> remoteJBangCatalogs) {
        return new PluginManagerSettings(this.interactiveMode, this.pluginPrefix, remoteJBangCatalogs.toArray(new String[remoteJBangCatalogs.size()]), this.toRelativePath);
    }

    public PluginManagerSettings withCatalogs(String ... remoteJBangCatalogs) {
        return new PluginManagerSettings(this.interactiveMode, this.pluginPrefix, remoteJBangCatalogs, this.toRelativePath);
    }

    public PluginManagerSettings withInteractivetMode(boolean interactiveMode) {
        return new PluginManagerSettings(interactiveMode, this.pluginPrefix, this.remoteJBangCatalogs, this.toRelativePath);
    }

    public String getPluginPrefix() {
        return this.pluginPrefix;
    }

    public String[] getRemoteJBangCatalogs() {
        return this.remoteJBangCatalogs;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public Function<Path, Path> getToRelativePath() {
        return this.toRelativePath;
    }
}

