/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.json.JsonCatalogMerger;
import io.quarkus.registry.union.ElementCatalog;
import io.quarkus.registry.union.ElementCatalogBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CreateProjectCommandHandler
implements QuarkusCommandHandler {
    private static final String QUARKUS_PLATFORM_GROUP_ID_EXPR = "${quarkus.platform.group-id}";
    private static final String QUARKUS_PLATFORM_VERSION_EXPR = "${quarkus.platform.version}";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set<String> extensionsQuery = invocation.getValue("extensions", Collections.emptySet());
        String className = invocation.getStringValue("class_name");
        String pkgName = invocation.getStringValue("package_name");
        String groupId = invocation.getStringValue("project_groupId");
        if (pkgName == null) {
            if (className != null && className.contains(".")) {
                int idx = className.lastIndexOf(46);
                invocation.setValue("package_name", className.substring(0, idx));
                invocation.setValue("class_name", className.substring(idx + 1));
            } else if (groupId != null) {
                invocation.setValue("package_name", groupId.replace("-", ".").replace("_", "."));
            }
        }
        List<Extension> extensionsToAdd = this.computeRequiredExtensions(invocation.getExtensionsCatalog(), extensionsQuery, invocation.log());
        ExtensionCatalog mainPlatform = invocation.getExtensionsCatalog();
        List<ExtensionCatalog> extensionOrigins = this.getExtensionOrigins(mainPlatform, extensionsToAdd);
        ArrayList<ArtifactCoords> platformBoms = new ArrayList<ArtifactCoords>(Math.max(extensionOrigins.size(), 1));
        if (extensionOrigins.size() > 0) {
            extensionsToAdd = this.computeRequiredExtensions(JsonCatalogMerger.merge(extensionOrigins), extensionsQuery, invocation.log());
            boolean sawFirstPlatform = false;
            for (ExtensionCatalog c : extensionOrigins) {
                if (!c.isPlatform()) continue;
                if (c.getBom().getArtifactId().equals("quarkus-bom") || !sawFirstPlatform) {
                    mainPlatform = c;
                    sawFirstPlatform = true;
                }
                platformBoms.add(c.getBom());
            }
        } else {
            platformBoms.add(mainPlatform.getBom());
        }
        ArrayList<ArtifactCoords> extensionCoords = new ArrayList<ArtifactCoords>(extensionsToAdd.size());
        for (Extension e2 : extensionsToAdd) {
            ArtifactCoords coords = e2.getArtifact();
            for (ExtensionOrigin origin : e2.getOrigins()) {
                if (!origin.isPlatform() || origin.getBom() == null || !platformBoms.contains(origin.getBom())) continue;
                coords = Extensions.stripVersion(coords);
                break;
            }
            extensionCoords.add(coords);
        }
        invocation.setValue("bom_groupId", mainPlatform.getBom().getGroupId());
        invocation.setValue("bom_artifactId", mainPlatform.getBom().getArtifactId());
        invocation.setValue("bom_version", mainPlatform.getBom().getVersion());
        invocation.setValue("quarkus_version", mainPlatform.getQuarkusCoreVersion());
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(mainPlatform);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString().replace("-", "_");
            if (!invocation.hasValue(name)) {
                invocation.setValue(name, v.toString());
            }
        }));
        try {
            HashMap platformData = new HashMap();
            if (mainPlatform.getMetadata().get("maven") != null) {
                platformData.put("maven", mainPlatform.getMetadata().get("maven"));
            }
            if (mainPlatform.getMetadata().get("gradle") != null) {
                platformData.put("gradle", mainPlatform.getMetadata().get("gradle"));
            }
            QuarkusCodestartProjectInput input = QuarkusCodestartProjectInput.builder().addPlatforms(platformBoms).addExtensions(extensionCoords).buildTool(invocation.getQuarkusProject().getBuildTool()).example((String)invocation.getValue("quarkus.create-project.example")).noCode(invocation.getValue("quarkus.create-project.no-code", false)).addCodestarts((Collection)invocation.getValue("quarkus.create-project.extra-codestarts", Collections.emptySet())).noBuildToolWrapper(invocation.getValue("quarkus.create-project.no-buildtool-wrapper", false)).noDockerfiles(invocation.getValue("quarkus.create-project.no-dockerfiles", false)).addData((Map)platformData).addData((Map)QuarkusCodestartData.LegacySupport.convertFromLegacy(invocation.getValues())).putData("app-config", invocation.getValue("app-config", Collections.emptyMap())).messageWriter(invocation.log()).build();
            invocation.log().info("-----------");
            if (!extensionsToAdd.isEmpty()) {
                invocation.log().info("selected extensions: \n" + extensionsToAdd.stream().map(e -> "- " + e.getArtifact().getGroupId() + ":" + e.getArtifact().getArtifactId() + "\n").collect(Collectors.joining()));
            }
            QuarkusCodestartCatalog catalog = QuarkusCodestartCatalog.fromExtensionsCatalog(invocation.getQuarkusProject().getExtensionsCatalog(), invocation.getQuarkusProject().getCodestartResourceLoaders());
            CodestartProjectDefinition projectDefinition = catalog.createProject(input);
            projectDefinition.generate(invocation.getQuarkusProject().getProjectDirPath());
            invocation.log().info("\n-----------\n" + MessageIcons.OK_ICON + " " + projectDefinition.getRequiredCodestart(CodestartType.PROJECT).getName() + " project has been successfully generated in:\n--> " + invocation.getQuarkusProject().getProjectDirPath().toString() + "\n-----------");
        }
        catch (IOException e3) {
            throw new QuarkusCommandException("Failed to create project: " + e3.getMessage(), e3);
        }
        return QuarkusCommandOutcome.success();
    }

    private List<Extension> computeRequiredExtensions(ExtensionCatalog catalog, Set<String> extensionsQuery, MessageWriter log) throws QuarkusCommandException {
        List<Extension> extensionsToAdd = QuarkusCommandHandlers.computeExtensionsFromQuery(catalog, extensionsQuery, log);
        if (extensionsToAdd == null) {
            throw new QuarkusCommandException("Failed to create project because of invalid extensions");
        }
        return extensionsToAdd;
    }

    private List<ExtensionCatalog> getExtensionOrigins(ExtensionCatalog extensionCatalog, List<Extension> extensionsToAdd) throws QuarkusCommandException {
        List<Object> eKeys;
        ElementCatalog ec = ElementCatalogBuilder.getElementCatalog((ExtensionCatalog)extensionCatalog, ExtensionCatalog.class);
        if (ec == null) {
            return Collections.emptyList();
        }
        Extension quarkusCore = extensionCatalog.getExtensions().stream().filter(e -> e.getArtifact().getArtifactId().equals("quarkus-core")).findFirst().get();
        if (quarkusCore == null) {
            throw new QuarkusCommandException("Failed to locate quarkus-core in the extension catalog");
        }
        if (extensionsToAdd.isEmpty()) {
            eKeys = Collections.singletonList(quarkusCore.getArtifact().getGroupId() + ":" + quarkusCore.getArtifact().getArtifactId());
        } else {
            eKeys = extensionsToAdd.stream().map(e -> e.getArtifact().getGroupId() + ":" + e.getArtifact().getArtifactId()).collect(Collectors.toList());
            eKeys.add(quarkusCore.getArtifact().getGroupId() + ":" + quarkusCore.getArtifact().getArtifactId());
        }
        return ElementCatalogBuilder.getMembersForElements((ElementCatalog)ec, eKeys);
    }
}

