/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.ArtifactCoords;
import io.quarkus.registry.model.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ImmutableExtensionPlatformRelease
implements Extension.ExtensionPlatformRelease {
    private final ArtifactCoords coords;
    private final Map<String, Object> metadata;

    private ImmutableExtensionPlatformRelease(ArtifactCoords coords, Map<String, Object> metadata) {
        this.coords = coords;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="coords")
    @JsonUnwrapped
    public ArtifactCoords getCoords() {
        return this.coords;
    }

    @Override
    @JsonProperty(value="metadata")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public final ImmutableExtensionPlatformRelease withCoords(ArtifactCoords value) {
        if (this.coords == value) {
            return this;
        }
        ArtifactCoords newValue = Objects.requireNonNull(value, "coords");
        return new ImmutableExtensionPlatformRelease(newValue, this.metadata);
    }

    public final ImmutableExtensionPlatformRelease withMetadata(Map<String, ? extends Object> entries) {
        if (this.metadata == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableExtensionPlatformRelease.createUnmodifiableMap(true, false, entries);
        return new ImmutableExtensionPlatformRelease(this.coords, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtensionPlatformRelease && this.equalTo((ImmutableExtensionPlatformRelease)another);
    }

    private boolean equalTo(ImmutableExtensionPlatformRelease another) {
        return this.coords.equals(another.coords);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.coords.hashCode();
        return h;
    }

    public String toString() {
        return "ExtensionPlatformRelease{coords=" + this.coords + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableExtensionPlatformRelease fromJson(Json json) {
        Builder builder = ImmutableExtensionPlatformRelease.builder();
        if (json.coords != null) {
            builder.coords(json.coords);
        }
        if (json.metadata != null) {
            builder.putAllMetadata(json.metadata);
        }
        return builder.build();
    }

    public static ImmutableExtensionPlatformRelease copyOf(Extension.ExtensionPlatformRelease instance) {
        if (instance instanceof ImmutableExtensionPlatformRelease) {
            return (ImmutableExtensionPlatformRelease)instance;
        }
        return ImmutableExtensionPlatformRelease.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_COORDS = 1L;
        private long initBits = 1L;
        private ArtifactCoords coords;
        private Map<String, Object> metadata = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public final Builder from(Extension.ExtensionPlatformRelease instance) {
            Objects.requireNonNull(instance, "instance");
            this.coords(instance.getCoords());
            this.putAllMetadata(instance.getMetadata());
            return this;
        }

        @JsonProperty(value="coords")
        @JsonUnwrapped
        public final Builder coords(ArtifactCoords coords) {
            this.coords = Objects.requireNonNull(coords, "coords");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putMetadata(String key, Object value) {
            this.metadata.put(Objects.requireNonNull(key, "metadata key"), Objects.requireNonNull(value, "metadata value"));
            return this;
        }

        public final Builder putMetadata(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(Map<String, ? extends Object> entries) {
            this.metadata.clear();
            return this.putAllMetadata(entries);
        }

        public final Builder putAllMetadata(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
            }
            return this;
        }

        public ImmutableExtensionPlatformRelease build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtensionPlatformRelease(this.coords, ImmutableExtensionPlatformRelease.createUnmodifiableMap(false, false, this.metadata));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("coords");
            }
            return "Cannot build ExtensionPlatformRelease, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Extension.ExtensionPlatformRelease {
        ArtifactCoords coords;
        Map<String, Object> metadata = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="coords")
        @JsonUnwrapped
        public void setCoords(ArtifactCoords coords) {
            this.coords = coords;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
        }

        @Override
        public ArtifactCoords getCoords() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

