/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.dependencies.ExtensionPredicate;
import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.registry.ExtensionRegistry;
import io.quarkus.registry.ImmutableExtensionReleaseTuple;
import io.quarkus.registry.MultipleExtensionsFoundException;
import io.quarkus.registry.builder.RegistryBuilder;
import io.quarkus.registry.builder.URLRegistryBuilder;
import io.quarkus.registry.model.ArtifactKey;
import io.quarkus.registry.model.Extension;
import io.quarkus.registry.model.Registry;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.immutables.value.Value;

public class DefaultExtensionRegistry
implements ExtensionRegistry {
    private final Registry registry;

    public static DefaultExtensionRegistry fromURLs(Collection<URL> urls) throws IOException {
        Registry registry = new URLRegistryBuilder().addURLs(urls).build();
        return new DefaultExtensionRegistry(registry);
    }

    public static DefaultExtensionRegistry fromPlatform(QuarkusPlatformDescriptor platform) {
        RegistryBuilder builder = new RegistryBuilder();
        builder.visitPlatform(platform);
        return new DefaultExtensionRegistry(builder.build());
    }

    public DefaultExtensionRegistry(Registry registry) {
        this.registry = Objects.requireNonNull(registry, "Registry cannot be null");
    }

    public Set<String> getQuarkusCoreVersions() {
        return this.registry.getCoreVersions().keySet().stream().map(ComparableVersion::toString).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<io.quarkus.dependencies.Extension> getExtensionsByCoreVersion(String version) {
        return this.list(version, "");
    }

    public Set<io.quarkus.dependencies.Extension> list(String quarkusCore, String keyword) {
        return this.listInternalExtensions(quarkusCore, keyword).stream().map(this::toQuarkusExtension).sorted(Comparator.comparing(io.quarkus.dependencies.Extension::getArtifactId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public ExtensionInstallPlan planInstallation(String quarkusCore, Collection<String> keywords) {
        ExtensionInstallPlan.Builder builder = ExtensionInstallPlan.builder();
        boolean multipleKeywords = keywords.size() > 1;
        for (String keyword : keywords) {
            int countColons = StringUtils.countMatches((CharSequence)keyword, (CharSequence)":");
            if (countColons == 1) {
                AppArtifactKey artifactKey = AppArtifactKey.fromString((String)keyword);
                builder.addManagedExtension(new AppArtifactCoords(artifactKey, null));
                continue;
            }
            if (countColons > 1) {
                builder.addIndependentExtension(AppArtifactCoords.fromString((String)keyword));
                continue;
            }
            List<ExtensionReleaseTuple> tuples = this.listInternalExtensions(quarkusCore, keyword);
            if (tuples.size() != 1 && multipleKeywords) {
                return ExtensionInstallPlan.EMPTY;
            }
            if (tuples.size() > 1 && !ExtensionPredicate.isPattern((String)keyword)) {
                throw new MultipleExtensionsFoundException(keyword, tuples.stream().map(this::toQuarkusExtension).collect(Collectors.toList()));
            }
            for (ExtensionReleaseTuple tuple : tuples) {
                ArtifactKey id = tuple.getExtension().getId();
                String groupId = id.getGroupId();
                String artifactId = id.getArtifactId();
                String version = tuple.getRelease().getRelease().getVersion();
                AppArtifactCoords extensionCoords = new AppArtifactCoords(groupId, artifactId, version);
                List platformCoords = tuple.getRelease().getPlatforms().stream().map(c -> new AppArtifactCoords(c.getCoords().getId().getGroupId(), c.getCoords().getId().getArtifactId(), "pom", c.getCoords().getVersion())).collect(Collectors.toList());
                if (platformCoords.isEmpty()) {
                    builder.addIndependentExtension(extensionCoords);
                    continue;
                }
                builder.addManagedExtension(extensionCoords);
                for (AppArtifactCoords platformCoord : platformCoords) {
                    builder.addPlatform(platformCoord);
                }
            }
        }
        return builder.build();
    }

    private List<ExtensionReleaseTuple> listInternalExtensions(String quarkusCore, String keyword) {
        ArrayList<ExtensionReleaseTuple> result = new ArrayList<ExtensionReleaseTuple>();
        ExtensionPredicate predicate = null;
        if (keyword != null && !keyword.isEmpty()) {
            predicate = new ExtensionPredicate(keyword);
        }
        block0: for (Extension extension : this.registry.getExtensions()) {
            for (Extension.ExtensionRelease extensionRelease : extension.getReleases()) {
                if (!quarkusCore.equals(extensionRelease.getRelease().getQuarkusCore())) continue;
                ImmutableExtensionReleaseTuple tuple = ExtensionReleaseTuple.builder().extension(extension).release(extensionRelease).build();
                if (predicate == null) {
                    result.add(tuple);
                    continue block0;
                }
                io.quarkus.dependencies.Extension quarkusExtension = this.toQuarkusExtension(tuple);
                if (predicate.isExactMatch(quarkusExtension)) {
                    return Collections.singletonList(tuple);
                }
                if (!predicate.test(quarkusExtension)) continue block0;
                result.add(tuple);
                continue block0;
            }
        }
        return result;
    }

    private io.quarkus.dependencies.Extension toQuarkusExtension(ExtensionReleaseTuple tuple) {
        Extension extension = tuple.getExtension();
        Extension.ExtensionRelease tupleRelease = tuple.getRelease();
        HashMap<String, Object> metadata = new HashMap<String, Object>(extension.getMetadata());
        tupleRelease.getPlatforms().stream().map(Extension.ExtensionPlatformRelease::getMetadata).findFirst().ifPresent(metadata::putAll);
        ArtifactKey id = extension.getId();
        return new io.quarkus.dependencies.Extension().setGroupId(id.getGroupId()).setArtifactId(id.getArtifactId()).setVersion(tupleRelease.getRelease().getVersion()).setName(extension.getName()).setDescription(extension.getDescription()).setMetadata(metadata);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    @Value.Immutable
    static interface ExtensionReleaseTuple {
        public Extension getExtension();

        public Extension.ExtensionRelease getRelease();

        public static ImmutableExtensionReleaseTuple.Builder builder() {
            return ImmutableExtensionReleaseTuple.builder();
        }
    }
}

