/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.AddExtensionResult;
import io.quarkus.cli.commands.Printer;
import io.quarkus.cli.commands.SelectionResult;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.file.MavenBuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.generators.BuildTool;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;

public class AddExtensions {
    private BuildFile buildFile;
    private static final Printer PRINTER = new Printer();

    public AddExtensions(ProjectWriter writer) throws IOException {
        this(new MavenBuildFile(writer));
    }

    public AddExtensions(ProjectWriter writer, BuildTool buildTool) throws IOException {
        this.buildFile = buildTool.createBuildFile(writer);
    }

    public AddExtensions(BuildFile buildFile) throws IOException {
        this.buildFile = buildFile;
    }

    static SelectionResult select(String query, List<Extension> extensions, boolean labelLookup) {
        String q = query.trim().toLowerCase();
        Set<Extension> matchesNameOrArtifactId = extensions.stream().filter(extension -> extension.getName().equalsIgnoreCase(q) || AddExtensions.matchesArtifactId(extension.getArtifactId(), q)).collect(Collectors.toSet());
        if (matchesNameOrArtifactId.size() == 1) {
            return new SelectionResult(matchesNameOrArtifactId, true);
        }
        Set<Extension> matchesShortName = (extensions = extensions.stream().filter(e -> !e.isUnlisted()).collect(Collectors.toList())).stream().filter(extension -> AddExtensions.matchesShortName(extension, q)).collect(Collectors.toSet());
        if (matchesShortName.size() == 1 && matchesNameOrArtifactId.isEmpty()) {
            return new SelectionResult(matchesShortName, true);
        }
        Set<Extension> partialMatches = extensions.stream().filter(extension -> extension.getName().toLowerCase().contains(q) || extension.getArtifactId().toLowerCase().contains(q) || extension.getShortName().toLowerCase().contains(q)).collect(Collectors.toSet());
        if (partialMatches.size() == 1 && matchesNameOrArtifactId.isEmpty() && matchesShortName.isEmpty()) {
            return new SelectionResult(partialMatches, true);
        }
        List matchesLabels = labelLookup ? extensions.stream().filter(extension -> extension.labelsForMatching().contains(q)).collect(Collectors.toList()) : Collections.emptyList();
        Pattern pattern = AddExtensions.toRegex(q);
        if (pattern != null) {
            Set<Extension> matchesPatterns = extensions.stream().filter(extension -> pattern.matcher(extension.getName().toLowerCase()).matches() || pattern.matcher(extension.getArtifactId().toLowerCase()).matches() || pattern.matcher(extension.getShortName().toLowerCase()).matches() || AddExtensions.matchLabels(pattern, extension.getKeywords())).collect(Collectors.toSet());
            return new SelectionResult(matchesPatterns, true);
        }
        Set matchesPatterns = Collections.emptySet();
        LinkedHashSet<Extension> candidates = new LinkedHashSet<Extension>();
        candidates.addAll(matchesNameOrArtifactId);
        candidates.addAll(matchesShortName);
        candidates.addAll(partialMatches);
        candidates.addAll(matchesLabels);
        candidates.addAll(matchesPatterns);
        return new SelectionResult(candidates, false);
    }

    private static boolean matchLabels(Pattern pattern, List<String> labels) {
        boolean matches = false;
        for (String label : labels) {
            matches |= pattern.matcher(label.toLowerCase()).matches();
        }
        return matches;
    }

    private static Pattern toRegex(String str) {
        try {
            String wildcardToRegex = AddExtensions.wildcardToRegex(str);
            if (wildcardToRegex != null && !wildcardToRegex.isEmpty()) {
                return Pattern.compile(wildcardToRegex);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static String wildcardToRegex(String wildcard) {
        if (wildcard == null || wildcard.isEmpty()) {
            return null;
        }
        if (!wildcard.contains("*") && !wildcard.contains("?")) {
            return null;
        }
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append("^.*");
        int is = wildcard.length();
        block6: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block6;
                }
                case '?': {
                    s.append(".");
                    continue block6;
                }
                case '^': {
                    s.append("\\");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block6;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append(".*$");
        return s.toString();
    }

    private static boolean matchesShortName(Extension extension, String q) {
        return q.equalsIgnoreCase(extension.getShortName());
    }

    private static boolean matchesArtifactId(String artifactId, String q) {
        return artifactId.equalsIgnoreCase(q) || artifactId.equalsIgnoreCase("quarkus-" + q);
    }

    public AddExtensionResult addExtensions(Set<String> extensions) throws IOException {
        if (extensions == null || extensions.isEmpty()) {
            return new AddExtensionResult(false, true);
        }
        boolean updated = false;
        boolean success = true;
        List<Dependency> dependenciesFromBom = this.getDependenciesFromBom();
        List<Extension> registry = MojoUtils.loadExtensions();
        for (String query : extensions) {
            if (query.contains(":")) {
                updated = this.buildFile.addExtensionAsGAV(query) || updated;
                continue;
            }
            SelectionResult result = AddExtensions.select(query, registry, false);
            if (!result.matches()) {
                StringBuilder sb = new StringBuilder();
                Set<Extension> candidates = result.getExtensions();
                if (candidates.isEmpty()) {
                    PRINTER.nok(" Cannot find a dependency matching '" + query + "', maybe a typo?");
                    success = false;
                    continue;
                }
                sb.append("\u274c").append(" Multiple extensions matching '").append(query).append("'");
                result.getExtensions().forEach(extension -> sb.append(System.lineSeparator()).append("     * ").append(extension.managementKey()));
                sb.append(System.lineSeparator()).append("     Be more specific e.g using the exact name or the full GAV.");
                PRINTER.print(sb.toString());
                success = false;
                continue;
            }
            for (Extension extension2 : result) {
                updated = this.buildFile.addDependency(dependenciesFromBom, extension2) || updated;
            }
        }
        if (updated) {
            this.buildFile.close();
        }
        return new AddExtensionResult(updated, success);
    }

    private List<Dependency> getDependenciesFromBom() {
        return MojoUtils.getPlatformDescriptor().getManagedDependencies();
    }
}

