/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.derby.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.derby.drda.NetworkServerControl;
import org.jboss.logging.Logger;

public class DerbyDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(DerbyDevServicesProcessor.class);
    static final int NUMBER_OF_PINGS = 10;
    static final int SLEEP_BETWEEN_PINGS = 500;

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupDerby() {
        return new DevServicesDatasourceProviderBuildItem("derby", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                try {
                    final int port = containerConfig.getFixedExposedPort().isPresent() ? containerConfig.getFixedExposedPort().getAsInt() : 1527 + (launchMode == LaunchMode.TEST ? 0 : 1);
                    String effectiveDbName = containerConfig.getDbName().orElse(datasourceName.orElse("quarkus"));
                    NetworkServerControl server = new NetworkServerControl(InetAddress.getByName("localhost"), port);
                    server.start(new PrintWriter(System.out));
                    for (int i = 1; i <= 10; ++i) {
                        try {
                            LOG.info((Object)("Attempt " + i + " to see if Dev Services for Derby started"));
                            server.ping();
                            break;
                        }
                        catch (Exception ex) {
                            if (i == 10) {
                                LOG.error((Object)"Dev Services for Derby failed to start", (Throwable)ex);
                                throw ex;
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    LOG.info((Object)"Dev Services for Derby started.");
                    StringBuilder additionalArgs = new StringBuilder();
                    for (Map.Entry i : containerConfig.getAdditionalJdbcUrlProperties().entrySet()) {
                        additionalArgs.append(";");
                        additionalArgs.append((String)i.getKey());
                        additionalArgs.append("=");
                        additionalArgs.append((String)i.getValue());
                    }
                    return new DevServicesDatasourceProvider.RunningDevServicesDatasource(null, "jdbc:derby://localhost:" + port + "/memory:" + effectiveDbName + ";create=true" + additionalArgs.toString(), null, null, null, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            try {
                                NetworkServerControl server = new NetworkServerControl(InetAddress.getByName("localhost"), port);
                                server.shutdown();
                                LOG.info((Object)"Dev Services for Derby shut down");
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (Exception throwable) {
                    throw new RuntimeException(throwable);
                }
            }

            public boolean isDockerRequired() {
                return false;
            }
        });
    }
}

