/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment.compose;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.Ports;
import io.quarkus.devservices.common.ContainerUtil;
import io.quarkus.devservices.common.JBossLoggingConsumer;
import io.quarkus.devservices.deployment.compose.ComposeFiles;
import io.quarkus.devservices.deployment.compose.ComposeRunner;
import io.quarkus.devservices.deployment.compose.ComposeServiceDefinition;
import io.quarkus.devservices.deployment.compose.ComposeServiceWaitStrategyTarget;
import io.quarkus.runtime.util.StringUtil;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.ResourceReaper;

public class ComposeProject {
    private static final Logger LOG = Logger.getLogger(ComposeProject.class);
    public static final String DEFAULT_NETWORK_NAME = "default";
    private final DockerClient dockerClient;
    private final ComposeFiles composeFiles;
    private final String project;
    private final String executable;
    private final Duration startupTimeout;
    private final Duration stopTimeout;
    private final boolean stopContainers;
    private final boolean ryukEnabled;
    private final boolean followContainerLogs;
    private final Boolean build;
    private final List<String> options;
    private final List<String> profiles;
    private final Map<String, Integer> scalingPreferences;
    private final Map<String, String> env;
    private final boolean removeVolumes;
    private final String removeImages;
    private final Map<String, WaitAllStrategy> waitStrategies;
    private List<ComposeServiceWaitStrategyTarget> serviceInstances;
    private List<Network> networks;

    public ComposeProject(DockerClient dockerClient, ComposeFiles composeFiles, String executable, String project, Duration startupTimeout, Duration stopTimeout, boolean stopContainers, boolean ryukEnabled, boolean followContainerLogs, boolean removeVolumes, String removeImages, Boolean build, List<String> options, List<String> profiles, Map<String, Integer> scalingPreferences, Map<String, String> env) {
        this.dockerClient = dockerClient;
        this.composeFiles = composeFiles;
        this.project = project;
        this.executable = executable;
        this.startupTimeout = startupTimeout;
        this.stopTimeout = stopTimeout;
        this.stopContainers = stopContainers;
        this.ryukEnabled = ryukEnabled;
        this.followContainerLogs = followContainerLogs;
        this.options = options;
        this.profiles = profiles;
        this.scalingPreferences = scalingPreferences;
        this.env = env;
        this.removeVolumes = removeVolumes;
        this.removeImages = removeImages;
        this.build = build;
        this.waitStrategies = new HashMap<String, WaitAllStrategy>();
        this.registerWaitStrategies(composeFiles, this.waitStrategies);
    }

    public void addWaitStrategy(Map<String, WaitAllStrategy> strategies, String instanceName, WaitStrategy strategy) {
        strategies.computeIfAbsent(instanceName, ignored -> new WaitAllStrategy(WaitAllStrategy.Mode.WITH_MAXIMUM_OUTER_TIMEOUT).withStartupTimeout(this.startupTimeout)).withStrategy(strategy);
        LOG.debugv("Added wait strategy {0} for service {1}", (Object)strategy, (Object)instanceName);
    }

    private void registerWaitStrategies(ComposeFiles composeFiles, Map<String, WaitAllStrategy> waitStrategies) {
        for (ComposeServiceDefinition definition : composeFiles.getServiceDefinitions().values()) {
            String serviceName = definition.getServiceName();
            Map<String, Object> labels = definition.getLabels();
            if (!definition.getProfiles().isEmpty()) {
                if (definition.getProfiles().stream().noneMatch(this.profiles::contains)) continue;
            }
            if (definition.hasHealthCheck()) {
                this.addWaitStrategy(waitStrategies, serviceName, (WaitStrategy)Wait.forHealthcheck());
                continue;
            }
            for (Map.Entry<String, Object> e : labels.entrySet()) {
                String waitForTimeout;
                if (!e.getKey().startsWith("io.quarkus.devservices.compose.wait_for.logs")) continue;
                int times = 1;
                if ("io.quarkus.devservices.compose.wait_for.logs.timeout".equals(e.getKey())) continue;
                if (e.getKey().length() > "io.quarkus.devservices.compose.wait_for.logs".length()) {
                    try {
                        times = Integer.parseInt(e.getKey().replace("io.quarkus.devservices.compose.wait_for.logs.", ""));
                    }
                    catch (NumberFormatException t) {
                        LOG.warnv("Cannot parse label `{}`", (Object)e.getKey());
                    }
                }
                Duration timeout = (waitForTimeout = (String)labels.get("io.quarkus.devservices.compose.wait_for.logs.timeout")) != null ? Duration.parse("PT" + waitForTimeout) : this.startupTimeout;
                this.addWaitStrategy(waitStrategies, serviceName, Wait.forLogMessage((String)((String)e.getValue()), (int)times).withStartupTimeout(timeout));
            }
            if (labels.get("io.quarkus.devservices.compose.wait_for.ports.disable") == Boolean.TRUE) continue;
            int[] ports = definition.getPorts().stream().mapToInt(ExposedPort::getPort).toArray();
            String waitForTimeout = (String)labels.get("io.quarkus.devservices.compose.wait_for.ports.timeout");
            Duration timeout = waitForTimeout != null ? Duration.parse("PT" + waitForTimeout) : this.startupTimeout;
            this.addWaitStrategy(waitStrategies, serviceName, Wait.forListeningPorts((int[])ports).withStartupTimeout(timeout));
        }
    }

    public String getProject() {
        return this.project;
    }

    Map<String, WaitAllStrategy> getWaitStrategies() {
        return this.waitStrategies;
    }

    public synchronized void start() {
        this.registerContainersForShutdown();
        this.startServices();
        this.discoverServiceInstances(true);
    }

    public void waitUntilServicesReady(Executor waitOn) {
        this.checkServicesStarted();
        this.copyExposedPortsToContainers();
        CompletableFuture.allOf((CompletableFuture[])this.serviceInstances.stream().map(srv -> this.waitOnThread((ComposeServiceWaitStrategyTarget)srv, waitOn)).toArray(CompletableFuture[]::new)).join();
    }

    private void copyExposedPortsToContainers() {
        for (ComposeServiceWaitStrategyTarget instance : this.serviceInstances) {
            String ports;
            String exposedPortsPath;
            InspectContainerResponse inspectContainer = instance.get();
            Map labels = inspectContainer.getConfig().getLabels();
            if (labels == null || (exposedPortsPath = (String)labels.get("io.quarkus.devservices.compose.exposed_ports")) == null || StringUtil.isNullOrEmpty((String)(ports = inspectContainer.getNetworkSettings().getPorts().getBindings().entrySet().stream().filter(e -> e.getValue() != null).flatMap(e -> Arrays.stream((Ports.Binding[])e.getValue()).map(c -> String.format("PORT_%d=%s", ((ExposedPort)e.getKey()).getPort(), c.getHostPortSpec()))).collect(Collectors.joining("\n", "", "\n"))))) continue;
            instance.copyFileToContainer(Transferable.of((byte[])ports.getBytes(StandardCharsets.UTF_8)), exposedPortsPath);
        }
    }

    public void startAndWaitUntilServicesReady(Executor waitOn) {
        this.start();
        this.waitUntilServicesReady(waitOn);
    }

    private void checkServicesStarted() {
        if (this.serviceInstances == null || this.serviceInstances.isEmpty()) {
            throw new IllegalStateException("Services have not been started yet");
        }
    }

    private CompletableFuture<Void> waitOnThread(ComposeServiceWaitStrategyTarget instance, Executor waitOn) {
        if (waitOn == null) {
            return CompletableFuture.runAsync(() -> this.waitUntilReady(instance));
        }
        return CompletableFuture.runAsync(() -> this.waitUntilReady(instance), waitOn);
    }

    private void waitUntilReady(ComposeServiceWaitStrategyTarget instance) {
        String serviceName = instance.getServiceName();
        WaitStrategy strategy = (WaitStrategy)this.waitStrategies.get(serviceName);
        if (strategy != null) {
            LOG.infov("Waiting for service {0} to be ready", (Object)serviceName);
            try {
                strategy.waitUntilReady((WaitStrategyTarget)instance);
            }
            catch (Exception e) {
                LOG.infov("Service {0} not ready, logs: {1}", (Object)serviceName, (Object)instance.getLogs());
                throw e;
            }
            LOG.infov("Service {0} is ready", (Object)serviceName);
        }
    }

    private void registerContainersForShutdown() {
        if (this.ryukEnabled) {
            ResourceReaper.instance().registerLabelsFilterForCleanup(Collections.singletonMap("com.docker.compose.project", this.project));
        }
    }

    private void startServices() {
        String scalingOptions = this.scalingPreferences.entrySet().stream().map(entry -> "--scale " + (String)entry.getKey() + "=" + String.valueOf(entry.getValue())).distinct().collect(Collectors.joining(" "));
        Object command = this.getUpCommand(this.getOptions());
        if (this.build != null) {
            command = this.build != false ? (String)command + " --build" : (String)command + " --no-build";
        }
        if (!StringUtil.isNullOrEmpty((String)scalingOptions)) {
            command = (String)command + " " + scalingOptions;
        }
        this.runWithCompose((String)command, this.env);
    }

    public synchronized void discoverServiceInstances(boolean checkForRequiredServices) {
        HashSet<String> servicesToWaitFor = new HashSet<String>(this.waitStrategies.keySet());
        ArrayList<ComposeServiceWaitStrategyTarget> serviceInstances = new ArrayList<ComposeServiceWaitStrategyTarget>();
        for (Container container : this.listChildContainers()) {
            String state = container.getState();
            if (!"running".equalsIgnoreCase(state) && !"restarting".equalsIgnoreCase(state)) continue;
            ComposeServiceWaitStrategyTarget instance = this.createServiceInstance(container, this.followContainerLogs);
            serviceInstances.add(instance);
            servicesToWaitFor.remove(instance.getServiceName());
        }
        if (checkForRequiredServices && !servicesToWaitFor.isEmpty()) {
            throw new IllegalStateException("Services named " + String.valueOf(servicesToWaitFor) + " do not exist, but wait conditions have been defined for them.");
        }
        this.networks = this.listChildNetworks();
        this.serviceInstances = serviceInstances;
    }

    private List<Container> listChildContainers() {
        return (List)this.dockerClient.listContainersCmd().withLabelFilter(Map.of("com.docker.compose.project", this.project)).withShowAll(Boolean.valueOf(true)).exec();
    }

    private List<Network> listChildNetworks() {
        return (List)this.dockerClient.listNetworksCmd().withFilter("label", List.of("com.docker.compose.project=" + this.project)).exec();
    }

    private ComposeServiceWaitStrategyTarget createServiceInstance(Container container, boolean tailChildContainers) {
        ComposeServiceWaitStrategyTarget containerInstance = new ComposeServiceWaitStrategyTarget(this.dockerClient, container);
        if (tailChildContainers) {
            String containerId = containerInstance.getContainerId();
            String serviceName = containerInstance.getContainerName();
            this.followLogs(containerId, (Consumer<OutputFrame>)new JBossLoggingConsumer(LOG).withPrefix(serviceName).withSeparateOutputStreams());
        }
        return containerInstance;
    }

    private void followLogs(String containerId, Consumer<OutputFrame> consumer) {
        FrameConsumerResultCallback callback = new FrameConsumerResultCallback();
        callback.addConsumer(OutputFrame.OutputType.STDOUT, consumer);
        callback.addConsumer(OutputFrame.OutputType.STDERR, consumer);
        this.dockerClient.logContainerCmd(containerId).withFollowStream(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withSince(Integer.valueOf(0)).exec((ResultCallback)callback);
    }

    public synchronized void stop() {
        if (!this.stopContainers) {
            LOG.infov("Skipping compose down for project {0}", (Object)this.project);
            return;
        }
        Object cmd = this.getDownCommand(this.getOptions());
        if (this.removeVolumes) {
            cmd = (String)cmd + " -v";
        }
        if (!this.isExecutablePodman() && !StringUtil.isNullOrEmpty((String)this.removeImages)) {
            cmd = (String)cmd + " --rmi " + this.removeImages;
        }
        cmd = (String)cmd + " -t " + this.stopTimeout.getSeconds();
        try {
            this.runWithCompose((String)cmd, this.env);
        }
        finally {
            this.networks = null;
            this.serviceInstances = null;
        }
    }

    private boolean isExecutablePodman() {
        return this.executable.contains("podman");
    }

    private String getUpCommand(String options) {
        return StringUtil.isNullOrEmpty((String)options) ? "compose up -d" : String.format("compose %s up -d", options);
    }

    private String getDownCommand(String options) {
        return StringUtil.isNullOrEmpty((String)options) ? "compose down" : String.format("compose %s down", options);
    }

    private String getOptions() {
        return String.join((CharSequence)" ", this.options);
    }

    public void runWithCompose(String cmd, Map<String, String> env) {
        new ComposeRunner(this.executable, this.composeFiles.getFiles(), this.project).withCommand(cmd).withEnv(env).withProfiles(this.profiles).run();
    }

    public List<ComposeServiceWaitStrategyTarget> getServices() {
        return this.serviceInstances;
    }

    public Map<String, String> getEnvVarConfig() {
        this.checkServicesStarted();
        return ContainerUtil.getEnvVarConfig(this.serviceInstances, ComposeProject::getEnvVarMappings);
    }

    public Map<String, String> getExposedPortConfig() {
        this.checkServicesStarted();
        return ContainerUtil.getPortConfig(this.serviceInstances, ComposeProject::getHostPortMappings);
    }

    private static Map<Integer, String> getHostPortMappings(InspectContainerResponse containerInfo) {
        Map labels = containerInfo.getConfig().getLabels();
        if (labels == null) {
            return Collections.emptyMap();
        }
        return labels.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("io.quarkus.devservices.compose.config_map.port") && ((String)e.getKey()).length() > "io.quarkus.devservices.compose.config_map.port".length() + 1 && !StringUtil.isNullOrEmpty((String)((String)e.getValue()))).collect(Collectors.toMap(ComposeProject::getContainerPort, Map.Entry::getValue));
    }

    private static int getContainerPort(Map.Entry<String, String> e) {
        return Integer.parseInt(e.getKey().substring("io.quarkus.devservices.compose.config_map.port".length() + 1));
    }

    private static Map<String, String> getEnvVarMappings(InspectContainerResponse containerInfo) {
        Map labels = containerInfo.getConfig().getLabels();
        if (labels == null) {
            return Collections.emptyMap();
        }
        return labels.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("io.quarkus.devservices.compose.config_map.env") && ((String)e.getKey()).length() > "io.quarkus.devservices.compose.config_map.env".length() + 1).collect(Collectors.toMap(ComposeProject::getVarName, e -> StringUtil.isNullOrEmpty((String)((String)e.getValue())) ? ComposeProject.getVarName(e) : (String)e.getValue()));
    }

    private static String getVarName(Map.Entry<String, String> e) {
        return e.getKey().substring("io.quarkus.devservices.compose.config_map.env".length() + 1);
    }

    public List<Network> getNetworks() {
        return this.networks;
    }

    public String getDefaultNetworkId() {
        return this.networks.stream().filter(n -> DEFAULT_NETWORK_NAME.equals(n.getLabels().get("com.docker.compose.network"))).filter(n -> !n.getContainers().isEmpty()).findFirst().map(Network::getId).orElse(this.project + "_default");
    }

    public static class Builder {
        private final ComposeFiles files;
        private final String executable;
        private DockerClient dockerClient = DockerClientFactory.lazyClient();
        private String project;
        private Duration startupTimeout = Duration.ofMinutes(1L);
        private Duration stopTimeout;
        private boolean stopContainers = true;
        private boolean ryukEnabled = true;
        private boolean followContainerLogs = false;
        private boolean removeVolumes = true;
        private Boolean build;
        private String removeImages;
        private List<String> options = Collections.emptyList();
        private List<String> profiles = Collections.emptyList();
        private Map<String, String> env = Collections.emptyMap();
        private Map<String, Integer> scalingPreferences = Collections.emptyMap();

        public Builder(ComposeFiles files, String executable) {
            this.files = files;
            this.project = files.getProjectName();
            this.executable = executable;
        }

        public Builder withDockerClient(DockerClient dockerClient) {
            this.dockerClient = dockerClient;
            return this;
        }

        public Builder withStopContainers(boolean stopContainers) {
            this.stopContainers = stopContainers;
            return this;
        }

        public Builder withRyukEnabled(boolean ryukEnabled) {
            this.ryukEnabled = ryukEnabled;
            return this;
        }

        public Builder withStartupTimeout(Duration duration) {
            this.startupTimeout = duration;
            return this;
        }

        public Builder withStopTimeout(Duration duration) {
            this.stopTimeout = duration;
            return this;
        }

        public Builder withBuild(Boolean build) {
            this.build = build;
            return this;
        }

        public Builder withEnv(Map<String, String> envVariables) {
            this.env = envVariables;
            return this;
        }

        public Builder withOptions(List<String> options) {
            this.options = Collections.unmodifiableList(options);
            return this;
        }

        public Builder withProfiles(List<String> profiles) {
            this.profiles = Collections.unmodifiableList(profiles);
            return this;
        }

        public Builder withScalingPreferences(Map<String, Integer> scalingPreferences) {
            this.scalingPreferences = Collections.unmodifiableMap(scalingPreferences);
            return this;
        }

        public Builder withFollowContainerLogs(boolean followContainerLogs) {
            this.followContainerLogs = followContainerLogs;
            return this;
        }

        public Builder withRemoveImages(String removeImages) {
            this.removeImages = removeImages;
            return this;
        }

        public Builder withRemoveVolumes(boolean removeVolumes) {
            this.removeVolumes = removeVolumes;
            return this;
        }

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public ComposeProject build() {
            return new ComposeProject(this.dockerClient, this.files, this.executable, this.project, this.startupTimeout, this.stopTimeout, this.stopContainers, this.ryukEnabled, this.followContainerLogs, this.removeVolumes, this.removeImages, this.build, this.options, this.profiles, this.scalingPreferences, this.env);
        }
    }
}

