/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment.compose;

import io.quarkus.devservices.deployment.compose.ComposeServiceDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ComposeFile {
    private static final Logger log = Logger.getLogger(ComposeFile.class);
    private final Map<String, Object> composeFileContent;
    private final String composeFileName;
    private final Map<String, ComposeServiceDefinition> serviceNameToDefinition = new HashMap<String, ComposeServiceDefinition>();

    public ComposeFile(File composeFile) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        try (FileInputStream fileInputStream = new FileInputStream(composeFile);){
            this.composeFileContent = (Map)yaml.load((InputStream)fileInputStream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse YAML file from " + composeFile.getAbsolutePath(), e);
        }
        this.composeFileName = composeFile.getAbsolutePath();
        this.parseAndValidate();
    }

    public String getProjectName() {
        return (String)this.composeFileContent.get("name");
    }

    private void parseAndValidate() {
        Map<String, Object> servicesMap;
        Object servicesElement;
        if (this.composeFileContent.containsKey("version")) {
            log.warn((Object)"The 'version' property is deprecated in docker-compose files. It will be ignored.");
        }
        if ((servicesElement = this.composeFileContent.get("services")) == null) {
            log.debugv("Compose file {0} has an unknown format: 'services' is not defined", (Object)this.composeFileName);
            servicesMap = this.composeFileContent;
        } else {
            if (!(servicesElement instanceof Map)) {
                log.debugv("Compose file {0} has an unknown format: 'services' is not Map", (Object)this.composeFileName);
                return;
            }
            servicesMap = (Map<String, Object>)servicesElement;
        }
        for (Map.Entry<String, Object> entry : servicesMap.entrySet()) {
            String serviceName = entry.getKey();
            Object serviceDefinition = entry.getValue();
            if (!(serviceDefinition instanceof Map)) {
                log.debugv("Compose file {0} has an unknown format: service '{0}' is not Map, it will be ignored.", (Object)this.composeFileName, (Object)serviceName);
                continue;
            }
            Map serviceDefinitionMap = (Map)serviceDefinition;
            this.serviceNameToDefinition.put(serviceName, new ComposeServiceDefinition(serviceName, serviceDefinitionMap));
        }
    }

    public Map<String, ComposeServiceDefinition> getServiceDefinitions() {
        return this.serviceNameToDefinition;
    }
}

