/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.devmode.util;

import io.smallrye.common.os.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.jboss.logging.Logger;

public class DevModeClient {
    private static final long DEFAULT_TIMEOUT = OS.current() == OS.WINDOWS ? 3L : 1L;
    private static final Logger LOG = Logger.getLogger(DevModeClient.class);
    private final int port;

    static long getDefaultTimeout() {
        return DEFAULT_TIMEOUT;
    }

    public DevModeClient() {
        this(8080);
    }

    public DevModeClient(int port) {
        this.port = port;
    }

    public static List<ProcessHandle> killDescendingProcesses() {
        List<ProcessHandle> childProcesses = ProcessHandle.current().descendants().sorted((ph1, ph2) -> ph2.info().startInstant().orElse(Instant.EPOCH).compareTo(ph1.info().startInstant().orElse(Instant.EPOCH))).collect(Collectors.toList());
        childProcesses.forEach(ProcessHandle::destroy);
        return childProcesses;
    }

    public static void filter(File input, Map<String, String> variables) throws IOException {
        Assertions.assertThat((File)input).isFile();
        String data = FileUtils.readFileToString((File)input, (String)"UTF-8");
        for (Map.Entry<String, String> token : variables.entrySet()) {
            String value = String.valueOf(token.getValue());
            data = data.replace(token.getKey(), value);
        }
        FileUtils.write((File)input, (CharSequence)data, (String)"UTF-8");
    }

    public void awaitUntilServerDown() {
        Awaitility.await().atMost(DEFAULT_TIMEOUT, TimeUnit.MINUTES).until(() -> {
            try {
                this.get();
                return false;
            }
            catch (Exception e) {
                return true;
            }
        });
    }

    public String getHttpResponse() {
        return this.getHttpResponse(() -> null);
    }

    public String getHttpResponse(Supplier<String> brokenReason) {
        AtomicReference resp = new AtomicReference();
        Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(2L + DEFAULT_TIMEOUT, TimeUnit.MINUTES).until(() -> {
            try {
                String broken = (String)brokenReason.get();
                if (broken != null) {
                    resp.set("BROKEN: " + broken);
                    return true;
                }
                String content = this.get();
                resp.set(content);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        return (String)resp.get();
    }

    public String getHttpErrorResponse() {
        return this.getHttpErrorResponse(() -> null);
    }

    public String getHttpErrorResponse(Supplier<String> brokenReason) {
        AtomicReference resp = new AtomicReference();
        Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(20L, TimeUnit.MINUTES).until(() -> {
            try {
                String broken = (String)brokenReason.get();
                if (broken != null) {
                    resp.set("BROKEN: " + broken);
                    return true;
                }
                boolean content = this.getHttpResponse("/", 500);
                return content;
            }
            catch (Exception e) {
                return false;
            }
        });
        return (String)resp.get();
    }

    public String getHttpResponse(String path) {
        return this.getHttpResponse(path, false);
    }

    public String getHttpResponse(String path, Supplier<String> brokenReason) {
        return this.getHttpResponse(path, false, brokenReason);
    }

    public String getHttpResponse(String path, boolean allowError) {
        return this.getHttpResponse(path, allowError, () -> null);
    }

    public String getHttpResponse(String path, boolean allowError, Supplier<String> brokenReason) {
        return this.getHttpResponse(path, allowError, brokenReason, 1L, TimeUnit.MINUTES);
    }

    public String getHttpResponse(String path, boolean allowError, Supplier<String> brokenReason, long timeout, TimeUnit tu) {
        AtomicReference resp = new AtomicReference();
        Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(timeout, tu).until(() -> {
            String broken = (String)brokenReason.get();
            if (broken != null) {
                resp.set("BROKEN: " + broken);
                return true;
            }
            try {
                String content;
                URL url = this.prepareUrl(path);
                if (!allowError) {
                    content = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
                } else {
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setDefaultUseCaches(false);
                    conn.setUseCaches(false);
                    conn.setRequestProperty("Accept", "text/html, *; q=0.2, */*; q=0.2");
                    content = conn.getResponseCode() >= 400 ? IOUtils.toString((InputStream)conn.getErrorStream(), (Charset)StandardCharsets.UTF_8) : IOUtils.toString((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    conn.disconnect();
                }
                resp.set(content);
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)("An error occurred when DevModeClient accessed " + path + ". It might be a normal testing behavior but logging the exception for information"), (Throwable)e);
                return false;
            }
        });
        return (String)resp.get();
    }

    public boolean getHttpResponse(String path, int expectedStatus) {
        return this.getHttpResponse(path, expectedStatus, 5L, TimeUnit.MINUTES);
    }

    public boolean getHttpResponse(String path, int expectedStatus, long timeout, TimeUnit tu) {
        AtomicBoolean code = new AtomicBoolean();
        Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(timeout, tu).until(() -> {
            try {
                URL url = this.prepareUrl(path);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDefaultUseCaches(false);
                connection.setUseCaches(false);
                connection.setRequestProperty("Accept", "text/html, *; q=0.2, */*; q=0.2");
                if (connection.getResponseCode() == expectedStatus) {
                    code.set(true);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                LOG.error((Object)("An error occurred when DevModeClient accessed " + path + ". It might be a normal testing behavior but logging the exception for information"), (Throwable)e);
                return false;
            }
        });
        return code.get();
    }

    public boolean getStrictHttpResponse(String path, int expectedStatus) {
        AtomicBoolean code = new AtomicBoolean();
        Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).atMost(5L, TimeUnit.MINUTES).until(() -> {
            try {
                URL url = this.prepareUrl(path);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDefaultUseCaches(false);
                connection.setUseCaches(false);
                connection.setRequestProperty("Accept", "text/html, *; q=0.2, */*; q=0.2");
                code.set(connection.getResponseCode() == expectedStatus);
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)("An error occurred when DevModeClient accessed " + path + ". It might be a normal testing behavior but logging the exception for information"), (Throwable)e);
                return false;
            }
        });
        return code.get();
    }

    public String get() throws IOException {
        return this.get("http://localhost:" + this.port);
    }

    public String get(String urlStr) throws IOException {
        return IOUtils.toString((URL)new URL(urlStr), (Charset)StandardCharsets.UTF_8);
    }

    public boolean isCode(String path, int code) {
        try {
            URL url = this.prepareUrl(path);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDefaultUseCaches(false);
            connection.setUseCaches(false);
            connection.setRequestProperty("Accept", "text/html, *; q=0.2, */*; q=0.2");
            return connection.getResponseCode() == code;
        }
        catch (Exception e) {
            return false;
        }
    }

    private URL prepareUrl(String path) throws MalformedURLException {
        String urlString = "http://localhost:" + this.port + (String)(path.startsWith("/") ? path : "/" + path);
        urlString = urlString.contains("?") ? urlString + "&" : urlString + "?";
        urlString = urlString + "_test_timestamp=" + System.currentTimeMillis();
        return new URL(urlString);
    }
}

