/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

final class GraalVM {
    GraalVM() {
    }

    static enum Distribution {
        ORACLE,
        MANDREL;

    }

    static final class Version
    implements Comparable<Version> {
        private static final Pattern PATTERN = Pattern.compile("(GraalVM|native-image)( Version)? (?<version>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)(?<distro>.*?)?(\\(Java Version (?<jfeature>[0-9]+)(\\.(?<jinterim>[0-9]*)\\.(?<jupdate>[0-9]*))?.*)?$");
        static final Version UNVERSIONED = new Version("Undefined", "snapshot", Distribution.ORACLE);
        static final Version VERSION_21_2 = new Version("GraalVM 21.2", "21.2", Distribution.ORACLE);
        static final Version VERSION_21_3 = new Version("GraalVM 21.3", "21.3", Distribution.ORACLE);
        static final Version VERSION_21_3_0 = new Version("GraalVM 21.3.0", "21.3.0", Distribution.ORACLE);
        static final Version MINIMUM = VERSION_21_2;
        static final Version CURRENT = VERSION_21_3;
        public static final int UNDEFINED = -1;
        final String fullVersion;
        final org.graalvm.home.Version version;
        public final int javaFeatureVersion;
        public final int javaUpdateVersion;
        final Distribution distribution;

        Version(String fullVersion, String version, Distribution distro) {
            this(fullVersion, version, 11, -1, distro);
        }

        Version(String fullVersion, String version, int javaFeatureVersion, int javaUpdateVersion, Distribution distro) {
            this.fullVersion = fullVersion;
            this.version = org.graalvm.home.Version.parse((String)version);
            this.javaFeatureVersion = javaFeatureVersion;
            this.javaUpdateVersion = javaUpdateVersion;
            this.distribution = distro;
        }

        String getFullVersion() {
            return this.fullVersion;
        }

        boolean isDetected() {
            return this != UNVERSIONED;
        }

        boolean isObsolete() {
            return this.compareTo(MINIMUM) < 0;
        }

        boolean isMandrel() {
            return this.distribution == Distribution.MANDREL;
        }

        boolean isNewerThan(Version version) {
            return this.compareTo(version) > 0;
        }

        boolean isOlderThan(Version version) {
            return this.compareTo(version) < 0;
        }

        public boolean jdkVersionGreaterOrEqualTo(int feature, int update) {
            return this.javaFeatureVersion > feature || this.javaFeatureVersion == feature && this.javaUpdateVersion >= update;
        }

        boolean is(Version version) {
            return this.compareTo(version) == 0;
        }

        @Override
        public int compareTo(Version o) {
            return this.version.compareTo(o.version);
        }

        static Version of(Stream<String> lines) {
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                Matcher matcher = PATTERN.matcher(line);
                if (!matcher.find()) continue;
                String version = matcher.group("version");
                String distro = matcher.group("distro");
                String jFeatureMatch = matcher.group("jfeature");
                int jFeature = jFeatureMatch == null ? 11 : Integer.parseInt(jFeatureMatch);
                String jUpdateMatch = matcher.group("jupdate");
                int jUpdate = jUpdateMatch == null ? -1 : Integer.parseInt(jUpdateMatch);
                return new Version(line, version, jFeature, jUpdate, Version.isMandrel(distro) ? Distribution.MANDREL : Distribution.ORACLE);
            }
            return UNVERSIONED;
        }

        private static boolean isMandrel(String s) {
            return s != null && s.contains("Mandrel Distribution");
        }

        public String toString() {
            return "Version{version=" + this.version + ", fullVersion=" + this.fullVersion + ", distribution=" + this.distribution + ", javaFeatureVersion=" + this.javaFeatureVersion + ", javaUpdateVersion=" + this.javaUpdateVersion + "}";
        }

        public boolean isJava17() {
            return this.javaFeatureVersion == 17;
        }
    }
}

