/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.dev.testing.ContinuousTestingSharedStateManager;
import java.util.function.Consumer;

public class ContinuousTestingSharedStateListener
implements TestListener {
    private volatile ContinuousTestingSharedStateManager.State lastState;

    @Override
    public void listenerRegistered(TestController testController) {
    }

    @Override
    public void testsEnabled() {
        if (this.lastState == null) {
            ContinuousTestingSharedStateManager.setRunning((boolean)true);
        } else {
            ContinuousTestingSharedStateManager.setLastState(s -> {
                if (s.getLastRun() > this.lastState.lastRun) {
                    return s.setRunning(true).build();
                }
                return s.setRunning(true).setCurrentFailed(this.lastState.currentFailed).setCurrentSkipped(this.lastState.currentSkipped).setCurrentFailed(this.lastState.currentFailed).setFailed(this.lastState.failed).setSkipped(this.lastState.skipped).setPassed(this.lastState.passed).setRun(this.lastState.run).build();
            });
        }
    }

    @Override
    public void testsDisabled() {
        ContinuousTestingSharedStateManager.setRunning((boolean)false);
    }

    @Override
    public void testRunStarted(Consumer<TestRunListener> listenerConsumer) {
        ContinuousTestingSharedStateManager.setInProgress((boolean)true);
        listenerConsumer.accept(new TestRunListener(){

            @Override
            public void runComplete(TestRunResults testRunResults) {
                ContinuousTestingSharedStateManager.setLastState(s -> {
                    ContinuousTestingSharedStateListener.this.lastState = s.setLastRun(testRunResults.getId()).setInProgress(false).setRun(testRunResults.getPassedCount() + testRunResults.getFailedCount() + testRunResults.getSkippedCount()).setPassed(testRunResults.getPassedCount()).setFailed(testRunResults.getFailedCount()).setSkipped(testRunResults.getSkippedCount()).setCurrentPassed(testRunResults.getCurrentPassedCount()).setCurrentFailed(testRunResults.getCurrentFailedCount()).setCurrentSkipped(testRunResults.getCurrentSkippedCount()).build();
                    return ContinuousTestingSharedStateListener.this.lastState;
                });
            }

            @Override
            public void noTests(TestRunResults results) {
                this.runComplete(results);
            }

            @Override
            public void runAborted() {
                ContinuousTestingSharedStateManager.setInProgress((boolean)false);
            }
        });
    }

    @Override
    public void setBrokenOnly(boolean bo) {
        ContinuousTestingSharedStateManager.setBrokenOnly((boolean)bo);
    }

    @Override
    public void setTestOutput(boolean to) {
        ContinuousTestingSharedStateManager.setTestOutput((boolean)to);
    }

    @Override
    public void setInstrumentationBasedReload(boolean ibr) {
        ContinuousTestingSharedStateManager.setInstrumentationBasedReload((boolean)ibr);
    }

    @Override
    public void setLiveReloadEnabled(boolean lre) {
        ContinuousTestingSharedStateManager.setLiveReloadEnabled((boolean)lre);
    }
}

