/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.BaseBuildCommand;
import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.DebugOptions;
import io.quarkus.cli.common.DevOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.common.build.BuildSystemRunner;
import io.quarkus.devtools.project.BuildTool;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import picocli.CommandLine;

@CommandLine.Command(name="test", showEndOfOptionsDelimiterInUsageHelp=true, header={"Run the current project in continuous testing mode."})
public class Test
extends BaseBuildCommand
implements Callable<Integer> {
    @CommandLine.ArgGroup(order=1, exclusive=false, heading="%nContinuous Test Mode options:%n")
    DevOptions testOptions = new DevOptions();
    @CommandLine.ArgGroup(order=3, exclusive=false, validate=true, heading="%nDebug options:%n")
    DebugOptions debugOptions = new DebugOptions();
    @CommandLine.Option(names={"--once"}, description={"Run the test suite with continuous mode disabled."})
    boolean runOnce = false;
    @CommandLine.Option(names={"--filter"}, description={"Run a subset of the test suite that matches the given filter.", "If continuous testing is enabled then the value is a regular expression that is matched against the test class name.", "If continuous testing is disabled then the value is passed as-is to the underlying build tool."})
    String filter;
    @CommandLine.Parameters(description={"Parameters passed to the application."})
    List<String> params = new ArrayList<String>();

    @Override
    public Integer call() {
        try {
            this.output.debug("Run project in test mode with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            BuildSystemRunner runner = this.getRunner();
            if (this.runOnce) {
                BuildOptions buildOptions = new BuildOptions();
                buildOptions.clean = this.testOptions.clean;
                buildOptions.offline = this.testOptions.offline;
                buildOptions.skipTests = !this.testOptions.runTests;
                BuildSystemRunner.BuildCommandArgs commandArgs = runner.prepareTest(buildOptions, new RunModeOption(), this.params, this.filter);
                if (this.testOptions.isDryRun()) {
                    this.dryRunTest(this.spec.commandLine().getHelp(), runner.getBuildTool(), commandArgs, false);
                    return 0;
                }
                return runner.run(commandArgs);
            }
            if (this.filter != null) {
                this.params.add("-Dquarkus.test.include-pattern=" + this.filter);
            }
            List commandArgs = runner.prepareDevTestMode(false, this.testOptions, this.debugOptions, this.params);
            if (this.testOptions.isDryRun()) {
                this.dryRunTest(this.spec.commandLine().getHelp(), runner.getBuildTool(), (BuildSystemRunner.BuildCommandArgs)((Supplier)commandArgs.iterator().next()).get(), true);
                return 0;
            }
            int ret = 1;
            for (Supplier i : commandArgs) {
                ret = runner.run((BuildSystemRunner.BuildCommandArgs)i.get());
                if (ret == 0) continue;
                return ret;
            }
            return ret;
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to launch project in test mode: " + e.getMessage());
        }
    }

    void dryRunTest(CommandLine.Help help, BuildTool buildTool, BuildSystemRunner.BuildCommandArgs args, boolean isContinuous) {
        this.output.printText(new String[]{"\nRun current project in" + (isContinuous ? " continuous" : "") + " test mode\n", "\t" + this.projectRoot().toString()});
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        dryRunOutput.put("Build tool", buildTool.name());
        this.output.info(help.createTextTable(dryRunOutput).toString());
        this.output.printText(new String[]{"\nCommand line:\n", args.showCommand()});
    }

    public String toString() {
        return "Test [debugOptions=" + String.valueOf(this.debugOptions) + ", testOptions=" + String.valueOf(this.testOptions) + ", properties=" + String.valueOf(this.propertiesOptions.properties) + ", output=" + String.valueOf(this.output) + ", params=" + String.valueOf(this.params) + "]";
    }
}

