/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import io.quarkus.devtools.project.BuildTool;
import picocli.CommandLine;

public class TargetBuildToolGroup {
    @CommandLine.Option(names={"--jbang"}, description={"Use JBang (Java only)"})
    boolean jbang = false;
    @CommandLine.Option(names={"--maven"}, description={"Use Maven"})
    boolean maven = false;
    @CommandLine.Option(names={"--gradle"}, description={"Use Gradle"})
    boolean gradle = false;
    @CommandLine.Option(names={"--gradle-kotlin-dsl"}, description={"Use Gradle with Kotlin DSL"})
    boolean gradleKotlinDsl = false;

    public boolean isBuildless() {
        return this.jbang;
    }

    public BuildTool getBuildTool(BuildTool defaultTool) {
        if (this.gradleKotlinDsl) {
            return BuildTool.GRADLE_KOTLIN_DSL;
        }
        if (this.gradle) {
            return BuildTool.GRADLE;
        }
        if (this.jbang) {
            return BuildTool.JBANG;
        }
        if (this.maven) {
            return BuildTool.MAVEN;
        }
        return defaultTool;
    }

    public String toString() {
        return "TargetBuildToolGroup [gradle=" + this.gradle + ", gradleKotlinDsl=" + this.gradleKotlinDsl + ", jbang=" + this.jbang + ", maven=" + this.maven + "]";
    }
}

