/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.image;

import io.quarkus.cli.BuildToolContext;
import io.quarkus.cli.image.BaseImageCommand;
import io.quarkus.cli.image.Buildpack;
import io.quarkus.cli.image.Docker;
import io.quarkus.cli.image.Jib;
import io.quarkus.cli.image.Openshift;
import io.quarkus.cli.image.Podman;
import io.quarkus.devtools.project.BuildTool;
import java.util.Map;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="build", sortOptions=false, showDefaultValues=true, mixinStandardHelpOptions=false, header={"Build a container image."}, description={"%nThis command will build a container image for the project."}, subcommands={Docker.class, Podman.class, Buildpack.class, Jib.class, Openshift.class}, footer={"%nFor example (using default values), it will create a container image using docker with REPOSITORY='${user.name}/<project.artifactId>' and TAG='<project.version>'.%n"}, headerHeading="%n", commandListHeading="%nCommands:%n", synopsisHeading="%nUsage: ", parameterListHeading="%n", optionListHeading="Options:%n")
public class Build
extends BaseImageCommand {
    private static final String FALLBACK_BUILDER = "docker";
    private static final Map<BuildTool, String> ACTION_MAPPING = Map.of(BuildTool.MAVEN, "quarkus:image-build", BuildTool.GRADLE, "imageBuild");

    @Override
    public void populateContext(BuildToolContext context) {
        super.populateContext(context);
        Map<String, String> properties = context.getPropertiesOptions().properties;
        if (!properties.containsKey("quarkus.container-image.builder")) {
            properties.put("quarkus.container-image.builder", FALLBACK_BUILDER);
        }
        if (context.getForcedExtensions().isEmpty()) {
            context.getForcedExtensions().add("io.quarkus:quarkus-container-image-docker");
        }
    }

    @Override
    public void prepareGradle(BuildToolContext context) {
        super.prepareGradle(context);
        Optional<String> builder = Optional.ofNullable(context.getPropertiesOptions().properties.remove("quarkus.container-image.builder"));
        context.getParams().add("--builder=" + builder.orElse(FALLBACK_BUILDER));
    }

    @Override
    public Map<BuildTool, String> getActionMapping() {
        return ACTION_MAPPING;
    }

    public String toString() {
        return "Build {imageOptions='" + String.valueOf(this.imageOptions) + "'}";
    }
}

