/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.logging;

import io.quarkus.bootstrap.graal.ImageInfo;
import io.quarkus.bootstrap.logging.QuarkusDelayedHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.ConsoleHandler;

public final class InitialConfigurator
implements EmbeddedConfigurator {
    public static final QuarkusDelayedHandler DELAYED_HANDLER = new QuarkusDelayedHandler();

    public Level getMinimumLevelOf(String loggerName) {
        return Level.ALL;
    }

    public Level getLevelOf(String loggerName) {
        return loggerName.isEmpty() ? Level.ALL : null;
    }

    public Handler[] getHandlersOf(String loggerName) {
        if (loggerName.isEmpty()) {
            if (ImageInfo.inImageBuildtimeCode()) {
                return new Handler[]{InitialConfigurator.createDefaultHandler()};
            }
            return new Handler[]{DELAYED_HANDLER};
        }
        return EmbeddedConfigurator.NO_HANDLERS;
    }

    public static ConsoleHandler createDefaultHandler() {
        ConsoleHandler handler = new ConsoleHandler((Formatter)new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{3.}] %s%e%n"));
        handler.setLevel(Level.INFO);
        return handler;
    }
}

