/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.AbstractClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.ManifestAttributes;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class PathTreeClassPathElement
extends AbstractClassPathElement {
    private static final Logger log = Logger.getLogger(PathTreeClassPathElement.class);
    private final ReadWriteLock lock;
    private final OpenPathTree pathTree;
    private final boolean runtime;
    private final ResolvedDependency resolvedDependency;
    private volatile Set<String> resources;

    public PathTreeClassPathElement(PathTree pathTree, boolean runtime) {
        this(pathTree, runtime, null);
    }

    public PathTreeClassPathElement(PathTree pathTree, boolean runtime, ResolvedDependency resolvedDependency) {
        this.pathTree = Objects.requireNonNull(pathTree, "Path tree is null").open();
        this.lock = new ReentrantReadWriteLock();
        this.runtime = runtime;
        this.resolvedDependency = resolvedDependency;
    }

    @Override
    public boolean isRuntime() {
        return this.runtime;
    }

    @Override
    public ResolvedDependency getResolvedDependency() {
        return this.resolvedDependency;
    }

    @Override
    public Path getRoot() {
        return (Path)this.pathTree.getOriginalTree().getRoots().iterator().next();
    }

    private static String sanitize(String path) {
        int i = path.indexOf("//");
        if (i < 0) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path.length());
        sb.append(path, 0, ++i);
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c == '/') {
                ++i;
                continue;
            }
            int j = path.indexOf("//", i + 1);
            if (j < 0) {
                sb.append(path, i, path.length());
                break;
            }
            sb.append(path, i, ++j);
            i = j;
        }
        return sb.toString();
    }

    @Override
    public ClassPathResource getResource(String name) {
        String sanitized = PathTreeClassPathElement.sanitize(name);
        Set<String> resources = this.resources;
        if (resources != null && !resources.contains(sanitized)) {
            return null;
        }
        return this.apply(tree -> (Resource)tree.apply(sanitized, visit -> visit == null ? null : new Resource((PathVisit)visit)));
    }

    @Override
    public List<ClassPathResource> getResources(String name) {
        String sanitized = PathTreeClassPathElement.sanitize(name);
        Set<String> resources = this.resources;
        if (resources != null && !resources.contains(sanitized)) {
            return List.of();
        }
        ArrayList<ClassPathResource> ret = new ArrayList<ClassPathResource>();
        this.apply(tree -> {
            tree.acceptAll(sanitized, visit -> {
                if (visit != null) {
                    ret.add(new Resource((PathVisit)visit));
                }
            });
            return List.of();
        });
        return ret;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> T apply(Function<OpenPathTree, T> func) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Set<String> getProvidedResources() {
        Set resources = this.resources;
        if (resources == null) {
            this.resources = resources = this.apply(tree -> {
                final HashSet relativePaths = new HashSet();
                tree.walk(new PathVisitor(){

                    public void visitPath(PathVisit visit) {
                        String relativePath = visit.getRelativePath("/");
                        if (relativePath.isEmpty()) {
                            return;
                        }
                        relativePaths.add(relativePath);
                    }
                });
                return relativePaths;
            });
        }
        return resources;
    }

    @Override
    public boolean containsReloadableResources() {
        return !this.pathTree.isArchiveOrigin();
    }

    @Override
    protected ManifestAttributes readManifest() {
        return this.apply(PathTree::getManifestAttributes);
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        URL url = null;
        Path root = this.getRoot();
        try {
            url = root.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create protection domain for " + String.valueOf(root), e);
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        return new ProtectionDomain(codesource, null);
    }

    @Override
    public void close() throws IOException {
        this.lock.writeLock().lock();
        this.resources = null;
        try {
            this.pathTree.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[");
        if (this.getDependencyKey() != null) {
            sb.append(this.getDependencyKey().toGacString()).append(" ");
        }
        sb.append(this.pathTree.getOriginalTree().toString());
        sb.append(" runtime=").append(this.isRuntime());
        Set<String> resources = this.resources;
        sb.append(" resources=").append(resources == null ? "null" : Integer.valueOf(resources.size()));
        return sb.append(']').toString();
    }

    private class Resource
    implements ClassPathResource {
        private final String name;
        private final Path path;
        private volatile URL url;

        private Resource(PathVisit visit) {
            this.name = visit.getRelativePath("/");
            this.path = visit.getPath();
        }

        @Override
        public ClassPathElement getContainingElement() {
            return PathTreeClassPathElement.this;
        }

        @Override
        public String getPath() {
            return this.name;
        }

        @Override
        public URL getUrl() {
            if (this.url != null) {
                return this.url;
            }
            PathTreeClassPathElement.this.lock.readLock().lock();
            try {
                if (PathTreeClassPathElement.this.pathTree.isOpen()) {
                    URL url;
                    URI uri = this.path.toUri();
                    if (uri.getPath() != null && uri.getPath().endsWith("/")) {
                        String uriStr = uri.toString();
                        url = new URL(uriStr.substring(0, uriStr.length() - 1));
                    } else {
                        url = uri.toURL();
                    }
                    if (url.getQuery() != null) {
                        url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath().replaceAll("\\?", "%3F") + "%3F" + url.getQuery());
                    }
                    URL uRL = this.url = url;
                    return uRL;
                }
                URL uri = this.url = PathTreeClassPathElement.this.apply(tree -> (URL)tree.apply(this.name, visit -> visit == null ? null : visit.getUrl()));
                return uri;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to translate " + String.valueOf(this.path) + " to URL", e);
            }
            finally {
                PathTreeClassPathElement.this.lock.readLock().unlock();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public byte[] getData() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isDirectory() {
            PathTreeClassPathElement.this.lock.readLock().lock();
            try {
                if (PathTreeClassPathElement.this.pathTree.isOpen()) {
                    boolean bl = Files.isDirectory(this.path, new LinkOption[0]);
                    return bl;
                }
                boolean bl = PathTreeClassPathElement.this.apply(tree -> (Boolean)tree.apply(this.name, visit -> visit == null ? null : Boolean.valueOf(Files.isDirectory(visit.getPath(), new LinkOption[0]))));
                return bl;
            }
            finally {
                PathTreeClassPathElement.this.lock.readLock().unlock();
            }
        }

        private /* synthetic */ byte[] lambda$getData$2(PathVisit visit) {
            if (visit == null) {
                return null;
            }
            try {
                return Files.readAllBytes(visit.getPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read " + this.name, e);
            }
        }
    }
}

