/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.update;

import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.update.UpdateDiscovery;
import io.quarkus.bootstrap.resolver.update.VersionUpdateNumber;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.List;

public class DefaultUpdateDiscovery
implements UpdateDiscovery {
    private final AppModelResolver resolver;
    private final VersionUpdateNumber updateNumber;

    public DefaultUpdateDiscovery(AppModelResolver resolver, VersionUpdateNumber updateNumber) {
        this.resolver = resolver;
        this.updateNumber = updateNumber;
    }

    @Override
    public List<String> listUpdates(ResolvedDependency artifact) {
        try {
            return this.resolver.listLaterVersions((ArtifactCoords)artifact, this.resolveUpToVersion(artifact), false);
        }
        catch (AppModelResolverException e) {
            throw new RuntimeException("Failed to collect later versions", e);
        }
    }

    @Override
    public String getNextVersion(ResolvedDependency artifact) {
        try {
            return this.resolver.getNextVersion((ArtifactCoords)artifact, this.getFromVersion(artifact), true, this.resolveUpToVersion(artifact), false);
        }
        catch (AppModelResolverException e) {
            throw new RuntimeException("Failed to determine the next available version", e);
        }
    }

    @Override
    public String getLatestVersion(ResolvedDependency artifact) {
        try {
            return this.resolver.getLatestVersion((ArtifactCoords)artifact, this.resolveUpToVersion(artifact), false);
        }
        catch (AppModelResolverException e) {
            throw new RuntimeException("Failed to determine the latest available version", e);
        }
    }

    private String resolveUpToVersion(ResolvedDependency artifact) {
        long minor;
        if (this.updateNumber == VersionUpdateNumber.MAJOR) {
            return null;
        }
        String version = artifact.getVersion();
        int majorMinorSep = version.indexOf(46);
        if (majorMinorSep <= 0) {
            throw new RuntimeException("Failed to determine the major version in " + version);
        }
        String majorStr = version.substring(0, majorMinorSep);
        if (this.updateNumber == VersionUpdateNumber.MINOR) {
            long major;
            try {
                major = Long.parseLong(majorStr);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("The version is expected to start with a number indicating the major version: " + version);
            }
            return String.valueOf(major + 1L) + ".alpha";
        }
        int minorMicroSep = version.indexOf(46, majorMinorSep + 1);
        if (minorMicroSep <= 0) {
            throw new RuntimeException("Failed to determine the minor version in " + version);
        }
        String minorStr = version.substring(majorMinorSep + 1, minorMicroSep);
        try {
            minor = Long.parseLong(minorStr);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to parse the minor number in version: " + version);
        }
        return majorStr + "." + String.valueOf(minor + 1L) + ".alpha";
    }

    private String getFromVersion(ResolvedDependency artifact) {
        long micro;
        String version = artifact.getVersion();
        int majorMinorSep = version.indexOf(46);
        if (majorMinorSep <= 0) {
            throw new RuntimeException("Failed to determine the major version in " + version);
        }
        String majorStr = version.substring(0, majorMinorSep);
        if (this.updateNumber == VersionUpdateNumber.MAJOR) {
            long major;
            try {
                major = Long.parseLong(majorStr);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("The version is expected to start with a number indicating the major version: " + version);
            }
            return String.valueOf(major + 1L) + ".alpha";
        }
        int minorMicroSep = version.indexOf(46, majorMinorSep + 1);
        if (minorMicroSep <= 0) {
            throw new RuntimeException("Failed to determine the minor version in " + version);
        }
        String minorStr = version.substring(majorMinorSep + 1, minorMicroSep);
        if (this.updateNumber == VersionUpdateNumber.MINOR) {
            long minor;
            try {
                minor = Long.parseLong(minorStr);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse the minor number in version: " + version);
            }
            return majorStr + "." + String.valueOf(minor + 1L) + ".alpha";
        }
        if (minorMicroSep == version.length() - 1) {
            throw new RuntimeException("Failed to determine the micro version in " + version);
        }
        String microStr = version.substring(minorMicroSep + 1);
        try {
            micro = Long.parseLong(microStr);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to parse the micro number in version: " + version);
        }
        return majorStr + "." + minorStr + "." + String.valueOf(micro + 1L) + ".alpha";
    }
}

