/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.TsJar;
import io.quarkus.bootstrap.resolver.TsQuarkusExt;
import io.quarkus.bootstrap.resolver.TsRepoBuilder;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.util.IoUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.DefaultSettingsWriter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class ResolverSetupCleanup {
    protected Path workDir;
    private Path repoHome;
    private Path localRepoHome;
    private Path settingsXml;
    protected BootstrapAppModelResolver resolver;
    protected TsRepoBuilder repo;
    protected Map<String, String> originalProps;

    @BeforeEach
    public void setup() throws Exception {
        block11: {
            this.setSystemProperties();
            this.workDir = this.initWorkDir();
            this.repoHome = IoUtils.mkdirs((Path)this.workDir.resolve("repo"));
            if (this.setupCustomMavenRepoInSettings()) {
                this.localRepoHome = IoUtils.mkdirs((Path)this.workDir).resolve("local-repo");
                Settings settings = new Settings();
                Profile profile = new Profile();
                Activation activation = new Activation();
                activation.setActiveByDefault(true);
                profile.setActivation(activation);
                Repository repo = new Repository();
                repo.setId("custom-repo");
                repo.setName("Custom Test Repo");
                repo.setLayout("default");
                try {
                    repo.setUrl(this.repoHome.toUri().toURL().toExternalForm());
                }
                catch (MalformedURLException e) {
                    throw new BootstrapMavenException("Failed to initialize Maven repo URL", (Throwable)e);
                }
                RepositoryPolicy policy = new RepositoryPolicy();
                policy.setEnabled(true);
                policy.setChecksumPolicy("ignore");
                policy.setUpdatePolicy("never");
                repo.setReleases(policy);
                repo.setSnapshots(policy);
                profile.setId("custom-repo");
                profile.addRepository(repo);
                settings.addProfile(profile);
                this.settingsXml = this.workDir.resolve("settings.xml");
                try (BufferedWriter writer = Files.newBufferedWriter(this.settingsXml, new OpenOption[0]);){
                    new DefaultSettingsWriter().write((Writer)writer, Map.of(), settings);
                    break block11;
                }
                catch (IOException e) {
                    throw new BootstrapMavenException("Failed to persist settings.xml", (Throwable)e);
                }
            }
            this.localRepoHome = this.repoHome;
        }
        this.resolver = this.newAppModelResolver(null);
        this.repo = TsRepoBuilder.getInstance(this.newArtifactResolver(null, true), this.workDir);
    }

    @AfterEach
    public void cleanup() {
        if (this.cleanWorkDir() && this.workDir != null) {
            IoUtils.recursiveDelete((Path)this.workDir);
        }
        if (this.originalProps != null) {
            for (Map.Entry<String, String> prop : this.originalProps.entrySet()) {
                if (prop.getValue() == null) {
                    System.clearProperty(prop.getKey());
                    continue;
                }
                System.setProperty(prop.getKey(), prop.getValue());
            }
            this.originalProps = null;
        }
    }

    protected Path getInstallDir() {
        return this.repoHome;
    }

    protected boolean setupCustomMavenRepoInSettings() {
        return false;
    }

    protected void setSystemProperties() {
    }

    protected void setSystemProperty(String name, String value) {
        if (this.originalProps == null) {
            this.originalProps = new HashMap<String, String>();
        }
        String prevValue = System.setProperty(name, value);
        if (!this.originalProps.containsKey(name)) {
            this.originalProps.put(name, prevValue);
        }
    }

    protected Path initWorkDir() {
        return IoUtils.createRandomTmpDir();
    }

    protected Path getSettingsXml() {
        return this.settingsXml;
    }

    protected boolean cleanWorkDir() {
        return true;
    }

    protected boolean isBootstrapForTestMode() {
        return false;
    }

    protected BootstrapAppModelResolver newAppModelResolver(LocalProject currentProject) throws Exception {
        BootstrapAppModelResolver appModelResolver = new BootstrapAppModelResolver(this.newArtifactResolver(currentProject));
        if (this.isBootstrapForTestMode()) {
            appModelResolver.setTest(true);
        }
        return appModelResolver;
    }

    protected MavenArtifactResolver newArtifactResolver(LocalProject currentProject) throws BootstrapMavenException {
        return this.newArtifactResolver(currentProject, false);
    }

    private MavenArtifactResolver newArtifactResolver(LocalProject currentProject, boolean forInstalling) throws BootstrapMavenException {
        MavenArtifactResolver.Builder builder = (MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setOffline(true)).setWorkspaceDiscovery(false)).setCurrentProject(currentProject);
        if (forInstalling) {
            builder.setLocalRepository(this.repoHome.toString());
        } else {
            builder.setLocalRepository(this.localRepoHome.toString());
            if (this.settingsXml != null) {
                ((MavenArtifactResolver.Builder)builder.setUserSettings(this.settingsXml.toFile())).setOffline(false);
            }
        }
        return builder.build();
    }

    protected TsJar newJar() throws IOException {
        return new TsJar(this.workDir.resolve(UUID.randomUUID().toString()));
    }

    protected TsQuarkusExt install(TsQuarkusExt extension) {
        extension.install(this.repo);
        return extension;
    }

    protected TsArtifact install(TsArtifact artifact) {
        this.repo.install(artifact);
        return artifact;
    }

    protected TsArtifact install(TsArtifact artifact, Path p) {
        this.repo.install(artifact, p);
        return artifact;
    }
}

