/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model.gradle.impl;

import io.quarkus.bootstrap.model.gradle.Dependency;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DependencyImpl
implements Dependency,
Serializable {
    private final String name;
    private final String groupId;
    private final String version;
    private final String classifier;
    private final Set<File> paths = new HashSet<File>();
    private final String scope;
    private final String type;

    public DependencyImpl(String name, String groupId, String version, File path, String scope, String type, String classifier) {
        this(name, groupId, version, scope, type, classifier);
        this.paths.add(path);
    }

    public DependencyImpl(String name, String groupId, String version, String scope, String type, String classifier) {
        this.name = name;
        this.groupId = groupId;
        this.version = version;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public Set<File> getPaths() {
        return this.paths;
    }

    public void addPath(File path) {
        this.paths.add(path);
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    public String toString() {
        return "DependencyImpl{name='" + this.name + "', groupId='" + this.groupId + "', version='" + this.version + "', type='" + this.type + "', path=" + this.paths + ", classifier= " + this.classifier + ", scope='" + this.scope + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyImpl that = (DependencyImpl)o;
        return this.name.equals(that.name) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.paths.equals(that.paths) && this.scope.equals(that.scope) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.groupId, this.version, this.paths, this.scope, this.type);
    }
}

