/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.amazon.lambda.runtime.MockEventServer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class MockHttpEventServer
extends MockEventServer {
    private final ObjectWriter eventWriter;
    private final ObjectReader responseReader;

    public MockHttpEventServer() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        this.eventWriter = objectMapper.writerFor(APIGatewayV2HTTPEvent.class);
        this.responseReader = objectMapper.readerFor(APIGatewayV2HTTPResponse.class);
    }

    protected void defaultHandlerSetup() {
        this.router.route().handler(this::handleHttpRequests);
    }

    public void handleHttpRequests(RoutingContext ctx) {
        String requestId = ctx.request().getHeader("Lambda-Runtime-Aws-Request-Id");
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        ctx.put("Lambda-Runtime-Aws-Request-Id", (Object)requestId);
        String traceId = ctx.request().getHeader("Lambda-Runtime-Aws-Request-Id");
        if (traceId == null) {
            traceId = UUID.randomUUID().toString();
        }
        ctx.put("Lambda-Runtime-Trace-Id", (Object)traceId);
        Buffer body = ctx.getBody();
        APIGatewayV2HTTPEvent event = new APIGatewayV2HTTPEvent();
        event.setRequestContext(new APIGatewayV2HTTPEvent.RequestContext());
        event.getRequestContext().setHttp(new APIGatewayV2HTTPEvent.RequestContext.Http());
        event.getRequestContext().getHttp().setMethod(ctx.request().method().name());
        event.getRequestContext().getHttp().setSourceIp(ctx.request().connection().remoteAddress().hostAddress());
        event.setRawPath(ctx.request().path());
        event.setRawQueryString(ctx.request().query());
        for (String header : ctx.request().headers().names()) {
            String expect;
            if (header.equalsIgnoreCase("Expect") && (expect = ctx.request().getHeader("Expect")) != null && expect.equalsIgnoreCase("100-continue")) continue;
            if (event.getHeaders() == null) {
                event.setHeaders(new HashMap());
            }
            List values = ctx.request().headers().getAll(header);
            String value = String.join((CharSequence)",", values);
            event.getHeaders().put(header, value);
        }
        if (body != null) {
            String ct = ctx.request().getHeader("content-type");
            if (ct == null || this.isBinary(ct)) {
                String encoded = Base64.getEncoder().encodeToString(body.getBytes());
                event.setBody(encoded);
                event.setIsBase64Encoded(true);
            } else {
                event.setBody(new String(body.getBytes(), StandardCharsets.UTF_8));
            }
        }
        try {
            byte[] mEvent = this.eventWriter.writeValueAsBytes((Object)event);
            ctx.put(APIGatewayV2HTTPEvent.class.getName(), (Object)mEvent);
            log.debugf("Putting message %s into the queue", (Object)requestId);
            this.queue.put(ctx);
        }
        catch (Exception e) {
            log.error((Object)"Publish failure", (Throwable)e);
            ctx.fail(500);
        }
    }

    protected String getEventContentType(RoutingContext request) {
        if (request.get(APIGatewayV2HTTPEvent.class.getName()) != null) {
            return "application/json";
        }
        return super.getEventContentType(request);
    }

    protected Buffer processEventBody(RoutingContext request) {
        byte[] buf = (byte[])request.get(APIGatewayV2HTTPEvent.class.getName());
        if (buf != null) {
            return Buffer.buffer((byte[])buf);
        }
        return super.processEventBody(request);
    }

    public void processResponse(RoutingContext ctx, RoutingContext pending, Buffer buffer) {
        block13: {
            if (pending.get(APIGatewayV2HTTPEvent.class.getName()) != null) {
                try {
                    APIGatewayV2HTTPResponse res = (APIGatewayV2HTTPResponse)this.responseReader.readValue(buffer.getBytes());
                    HttpServerResponse response = pending.response();
                    if (res.getHeaders() != null) {
                        for (Map.Entry header : res.getHeaders().entrySet()) {
                            if (MockHttpEventServer.canHaveCommaValue((String)((String)header.getKey()))) {
                                response.headers().add((String)header.getKey(), (String)header.getValue());
                                continue;
                            }
                            for (String val : ((String)header.getValue()).split(",")) {
                                response.headers().add((String)header.getKey(), val);
                            }
                        }
                    }
                    if (res.getCookies() != null) {
                        for (String cookie : res.getCookies()) {
                            response.headers().add("set-cookie", cookie);
                        }
                    }
                    response.setStatusCode(res.getStatusCode());
                    String body = res.getBody();
                    if (body != null) {
                        if (res.getIsBase64Encoded()) {
                            byte[] bytes = Base64.getDecoder().decode(body);
                            response.end(Buffer.buffer((byte[])bytes));
                        } else {
                            response.end(body);
                        }
                        break block13;
                    }
                    response.end();
                }
                catch (IOException e) {
                    log.error((Object)"Publish failure", (Throwable)e);
                    pending.fail(500);
                }
            } else {
                super.processResponse(ctx, pending, buffer);
            }
        }
    }

    private boolean isBinary(String contentType) {
        if (contentType != null) {
            String ct = contentType.toLowerCase(Locale.ROOT);
            return !ct.startsWith("text") && !ct.contains("json") && !ct.contains("xml") && !ct.contains("yaml");
        }
        return false;
    }
}

