/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import io.netty.handler.codec.DecoderException;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.impl.BodyHandlerImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MockBodyHandler
implements BodyHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BodyHandlerImpl.class);
    private long bodyLimit = -1L;
    private String uploadsDir;
    private boolean mergeFormAttributes = true;
    private boolean isPreallocateBodyBuffer = false;
    private static final int DEFAULT_INITIAL_BODY_BUFFER_SIZE = 1024;

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
            context.next();
            return;
        }
        if (!((RoutingContextInternal)context).seenHandler(2)) {
            long contentLength = this.isPreallocateBodyBuffer ? this.parseContentLengthHeader(request) : -1L;
            BHandler handler = new BHandler(context, contentLength);
            request.handler((Handler)handler);
            request.endHandler(v -> handler.end());
            ((RoutingContextInternal)context).visitHandler(2);
        } else {
            if (this.mergeFormAttributes && request.isExpectMultipart()) {
                request.params().addAll(request.formAttributes());
            }
            context.next();
        }
    }

    public BodyHandler setHandleFileUploads(boolean handleFileUploads) {
        throw new IllegalStateException("Not Allowed");
    }

    public BodyHandler setBodyLimit(long bodyLimit) {
        this.bodyLimit = bodyLimit;
        return this;
    }

    public BodyHandler setUploadsDirectory(String uploadsDirectory) {
        this.uploadsDir = uploadsDirectory;
        return this;
    }

    public BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) {
        this.mergeFormAttributes = mergeFormAttributes;
        return this;
    }

    public BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) {
        return this;
    }

    public BodyHandler setPreallocateBodyBuffer(boolean isPreallocateBodyBuffer) {
        this.isPreallocateBodyBuffer = isPreallocateBodyBuffer;
        return this;
    }

    private long parseContentLengthHeader(HttpServerRequest request) {
        String contentLength = request.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        try {
            long parsedContentLength = Long.parseLong(contentLength);
            return parsedContentLength < 0L ? -1L : parsedContentLength;
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private class BHandler
    implements Handler<Buffer> {
        private static final int MAX_PREALLOCATED_BODY_BUFFER_BYTES = 65535;
        final RoutingContext context;
        final long contentLength;
        Buffer body;
        boolean failed;
        AtomicInteger uploadCount = new AtomicInteger();
        AtomicBoolean cleanup = new AtomicBoolean(false);
        boolean ended;
        long uploadSize = 0L;

        public BHandler(RoutingContext context, long contentLength) {
            this.context = context;
            this.contentLength = contentLength;
            if (contentLength != -1L) {
                this.initBodyBuffer();
            }
            context.request().exceptionHandler(t -> {
                if (t instanceof DecoderException) {
                    context.fail(400, t.getCause());
                } else {
                    context.fail(t);
                }
            });
        }

        private void initBodyBuffer() {
            int initialBodyBufferSize = this.contentLength < 0L ? 1024 : (this.contentLength > 65535L ? 65535 : (int)this.contentLength);
            if (MockBodyHandler.this.bodyLimit != -1L) {
                initialBodyBufferSize = (int)Math.min((long)initialBodyBufferSize, MockBodyHandler.this.bodyLimit);
            }
            this.body = Buffer.buffer((int)initialBodyBufferSize);
        }

        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (MockBodyHandler.this.bodyLimit != -1L && this.uploadSize > MockBodyHandler.this.bodyLimit) {
                this.failed = true;
                this.context.fail(413);
            } else {
                if (this.body == null) {
                    this.initBodyBuffer();
                }
                this.body.appendBuffer(buff);
            }
        }

        void end() {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed) {
                return;
            }
            HttpServerRequest req = this.context.request();
            if (MockBodyHandler.this.mergeFormAttributes && req.isExpectMultipart()) {
                req.params().addAll(req.formAttributes());
            }
            this.context.setBody(this.body);
            this.body = null;
            this.context.next();
        }
    }
}

