/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.quarkus.amazon.lambda.deployment.AmazonLambdaBuildItem;
import io.quarkus.amazon.lambda.deployment.LambdaObjectMapperInitializedBuildItem;
import io.quarkus.amazon.lambda.deployment.ProvidedAmazonLambdaHandlerBuildItem;
import io.quarkus.amazon.lambda.deployment.RequestHandlerJandexUtil;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaRecorder;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaStaticRecorder;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.amazon.lambda.runtime.LambdaBuildTimeConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import jakarta.inject.Named;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.joda.time.DateTime;

public final class AmazonLambdaProcessor {
    public static final String AWS_LAMBDA_EVENTS_ARCHIVE_MARKERS = "com/amazonaws/services/lambda/runtime/events";
    private static final DotName REQUEST_HANDLER = DotName.createSimple(RequestHandler.class);
    private static final DotName REQUEST_STREAM_HANDLER = DotName.createSimple(RequestStreamHandler.class);
    private static final DotName SKILL_STREAM_HANDLER = DotName.createSimple((String)"com.amazon.ask.SkillStreamHandler");
    private static final DotName NAMED = DotName.createSimple((String)Named.class.getName());
    private static final Logger log = Logger.getLogger(AmazonLambdaProcessor.class);
    private static final Predicate<ClassInfo> INCLUDE_HANDLER_PREDICATE = new Predicate<ClassInfo>(){

        @Override
        public boolean test(ClassInfo classInfo) {
            return !classInfo.isAbstract() && !classInfo.hasAnnotation(DotNames.DECORATOR);
        }
    };

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.AMAZON_LAMBDA);
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem(AWS_LAMBDA_EVENTS_ARCHIVE_MARKERS);
    }

    @BuildStep
    List<AmazonLambdaBuildItem> discover(CombinedIndexBuildItem combinedIndexBuildItem, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer) throws BuildException {
        ArrayList<ClassInfo> requestHandlers = new ArrayList<ClassInfo>(combinedIndexBuildItem.getIndex().getAllKnownImplementations(REQUEST_HANDLER).stream().filter(INCLUDE_HANDLER_PREDICATE).toList());
        ArrayList<ClassInfo> streamHandlers = new ArrayList<ClassInfo>(combinedIndexBuildItem.getIndex().getAllKnownImplementations(REQUEST_STREAM_HANDLER).stream().filter(INCLUDE_HANDLER_PREDICATE).toList());
        streamHandlers.addAll(combinedIndexBuildItem.getIndex().getAllKnownSubclasses(SKILL_STREAM_HANDLER).stream().filter(INCLUDE_HANDLER_PREDICATE).toList());
        if (!(requestHandlers.isEmpty() && streamHandlers.isEmpty() || !providedLambda.isPresent())) {
            throw new BuildException("Multiple handler classes.  You have a custom handler class and the " + providedLambda.get().getProvider() + " extension.  Please remove one of them from your deployment.", List.of());
        }
        AdditionalBeanBuildItem.Builder additionalBeansBuilder = AdditionalBeanBuildItem.builder().setUnremovable();
        ArrayList<AmazonLambdaBuildItem> amazonLambdas = new ArrayList<AmazonLambdaBuildItem>();
        for (ClassInfo requestHandler : requestHandlers) {
            if (requestHandler.isAbstract()) continue;
            additionalBeansBuilder.addBeanClass(requestHandler.name().toString());
            amazonLambdas.add(new AmazonLambdaBuildItem(requestHandler.name().toString(), AmazonLambdaProcessor.getCdiName(requestHandler), false));
        }
        for (ClassInfo streamHandler : streamHandlers) {
            if (streamHandler.isAbstract()) continue;
            additionalBeansBuilder.addBeanClass(streamHandler.name().toString());
            amazonLambdas.add(new AmazonLambdaBuildItem(streamHandler.name().toString(), AmazonLambdaProcessor.getCdiName(streamHandler), true));
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)additionalBeansBuilder.build());
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{FunctionError.class}).methods().fields().reason(this.getClass().getName()).build());
        return amazonLambdas;
    }

    @BuildStep
    void processProvidedLambda(Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer) {
        if (!providedLambda.isPresent()) {
            return;
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        Class handlerClass = providedLambda.get().getHandlerClass();
        builder.addBeanClass(handlerClass);
        additionalBeanBuildItemBuildProducer.produce((BuildItem)builder.build());
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{handlerClass}).methods().fields().reason(this.getClass().getName()).build());
        for (Method method : handlerClass.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals("handleRequest") || method.getParameterCount() != 2 || (parameterTypes = method.getParameterTypes())[0].equals(Object.class)) continue;
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{parameterTypes[0].getName()}).reason(this.getClass().getName() + " > " + method.getName() + " first parameter type").methods().fields().build());
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{method.getReturnType().getName()}).reason(this.getClass().getName() + " > " + method.getName() + " return type").methods().fields().build());
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{DateTime.class}).reason(this.getClass().getName()).methods().fields().build());
            break;
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void recordStaticInitHandlerClass(CombinedIndexBuildItem index, List<AmazonLambdaBuildItem> lambdas, LambdaObjectMapperInitializedBuildItem mapper, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, AmazonLambdaStaticRecorder recorder, RecorderContext context, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies) {
        if (providedLambda.isPresent()) {
            boolean useStreamHandler = false;
            for (Class<?> handleInterface : providedLambda.get().getHandlerClass().getInterfaces()) {
                if (!handleInterface.getName().equals(RequestStreamHandler.class.getName())) continue;
                useStreamHandler = true;
                break;
            }
            if (useStreamHandler) {
                Class handlerClass = context.classProxy(providedLambda.get().getHandlerClass().getName());
                recorder.setStreamHandlerClass(handlerClass);
            } else {
                RequestHandlerJandexUtil.RequestHandlerJandexDefinition requestHandlerJandexDefinition = RequestHandlerJandexUtil.discoverHandlerMethod(providedLambda.get().getHandlerClass().getName(), index.getComputingIndex());
                AmazonLambdaProcessor.registerForReflection(requestHandlerJandexDefinition, reflectiveMethods, reflectiveHierarchies);
                recorder.setHandlerClass(AmazonLambdaProcessor.toRequestHandlerDefinition(requestHandlerJandexDefinition, context));
            }
        } else if (lambdas != null && lambdas.size() == 1) {
            AmazonLambdaBuildItem item = lambdas.get(0);
            if (item.isStreamHandler()) {
                Class handlerClass = context.classProxy(item.getHandlerClass());
                recorder.setStreamHandlerClass(handlerClass);
            } else {
                RequestHandlerJandexUtil.RequestHandlerJandexDefinition requestHandlerJandexDefinition = RequestHandlerJandexUtil.discoverHandlerMethod(item.getHandlerClass(), index.getComputingIndex());
                AmazonLambdaProcessor.registerForReflection(requestHandlerJandexDefinition, reflectiveMethods, reflectiveHierarchies);
                recorder.setHandlerClass(AmazonLambdaProcessor.toRequestHandlerDefinition(requestHandlerJandexDefinition, context));
            }
        } else if (lambdas == null || lambdas.isEmpty()) {
            String errorMessage = "Unable to find handler class, make sure your deployment includes a single " + RequestHandler.class.getName() + " or " + RequestStreamHandler.class.getName() + " implementation";
            throw new RuntimeException(errorMessage);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void recordBeanContainer(BeanContainerBuildItem beanContainerBuildItem, AmazonLambdaRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst) {
        recorder.setBeanContainer(beanContainerBuildItem.getValue());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void recordHandlerClass(CombinedIndexBuildItem index, List<AmazonLambdaBuildItem> lambdas, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BeanContainerBuildItem beanContainerBuildItem, AmazonLambdaRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst, RecorderContext context, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies) {
        if (!providedLambda.isPresent() && lambdas != null && lambdas.size() > 1) {
            ArrayList<AmazonLambdaRecorder.RequestHandlerDefinition> unnamed = new ArrayList<AmazonLambdaRecorder.RequestHandlerDefinition>();
            HashMap<String, AmazonLambdaRecorder.RequestHandlerDefinition> named = new HashMap<String, AmazonLambdaRecorder.RequestHandlerDefinition>();
            ArrayList<Class> unnamedStreamHandler = new ArrayList<Class>();
            HashMap<String, Class> namedStreamHandler = new HashMap<String, Class>();
            for (AmazonLambdaBuildItem i : lambdas) {
                RequestHandlerJandexUtil.RequestHandlerJandexDefinition requestHandlerJandexDefinition;
                if (i.isStreamHandler()) {
                    if (i.getName() == null) {
                        unnamedStreamHandler.add(context.classProxy(i.getHandlerClass()));
                        continue;
                    }
                    namedStreamHandler.put(i.getName(), context.classProxy(i.getHandlerClass()));
                    continue;
                }
                if (i.getName() == null) {
                    requestHandlerJandexDefinition = RequestHandlerJandexUtil.discoverHandlerMethod(i.getHandlerClass(), index.getComputingIndex());
                    AmazonLambdaProcessor.registerForReflection(requestHandlerJandexDefinition, reflectiveMethods, reflectiveHierarchies);
                    unnamed.add(AmazonLambdaProcessor.toRequestHandlerDefinition(requestHandlerJandexDefinition, context));
                    continue;
                }
                requestHandlerJandexDefinition = RequestHandlerJandexUtil.discoverHandlerMethod(i.getHandlerClass(), index.getComputingIndex());
                AmazonLambdaProcessor.registerForReflection(requestHandlerJandexDefinition, reflectiveMethods, reflectiveHierarchies);
                named.put(i.getName(), AmazonLambdaProcessor.toRequestHandlerDefinition(requestHandlerJandexDefinition, context));
            }
            recorder.chooseHandlerClass(unnamed, named, unnamedStreamHandler, namedStreamHandler);
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startPoolLoop(AmazonLambdaRecorder recorder, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem, List<ServiceStartBuildItem> orderServicesFirst) {
        recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem, launchModeBuildItem.getLaunchMode());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startPoolLoopDevOrTest(AmazonLambdaRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (mode.isDevOrTest()) {
            recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem, mode);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordExpectedExceptions(LambdaBuildTimeConfig config, BuildProducer<ReflectiveClassBuildItem> registerForReflection, AmazonLambdaStaticRecorder recorder) {
        Set classes = config.expectedExceptions().map(Set::copyOf).orElseGet(Set::of);
        classes.stream().map(clazz -> ReflectiveClassBuildItem.builder((Class[])new Class[]{clazz}).constructors(false).reason(this.getClass().getName() + " expectedExceptions").build()).forEach(arg_0 -> registerForReflection.produce(arg_0));
        recorder.setExpectedExceptionClasses(classes);
    }

    private static String getCdiName(ClassInfo handler) {
        AnnotationInstance named = handler.declaredAnnotation(NAMED);
        if (named == null) {
            return null;
        }
        return named.value().asString();
    }

    private static void registerForReflection(RequestHandlerJandexUtil.RequestHandlerJandexDefinition requestHandlerJandexDefinition, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies) {
        String source = AmazonLambdaProcessor.class.getSimpleName() + " > " + String.valueOf(requestHandlerJandexDefinition.method().declaringClass()) + "[" + String.valueOf(requestHandlerJandexDefinition.method()) + "]";
        reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)requestHandlerJandexDefinition.inputOutputTypes().inputType()).source(source).build());
        reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)requestHandlerJandexDefinition.inputOutputTypes().outputType()).source(source).build());
        if (requestHandlerJandexDefinition.inputOutputTypes().isCollection()) {
            reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("method reflectively accessed in io.quarkus.amazon.lambda.runtime.AmazonLambdaRecorder.discoverHandlerMethod", requestHandlerJandexDefinition.method()));
            reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)requestHandlerJandexDefinition.inputOutputTypes().elementType()).source(source).build());
        }
    }

    private static AmazonLambdaRecorder.RequestHandlerDefinition toRequestHandlerDefinition(RequestHandlerJandexUtil.RequestHandlerJandexDefinition jandexDefinition, RecorderContext context) {
        return new AmazonLambdaRecorder.RequestHandlerDefinition(context.classProxy(jandexDefinition.handlerClass().name().toString()), context.classProxy(jandexDefinition.method().declaringClass().name().toString()), context.classProxy(jandexDefinition.inputOutputTypes().inputType().name().toString()), context.classProxy(jandexDefinition.inputOutputTypes().outputType().name().toString()));
    }
}

