/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.amazon.lambda.deployment.LambdaObjectMapperInitializedBuildItem;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaMapperRecorder;
import io.quarkus.amazon.lambda.runtime.LambdaBuildTimeConfig;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.pkg.steps.NativeSourcesBuild;
import io.quarkus.jackson.runtime.ObjectMapperProducer;
import io.quarkus.runtime.LaunchMode;
import java.util.function.Predicate;

public final class AmazonLambdaCommonProcessor {
    @BuildStep(onlyIf={NativeSourcesBuild.class})
    void failForNativeSources(BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        throw new IllegalArgumentException("The Amazon Lambda extensions are incompatible with the 'native-sources' package type.");
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void ipv4Only(BuildProducer<SystemPropertyBuildItem> systemProperty) {
        systemProperty.produce((BuildItem)new SystemPropertyBuildItem("java.net.preferIPv4Stack", "true"));
    }

    @BuildStep
    void tmpdirs(BuildProducer<SystemPropertyBuildItem> systemProperty, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (mode.isDevOrTest()) {
            return;
        }
        systemProperty.produce((BuildItem)new SystemPropertyBuildItem("java.io.tmpdir", "/tmp"));
        systemProperty.produce((BuildItem)new SystemPropertyBuildItem("vertx.cacheDirBase", "/tmp/vertx"));
    }

    @BuildStep
    public void markObjectMapper(BuildProducer<UnremovableBeanBuildItem> unremovable) {
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(ObjectMapper.class.getName())));
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(ObjectMapperProducer.class.getName())));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public LambdaObjectMapperInitializedBuildItem initObjectMapper(BeanContainerBuildItem beanContainer, AmazonLambdaMapperRecorder recorder) {
        recorder.initObjectMapper();
        return new LambdaObjectMapperInitializedBuildItem();
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void initContextReaders(AmazonLambdaMapperRecorder recorder, LambdaObjectMapperInitializedBuildItem dependency) {
        recorder.initContextReaders();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initContextReaders(LambdaBuildTimeConfig config, AmazonLambdaMapperRecorder recorder, LambdaObjectMapperInitializedBuildItem dependency, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (config.enablePollingJvmMode && mode.isDevOrTest()) {
            recorder.initContextReaders();
        }
    }
}

