/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class LambdaUtil {
    public static String artifactToLambda(String basename) {
        if (basename.endsWith("-SNAPSHOT")) {
            basename = basename.substring(0, basename.length() - "-SNAPSHOT".length());
        }
        String name = LambdaUtil.convertToken(basename, "[^a-zA-Z]");
        return name.trim();
    }

    protected static String convertToken(String basename, String token) {
        String[] splits = basename.split(token);
        if (splits == null || splits.length == 0) {
            return basename;
        }
        String name = "";
        for (String split : splits) {
            if ((split = split.trim()).isEmpty()) continue;
            name = name + split.substring(0, 1).toUpperCase() + split.substring(1).toLowerCase();
        }
        return name;
    }

    public static void writeFile(OutputTargetBuildItem target, String name, String output) throws IOException {
        Path artifact = target.getOutputDirectory().resolve(name);
        String targetUri = target.getOutputDirectory().resolve("function.zip").toUri().toString().replace("file:", "fileb:");
        output = output.replace("${artifactId}", target.getBaseName()).replace("${buildDir}", target.getOutputDirectory().toString()).replace("${targetUri}", targetUri);
        Files.write(artifact, output.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static String copyResource(String resource) throws Exception {
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byteArray = buffer.toByteArray();
            String string = new String(byteArray, StandardCharsets.UTF_8);
            return string;
        }
    }
}

