/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.commons.benchmarks;

import io.quarkus.commons.classloading.ClassLoaderHelper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.Main;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.SingleShotTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10, time=20, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=50, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=2)
public class BenchmarkClassnameToResourceName {
    @Param(value={"io.quarkus.commons.benchmarks.BenchmarkClassnameToResourceName"})
    public String arg;

    @Benchmark
    public String checkNewMethod() {
        return ClassLoaderHelper.fromClassNameToResourceName((String)this.arg);
    }

    @Benchmark
    public String oldMethod() {
        return BenchmarkClassnameToResourceName.oldMethod(this.arg);
    }

    private static String oldMethod(String name) {
        return name.replace(".", "/") + ".class";
    }

    @Benchmark
    public String oldAltMethod() {
        return BenchmarkClassnameToResourceName.oldAltMethod(this.arg);
    }

    private static String oldAltMethod(String name) {
        return name.replace('.', '/') + ".class";
    }

    public static void main(String[] args) throws IOException {
        Main.main((String[])new String[]{"-prof", "gc", "-prof", "perfnorm"});
    }
}

