/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InterceptorCreator;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.impl.Sets;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InterceptionType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class InterceptorInfo
extends BeanInfo
implements Comparable<InterceptorInfo> {
    private static final Logger LOGGER = Logger.getLogger(InterceptorInfo.class);
    private final Set<AnnotationInstance> bindings;
    private final List<MethodInfo> aroundInvokes;
    private final List<MethodInfo> aroundConstructs;
    private final List<MethodInfo> postConstructs;
    private final List<MethodInfo> preDestroys;
    private final InterceptionType interceptionType;
    private final Class<? extends InterceptorCreator> creatorClass;

    InterceptorInfo(Class<? extends InterceptorCreator> creatorClass, BeanDeployment beanDeployment, Set<AnnotationInstance> bindings, List<Injection> injections, int priority, InterceptionType interceptionType, Map<String, Object> params, String identifier) {
        super(null, (Type)ClassType.create(InterceptorCreator.InterceptFunction.class), null, beanDeployment, BuiltinScope.DEPENDENT.getInfo(), Sets.singletonHashSet((Object)Type.create((DotName)DotName.OBJECT_NAME, (Type.Kind)Type.Kind.CLASS)), new HashSet<AnnotationInstance>(), injections, null, null, false, Collections.emptyList(), null, false, mc -> {
            ResultHandle creatorHandle = mc.newInstance(MethodDescriptor.ofConstructor((Class)creatorClass, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle ret = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(InterceptorCreator.class, (String)"create", InterceptorCreator.InterceptFunction.class, (Class[])new Class[]{SyntheticCreationalContext.class}), creatorHandle, new ResultHandle[]{mc.getMethodParam(0)});
            mc.ifNull(ret).trueBranch().throwException(IllegalStateException.class, creatorClass.getName() + "#create() must not return null");
            mc.returnValue(ret);
        }, null, params, true, false, null, priority, creatorClass.getName() + (identifier != null ? identifier : ""), null);
        this.bindings = bindings;
        this.interceptionType = interceptionType;
        this.creatorClass = creatorClass;
        this.aroundInvokes = List.of();
        this.aroundConstructs = List.of();
        this.postConstructs = List.of();
        this.preDestroys = List.of();
    }

    InterceptorInfo(AnnotationTarget target, BeanDeployment beanDeployment, Set<AnnotationInstance> bindings, List<Injection> injections, int priority) {
        super(target, beanDeployment, BuiltinScope.DEPENDENT.getInfo(), Sets.singletonHashSet((Object)Type.create((DotName)target.asClass().name(), (Type.Kind)Type.Kind.CLASS)), new HashSet<AnnotationInstance>(), injections, null, null, false, Collections.emptyList(), null, false, null, priority, null);
        this.bindings = bindings;
        this.interceptionType = null;
        this.creatorClass = null;
        AnnotationStore store = beanDeployment.getAnnotationStore();
        ArrayList<MethodInfo> aroundInvokes = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> aroundConstructs = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> postConstructs = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> preDestroys = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> allMethods = new ArrayList<MethodInfo>();
        ClassInfo aClass = target.asClass();
        while (aClass != null) {
            int aroundInvokesFound = 0;
            int aroundConstructsFound = 0;
            int postConstructsFound = 0;
            int preDestroysFound = 0;
            for (MethodInfo method : aClass.methods()) {
                if (Modifier.isStatic(method.flags())) continue;
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES) || store.hasAnnotation((AnnotationTarget)method, DotNames.DISPOSES)) {
                    throw new DefinitionException("An interceptor method cannot be marked @Produces or @Disposes - " + String.valueOf(method) + " in class: " + String.valueOf(aClass));
                }
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.AROUND_INVOKE)) {
                    InterceptorInfo.addInterceptorMethod(allMethods, aroundInvokes, method);
                    if (++aroundInvokesFound > 1) {
                        throw new DefinitionException("Multiple @AroundInvoke interceptor methods declared on class: " + String.valueOf(aClass));
                    }
                }
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.AROUND_CONSTRUCT)) {
                    InterceptorInfo.addInterceptorMethod(allMethods, aroundConstructs, method);
                    if (++aroundConstructsFound > 1) {
                        throw new DefinitionException("Multiple @AroundConstruct interceptor methods declared on class: " + String.valueOf(aClass));
                    }
                }
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.POST_CONSTRUCT)) {
                    InterceptorInfo.addInterceptorMethod(allMethods, postConstructs, method);
                    if (++postConstructsFound > 1) {
                        throw new DefinitionException("Multiple @PostConstruct interceptor methods declared on class: " + String.valueOf(aClass));
                    }
                }
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.PRE_DESTROY)) {
                    InterceptorInfo.addInterceptorMethod(allMethods, preDestroys, method);
                    if (++preDestroysFound > 1) {
                        throw new DefinitionException("Multiple @PreDestroy interceptor methods declared on class: " + String.valueOf(aClass));
                    }
                }
                allMethods.add(method);
            }
            for (FieldInfo field : aClass.fields()) {
                if (!store.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES)) continue;
                throw new DefinitionException("An interceptor field cannot be marked @Produces - " + String.valueOf(field) + " in class: " + String.valueOf(aClass));
            }
            DotName superTypeName = aClass.superName();
            aClass = superTypeName == null || DotNames.OBJECT.equals((Object)superTypeName) ? null : IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superTypeName);
        }
        Collections.reverse(aroundInvokes);
        Collections.reverse(postConstructs);
        Collections.reverse(preDestroys);
        Collections.reverse(aroundConstructs);
        this.aroundInvokes = List.copyOf(aroundInvokes);
        this.aroundConstructs = List.copyOf(aroundConstructs);
        this.postConstructs = List.copyOf(postConstructs);
        this.preDestroys = List.copyOf(preDestroys);
        if (aroundConstructs.isEmpty() && aroundInvokes.isEmpty() && preDestroys.isEmpty() && postConstructs.isEmpty()) {
            LOGGER.warnf("%s declares no around-invoke method nor a lifecycle callback!", (Object)this);
        }
    }

    public Set<AnnotationInstance> getBindings() {
        return this.bindings;
    }

    InterceptionType getInterceptionType() {
        return this.interceptionType;
    }

    Class<? extends InterceptorCreator> getCreatorClass() {
        return this.creatorClass;
    }

    @Override
    public List<MethodInfo> getAroundInvokes() {
        return this.aroundInvokes;
    }

    public List<MethodInfo> getAroundConstructs() {
        return this.aroundConstructs;
    }

    public List<MethodInfo> getPostConstructs() {
        return this.postConstructs;
    }

    public List<MethodInfo> getPreDestroys() {
        return this.preDestroys;
    }

    @Deprecated(since="3.1", forRemoval=true)
    public MethodInfo getAroundInvoke() {
        return this.aroundInvokes.get(this.aroundInvokes.size() - 1);
    }

    @Deprecated(since="3.1", forRemoval=true)
    public MethodInfo getAroundConstruct() {
        return this.aroundConstructs.get(this.aroundConstructs.size() - 1);
    }

    @Deprecated(since="3.1", forRemoval=true)
    public MethodInfo getPostConstruct() {
        return this.postConstructs.get(this.postConstructs.size() - 1);
    }

    @Deprecated(since="3.1", forRemoval=true)
    public MethodInfo getPreDestroy() {
        return this.preDestroys.get(this.preDestroys.size() - 1);
    }

    public boolean intercepts(InterceptionType interceptionType) {
        if (this.isSynthetic()) {
            return interceptionType == this.interceptionType;
        }
        switch (interceptionType) {
            case AROUND_INVOKE: {
                return !this.aroundInvokes.isEmpty();
            }
            case AROUND_CONSTRUCT: {
                return !this.aroundConstructs.isEmpty();
            }
            case POST_CONSTRUCT: {
                return !this.postConstructs.isEmpty();
            }
            case PRE_DESTROY: {
                return !this.preDestroys.isEmpty();
            }
        }
        return false;
    }

    @Override
    public boolean isInterceptor() {
        return true;
    }

    @Override
    public String toString() {
        return "INTERCEPTOR bean [bindings=" + String.valueOf(this.bindings) + ", target=" + String.valueOf(this.getTarget()) + "]";
    }

    @Override
    public int compareTo(InterceptorInfo other) {
        return this.getTarget().toString().compareTo(other.getTarget().toString());
    }

    static void addInterceptorMethod(List<MethodInfo> allMethods, List<MethodInfo> interceptorMethods, MethodInfo method) {
        InterceptorInfo.validateSignature(method);
        if (!InterceptorInfo.isInterceptorMethodOverriden(allMethods, method)) {
            interceptorMethods.add(method);
        }
    }

    static boolean isInterceptorMethodOverriden(Iterable<MethodInfo> allMethods, MethodInfo method) {
        for (MethodInfo m : allMethods) {
            if (!m.name().equals(method.name()) || !InterceptorInfo.hasInterceptorMethodParameter(m)) continue;
            return true;
        }
        return false;
    }

    static boolean hasInterceptorMethodParameter(MethodInfo method) {
        return method.parametersCount() == 1 && (method.parameterType(0).name().equals((Object)DotNames.INVOCATION_CONTEXT) || method.parameterType(0).name().equals((Object)DotNames.ARC_INVOCATION_CONTEXT));
    }

    private static MethodInfo validateSignature(MethodInfo method) {
        if (!InterceptorInfo.hasInterceptorMethodParameter(method)) {
            throw new IllegalStateException("An interceptor method must accept exactly one parameter of type jakarta.interceptor.InvocationContext: " + String.valueOf(method) + " declared on " + String.valueOf(method.declaringClass()));
        }
        if (!method.returnType().kind().equals((Object)Type.Kind.VOID) && !method.returnType().name().equals((Object)DotNames.OBJECT)) {
            throw new IllegalStateException("The return type of an interceptor method must be java.lang.Object or void: " + String.valueOf(method) + " declared on " + String.valueOf(method.declaringClass()));
        }
        return method;
    }
}

