/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.ExtensionInvoker;
import io.quarkus.arc.processor.bcextensions.ExtensionMethod;
import io.quarkus.arc.processor.bcextensions.ExtensionMethodParameter;
import io.quarkus.arc.processor.bcextensions.ExtensionPhase;
import io.quarkus.arc.processor.bcextensions.MessagesImpl;
import io.quarkus.arc.processor.bcextensions.SharedErrors;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

abstract class ExtensionPhaseBase {
    private final ExtensionPhase phase;
    final ExtensionInvoker util;
    final IndexView index;
    final SharedErrors errors;

    ExtensionPhaseBase(ExtensionPhase phase, ExtensionInvoker util, IndexView index, SharedErrors errors) {
        this.phase = phase;
        this.util = util;
        this.index = index;
        this.errors = errors;
    }

    final void run() {
        try {
            List<ExtensionMethod> extensionMethods = this.util.findExtensionMethods(this.phase.annotationName);
            for (ExtensionMethod method : extensionMethods) {
                this.runExtensionMethod(method);
            }
        }
        catch (DefinitionException | DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    void runExtensionMethod(ExtensionMethod method) throws ReflectiveOperationException {
        ArrayList<ExtensionMethodParameter> parameters = new ArrayList<ExtensionMethodParameter>(method.parametersCount());
        for (Type parameterType : method.parameterTypes()) {
            ExtensionMethodParameter parameter = ExtensionMethodParameter.of(parameterType);
            parameters.add(parameter);
            parameter.verifyAvailable(this.phase, method);
        }
        ArrayList<Object> arguments = new ArrayList<Object>(method.parametersCount());
        for (ExtensionMethodParameter parameter : parameters) {
            Object argument = this.argumentForExtensionMethod(parameter, method);
            arguments.add(argument);
        }
        this.util.callExtensionMethod(method, arguments);
    }

    Object argumentForExtensionMethod(ExtensionMethodParameter type, ExtensionMethod method) {
        if (type == ExtensionMethodParameter.MESSAGES) {
            return new MessagesImpl(this.errors, method.extensionClass);
        }
        throw new IllegalArgumentException("internal error, " + type + " parameter declared at " + method);
    }
}

