/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.ArcUndeclaredThrowableException;
import io.quarkus.arc.InjectableDecorator;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.Subclass;
import io.quarkus.arc.impl.InterceptedMethodMetadata;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.DecoratorGenerator;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.FieldDescriptors;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationInstanceEquivalenceProxy;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class SubclassGenerator
extends AbstractGenerator {
    private static final DotName JAVA_LANG_THROWABLE = DotNames.create(Throwable.class.getName());
    private static final DotName JAVA_LANG_EXCEPTION = DotNames.create(Exception.class.getName());
    private static final DotName JAVA_LANG_RUNTIME_EXCEPTION = DotNames.create(RuntimeException.class.getName());
    static final String SUBCLASS_SUFFIX = "_Subclass";
    static final String MARK_CONSTRUCTED_METHOD_NAME = "arc$markConstructed";
    static final String DESTROY_METHOD_NAME = "arc$destroy";
    protected static final String FIELD_NAME_PREDESTROYS = "arc$preDestroys";
    protected static final String FIELD_NAME_CONSTRUCTED = "arc$constructed";
    private final Predicate<DotName> applicationClassPredicate;
    private final Set<String> existingClasses;
    private final BeanProcessor.PrivateMembersCollector privateMembers;
    private final AnnotationLiteralProcessor annotationLiterals;

    static String generatedName(DotName providerTypeName, String baseName) {
        String packageName = DotNames.internalPackageNameWithTrailingSlash(providerTypeName);
        return packageName + baseName + SUBCLASS_SUFFIX;
    }

    public SubclassGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, BeanProcessor.PrivateMembersCollector privateMembers) {
        super(generateSources, reflectionRegistration);
        this.applicationClassPredicate = applicationClassPredicate;
        this.annotationLiterals = annotationLiterals;
        this.existingClasses = existingClasses;
        this.privateMembers = privateMembers;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean, String beanClassName) {
        Type providerType = bean.getProviderType();
        ClassInfo providerClass = IndexClassLookupUtils.getClassByName(bean.getDeployment().getBeanArchiveIndex(), providerType.name());
        String providerTypeName = providerClass.name().toString();
        String baseName = this.getBaseName(beanClassName);
        String generatedName = SubclassGenerator.generatedName(providerType.name(), baseName);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        ResourceClassOutput classOutput = new ResourceClassOutput(this.applicationClassPredicate.test(bean.getBeanClass()), name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.SUBCLASS : null, this.generateSources);
        ClassCreator subclass = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).superClass(providerTypeName).interfaces(new Class[]{Subclass.class}).build();
        FieldDescriptor preDestroyField = this.createConstructor(classOutput, bean, subclass, providerType, providerTypeName, this.reflectionRegistration);
        this.createDestroy(classOutput, bean, subclass, preDestroyField);
        subclass.close();
        return classOutput.getResources();
    }

    protected FieldDescriptor createConstructor(ClassOutput classOutput, BeanInfo bean, ClassCreator subclass, Type providerType, String providerTypeName, ReflectionRegistration reflectionRegistration) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        Optional<Injection> constructorInjection = bean.getConstructorInjection();
        if (constructorInjection.isPresent()) {
            for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                parameterTypes.add(injectionPoint.getType().name().toString());
            }
        }
        int superParamsSize = parameterTypes.size();
        parameterTypes.add(CreationalContext.class.getName());
        List<InterceptorInfo> boundInterceptors = bean.getBoundInterceptors();
        for (int j = 0; j < boundInterceptors.size(); ++j) {
            parameterTypes.add(InjectableInterceptor.class.getName());
        }
        List<DecoratorInfo> boundDecorators = bean.getBoundDecorators();
        for (int j = 0; j < boundDecorators.size(); ++j) {
            parameterTypes.add(InjectableDecorator.class.getName());
        }
        MethodCreator constructor = subclass.getMethodCreator("<init>", "V", parameterTypes.toArray(new String[0]));
        ResultHandle creationalContextHandle = constructor.getMethodParam(superParamsSize);
        ResultHandle[] superParams = new ResultHandle[superParamsSize];
        for (int j = 0; j < superParamsSize; ++j) {
            superParams[j] = constructor.getMethodParam(j);
        }
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)providerTypeName, (String[])parameterTypes.subList(0, superParamsSize).toArray(new String[0])), constructor.getThis(), superParams);
        HashMap<String, ResultHandle> interceptorToResultHandle = new HashMap<String, ResultHandle>();
        HashMap<String, ResultHandle> interceptorInstanceToResultHandle = new HashMap<String, ResultHandle>();
        for (int j = 0; j < boundInterceptors.size(); ++j) {
            InterceptorInfo interceptorInfo = boundInterceptors.get(j);
            ResultHandle constructorMethodParam = constructor.getMethodParam(j + superParamsSize + 1);
            interceptorToResultHandle.put(interceptorInfo.getIdentifier(), constructorMethodParam);
            ResultHandle creationalContext = constructor.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{creationalContextHandle});
            ResultHandle interceptorInstance = constructor.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, constructorMethodParam, new ResultHandle[]{creationalContext});
            interceptorInstanceToResultHandle.put(interceptorInfo.getIdentifier(), interceptorInstance);
        }
        HashMap<MethodDescriptor, MethodDescriptor> forwardingMethods = new HashMap<MethodDescriptor, MethodDescriptor>();
        List<MethodInfo> interceptedOrDecoratedMethods = bean.getInterceptedOrDecoratedMethods();
        for (MethodInfo method : interceptedOrDecoratedMethods) {
            forwardingMethods.put(MethodDescriptor.of((MethodInfo)method), SubclassGenerator.createForwardingMethod(subclass, providerTypeName, method, (bytecode, virtualMethod, params) -> bytecode.invokeSpecialMethod(virtualMethod, bytecode.getThis(), params)));
        }
        if (boundDecorators.isEmpty()) {
            decoratorToResultHandle = Collections.emptyMap();
        } else {
            decoratorToResultHandle = new HashMap();
            for (int j = 0; j < boundDecorators.size(); ++j) {
                this.processDecorator(boundDecorators.get(j), bean, providerType, providerTypeName, subclass, classOutput, constructor, boundInterceptors.size() + superParamsSize + j + 1, decoratorToResultHandle, creationalContextHandle, forwardingMethods);
            }
        }
        FieldCreator preDestroysField = null;
        BeanInfo.InterceptionInfo preDestroys = bean.getLifecycleInterceptors(InterceptionType.PRE_DESTROY);
        if (!preDestroys.isEmpty()) {
            preDestroysField = (FieldCreator)subclass.getFieldCreator(FIELD_NAME_PREDESTROYS, DescriptorUtils.extToInt((String)ArrayList.class.getName())).setModifiers(18);
            constructor.writeInstanceField(preDestroysField.getFieldDescriptor(), constructor.getThis(), constructor.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]));
            for (InterceptorInfo interceptor : preDestroys.interceptors) {
                ResultHandle interceptorInstance = (ResultHandle)interceptorInstanceToResultHandle.get(interceptor.getIdentifier());
                ResultHandle interceptionInvocation = constructor.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_PRE_DESTROY, new ResultHandle[]{(ResultHandle)interceptorToResultHandle.get(interceptor.getIdentifier()), interceptorInstance});
                constructor.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, constructor.readInstanceField(preDestroysField.getFieldDescriptor(), constructor.getThis()), new ResultHandle[]{interceptionInvocation});
            }
        }
        FieldCreator constructedField = (FieldCreator)subclass.getFieldCreator(FIELD_NAME_CONSTRUCTED, Boolean.TYPE).setModifiers(66);
        MethodCreator markConstructed = subclass.getMethodCreator(MARK_CONSTRUCTED_METHOD_NAME, Void.TYPE, new Class[0]);
        markConstructed.writeInstanceField(constructedField.getFieldDescriptor(), markConstructed.getThis(), markConstructed.load(true));
        markConstructed.returnVoid();
        IntegerHolder chainIdx = new IntegerHolder();
        IntegerHolder bindingIdx = new IntegerHolder();
        HashMap<List<InterceptorInfo>, String> interceptorChainKeys = new HashMap<List<InterceptorInfo>, String>();
        HashMap<Set<AnnotationInstanceEquivalenceProxy>, String> bindingKeys = new HashMap<Set<AnnotationInstanceEquivalenceProxy>, String>();
        ResultHandle interceptorChainMap = constructor.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle bindingsMap = constructor.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        HashMap<AnnotationInstanceEquivalenceProxy, ResultHandle> bindingsLiterals = new HashMap<AnnotationInstanceEquivalenceProxy, ResultHandle>();
        Function<List<InterceptorInfo>, String> interceptorChainKeysFun = SubclassGenerator.createInterceptorChainKeysFun(chainIdx, constructor, interceptorChainMap, interceptorInstanceToResultHandle, interceptorToResultHandle);
        Function<Set<AnnotationInstanceEquivalenceProxy>, String> bindingsFun = SubclassGenerator.createBindingsFun(bindingIdx, constructor, bindingsMap, bindingsLiterals, bean, this.annotationLiterals);
        int methodIdx = 1;
        for (MethodInfo method : interceptedOrDecoratedMethods) {
            BeanInfo.InterceptionInfo interception = bean.getInterceptedMethods().get(method);
            if (interception == null) continue;
            subclass.getFieldCreator("arc$" + methodIdx++, InterceptedMethodMetadata.class.getName()).setModifiers(2);
            interceptorChainKeys.computeIfAbsent(interception.interceptors, interceptorChainKeysFun);
            bindingKeys.computeIfAbsent(interception.bindingsEquivalenceProxies(), bindingsFun);
        }
        if (bean.hasAroundInvokes()) {
            FieldCreator field = (FieldCreator)subclass.getFieldCreator("aroundInvokes", List.class).setModifiers(2);
            ResultHandle methodsList = constructor.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (MethodInfo method : bean.getAroundInvokes()) {
                BytecodeCreator funBytecode;
                FunctionCreator fun = constructor.createFunction(BiFunction.class);
                ResultHandle ret = this.invokeInterceptorMethod(funBytecode = fun.getBytecode(), method, this.applicationClassPredicate.test(bean.getBeanClass()), funBytecode.getMethodParam(1), funBytecode.getMethodParam(0));
                funBytecode.returnValue(ret != null ? ret : funBytecode.loadNull());
                constructor.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, methodsList, new ResultHandle[]{fun.getInstance()});
            }
            constructor.writeInstanceField(field.getFieldDescriptor(), constructor.getThis(), methodsList);
        }
        int group = 0;
        int groupLimit = 30;
        MethodCreator initMetadataMethod = null;
        HashMap<String, ResultHandle> chainHandles = new HashMap<String, ResultHandle>();
        HashMap<String, ResultHandle> bindingsHandles = new HashMap<String, ResultHandle>();
        methodIdx = 1;
        for (MethodInfo method : interceptedOrDecoratedMethods) {
            if (initMetadataMethod == null || methodIdx >= group * groupLimit) {
                if (initMetadataMethod != null) {
                    initMetadataMethod.returnVoid();
                    initMetadataMethod.close();
                    constructor.invokeVirtualMethod(initMetadataMethod.getMethodDescriptor(), constructor.getThis(), new ResultHandle[]{interceptorChainMap, bindingsMap});
                }
                initMetadataMethod = (MethodCreator)subclass.getMethodCreator("arc$initMetadata" + group++, Void.TYPE, new Class[]{Map.class, Map.class}).setModifiers(2);
                chainHandles.clear();
                bindingsHandles.clear();
            }
            MethodDescriptor methodDescriptor = MethodDescriptor.of((MethodInfo)method);
            MethodDescriptor originalMethodDescriptor = MethodDescriptor.of((MethodInfo)method);
            BeanInfo.InterceptionInfo interception = bean.getInterceptedMethods().get(method);
            BeanInfo.DecorationInfo decoration = bean.getDecoratedMethods().get(method);
            MethodDescriptor forwardDescriptor = (MethodDescriptor)forwardingMethods.get(methodDescriptor);
            List parameters = method.parameterTypes();
            if (interception != null) {
                ResultHandle[] superParamHandles;
                MethodCreator initMetadataMethodFinal = initMetadataMethod;
                String interceptorChainKey = (String)interceptorChainKeys.get(interception.interceptors);
                ResultHandle chainHandle = chainHandles.computeIfAbsent(interceptorChainKey, ignored -> initMetadataMethodFinal.invokeInterfaceMethod(MethodDescriptors.MAP_GET, initMetadataMethodFinal.getMethodParam(0), new ResultHandle[]{initMetadataMethodFinal.load(interceptorChainKey)}));
                ResultHandle[] paramsHandles = new ResultHandle[3];
                paramsHandles[0] = initMetadataMethod.loadClass(providerTypeName);
                paramsHandles[1] = initMetadataMethod.load(method.name());
                if (!parameters.isEmpty()) {
                    ResultHandle paramsArray = initMetadataMethod.newArray(Class.class, initMetadataMethod.load(parameters.size()));
                    ListIterator iterator = parameters.listIterator();
                    while (iterator.hasNext()) {
                        initMetadataMethod.writeArrayValue(paramsArray, iterator.nextIndex(), initMetadataMethod.loadClass(((Type)iterator.next()).name().toString()));
                    }
                    paramsHandles[2] = paramsArray;
                } else {
                    paramsHandles[2] = initMetadataMethod.readStaticField(FieldDescriptors.ANNOTATION_LITERALS_EMPTY_CLASS_ARRAY);
                }
                ResultHandle methodHandle = initMetadataMethod.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_METHOD, paramsHandles);
                String bindingKey = (String)bindingKeys.get(interception.bindingsEquivalenceProxies());
                ResultHandle bindingsHandle = bindingsHandles.computeIfAbsent(bindingKey, ignored -> initMetadataMethodFinal.invokeInterfaceMethod(MethodDescriptors.MAP_GET, initMetadataMethodFinal.getMethodParam(1), new ResultHandle[]{initMetadataMethodFinal.load(bindingKey)}));
                BeanInfo.DecoratorMethod decoratorMethod = decoration != null ? decoration.firstDecoratorMethod() : null;
                ResultHandle decoratorHandle = null;
                if (decoratorMethod != null) {
                    decoratorHandle = initMetadataMethod.readInstanceField(FieldDescriptor.of((String)subclass.getClassName(), (String)decoratorMethod.decorator.getIdentifier(), (String)Object.class.getName()), initMetadataMethod.getThis());
                }
                FunctionCreator func = initMetadataMethod.createFunction(BiFunction.class);
                BytecodeCreator funcBytecode = func.getBytecode();
                ResultHandle targetHandle = funcBytecode.getMethodParam(0);
                ResultHandle ctxHandle = funcBytecode.getMethodParam(1);
                if (parameters.isEmpty()) {
                    superParamHandles = new ResultHandle[]{};
                } else {
                    superParamHandles = new ResultHandle[parameters.size()];
                    ResultHandle ctxParamsHandle = funcBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(InvocationContext.class, (String)"getParameters", Object[].class, (Class[])new Class[0]), ctxHandle, new ResultHandle[0]);
                    for (int i = 0; i < superParamHandles.length; ++i) {
                        superParamHandles[i] = funcBytecode.readArrayValue(ctxParamsHandle, i);
                    }
                }
                if (decoratorMethod != null) {
                    AssignableResultHandle funDecoratorInstance = funcBytecode.createVariable(Object.class);
                    funcBytecode.assign(funDecoratorInstance, decoratorHandle);
                    String declaringClass = decoratorMethod.decorator.getBeanClass().toString();
                    if (decoratorMethod.decorator.isAbstract()) {
                        String baseName = DecoratorGenerator.createBaseName(decoratorMethod.decorator.getTarget().get().asClass());
                        String targetPackage = DotNames.packageName(decoratorMethod.decorator.getProviderType().name());
                        declaringClass = SubclassGenerator.generatedNameFromTarget(targetPackage, baseName, "_Impl");
                    }
                    MethodDescriptor decoratorMethodDescriptor = MethodDescriptor.of((MethodInfo)decoratorMethod.method);
                    MethodDescriptor virtualMethodDescriptor = MethodDescriptor.ofMethod((String)declaringClass, (String)originalMethodDescriptor.getName(), (String)decoratorMethodDescriptor.getReturnType(), (String[])decoratorMethodDescriptor.getParameterTypes());
                    ResultHandle superResult = funcBytecode.invokeVirtualMethod(virtualMethodDescriptor, (ResultHandle)funDecoratorInstance, superParamHandles);
                    funcBytecode.returnValue(superResult != null ? superResult : funcBytecode.loadNull());
                } else {
                    ResultHandle superResult = funcBytecode.invokeVirtualMethod(forwardDescriptor, targetHandle, superParamHandles);
                    funcBytecode.returnValue(superResult != null ? superResult : funcBytecode.loadNull());
                }
                ResultHandle aroundForwardFun = func.getInstance();
                if (bean.hasAroundInvokes()) {
                    AssignableResultHandle methodsList = initMetadataMethod.createVariable(List.class);
                    initMetadataMethod.assign(methodsList, initMetadataMethod.readInstanceField(FieldDescriptor.of((String)subclass.getClassName(), (String)"aroundInvokes", List.class), initMetadataMethod.getThis()));
                    FunctionCreator targetFun = initMetadataMethod.createFunction(BiFunction.class);
                    BytecodeCreator targetFunBytecode = targetFun.getBytecode();
                    ResultHandle ret = targetFunBytecode.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_PERFORM_TARGET_AROUND_INVOKE, new ResultHandle[]{targetFunBytecode.getMethodParam(1), methodsList, aroundForwardFun});
                    targetFunBytecode.returnValue(ret);
                    aroundForwardFun = targetFun.getInstance();
                }
                ResultHandle methodMetadataHandle = initMetadataMethod.newInstance(MethodDescriptors.INTERCEPTED_METHOD_METADATA_CONSTRUCTOR, new ResultHandle[]{chainHandle, methodHandle, bindingsHandle, aroundForwardFun});
                FieldDescriptor metadataField = FieldDescriptor.of((String)subclass.getClassName(), (String)("arc$" + methodIdx++), (String)InterceptedMethodMetadata.class.getName());
                initMetadataMethod.writeInstanceField(metadataField, initMetadataMethod.getThis(), methodMetadataHandle);
                reflectionRegistration.registerMethod(method);
                SubclassGenerator.createInterceptedMethod(method, subclass, metadataField, constructedField.getFieldDescriptor(), forwardDescriptor, BytecodeCreator::getThis);
                continue;
            }
            MethodCreator decoratedMethod = subclass.getMethodCreator(methodDescriptor);
            ResultHandle[] params2 = new ResultHandle[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                params2[i] = decoratedMethod.getMethodParam(i);
            }
            BytecodeCreator notConstructed = decoratedMethod.ifFalse(decoratedMethod.readInstanceField(constructedField.getFieldDescriptor(), decoratedMethod.getThis())).trueBranch();
            if (Modifier.isAbstract(method.flags())) {
                notConstructed.throwException(IllegalStateException.class, "Cannot delegate to an abstract method");
            } else {
                notConstructed.returnValue(notConstructed.invokeVirtualMethod(forwardDescriptor, notConstructed.getThis(), params2));
            }
            BeanInfo.DecoratorMethod decoratorMethod = decoration.firstDecoratorMethod();
            DecoratorInfo firstDecorator = decoratorMethod.decorator;
            ResultHandle decoratorInstance = decoratedMethod.readInstanceField(FieldDescriptor.of((String)subclass.getClassName(), (String)firstDecorator.getIdentifier(), (String)Object.class.getName()), decoratedMethod.getThis());
            String declaringClass = firstDecorator.getBeanClass().toString();
            if (firstDecorator.isAbstract()) {
                String baseName = DecoratorGenerator.createBaseName(firstDecorator.getTarget().get().asClass());
                String targetPackage = DotNames.packageName(firstDecorator.getProviderType().name());
                declaringClass = SubclassGenerator.generatedNameFromTarget(targetPackage, baseName, "_Impl");
            }
            MethodDescriptor decoratorMethodDescriptor = MethodDescriptor.of((MethodInfo)decoratorMethod.method);
            MethodDescriptor virtualMethodDescriptor = MethodDescriptor.ofMethod((String)declaringClass, (String)methodDescriptor.getName(), (String)decoratorMethodDescriptor.getReturnType(), (String[])decoratorMethodDescriptor.getParameterTypes());
            decoratedMethod.returnValue(decoratedMethod.invokeVirtualMethod(virtualMethodDescriptor, decoratorInstance, params2));
        }
        if (initMetadataMethod != null) {
            initMetadataMethod.returnVoid();
            constructor.invokeVirtualMethod(initMetadataMethod.getMethodDescriptor(), constructor.getThis(), new ResultHandle[]{interceptorChainMap, bindingsMap});
        }
        constructor.returnValue(null);
        return preDestroysField != null ? preDestroysField.getFieldDescriptor() : null;
    }

    static Function<Set<AnnotationInstanceEquivalenceProxy>, String> createBindingsFun(final IntegerHolder bindingIdx, final MethodCreator bytecode, final ResultHandle bindingsMap, final Map<AnnotationInstanceEquivalenceProxy, ResultHandle> bindingsLiterals, final BeanInfo bean, final AnnotationLiteralProcessor annotationLiterals) {
        final Function<AnnotationInstanceEquivalenceProxy, ResultHandle> bindingsLiteralFun = new Function<AnnotationInstanceEquivalenceProxy, ResultHandle>(){

            @Override
            public ResultHandle apply(AnnotationInstanceEquivalenceProxy binding) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.get().name());
                return annotationLiterals.create((BytecodeCreator)bytecode, bindingClass, binding.get());
            }
        };
        return new Function<Set<AnnotationInstanceEquivalenceProxy>, String>(){

            @Override
            public String apply(Set<AnnotationInstanceEquivalenceProxy> bindings) {
                String key = "b" + bindingIdx.i++;
                if (bindings.size() == 1) {
                    bytecode.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, bindingsMap, new ResultHandle[]{bytecode.load(key), bytecode.invokeStaticMethod(MethodDescriptors.COLLECTIONS_SINGLETON, new ResultHandle[]{(ResultHandle)bindingsLiterals.computeIfAbsent(bindings.iterator().next(), bindingsLiteralFun)})});
                } else {
                    ResultHandle bindingsArray = bytecode.newArray(Object.class, bindings.size());
                    int bindingsIndex = 0;
                    for (AnnotationInstanceEquivalenceProxy binding : bindings) {
                        bytecode.writeArrayValue(bindingsArray, bindingsIndex++, (ResultHandle)bindingsLiterals.computeIfAbsent(binding, bindingsLiteralFun));
                    }
                    bytecode.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, bindingsMap, new ResultHandle[]{bytecode.load(key), bytecode.invokeStaticMethod(MethodDescriptors.SETS_OF, new ResultHandle[]{bindingsArray})});
                }
                return key;
            }
        };
    }

    static Function<List<InterceptorInfo>, String> createInterceptorChainKeysFun(final IntegerHolder chainIdx, final MethodCreator bytecode, final ResultHandle interceptorChainMap, final Map<String, ResultHandle> interceptorInstanceToResultHandle, final Map<String, ResultHandle> interceptorToResultHandle) {
        return new Function<List<InterceptorInfo>, String>(){

            @Override
            public String apply(List<InterceptorInfo> interceptors) {
                String key = "i" + chainIdx.i++;
                if (interceptors.size() == 1) {
                    InterceptorInfo interceptor = interceptors.get(0);
                    ResultHandle interceptorInstance = (ResultHandle)interceptorInstanceToResultHandle.get(interceptor.getIdentifier());
                    ResultHandle interceptionInvocation = bytecode.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_AROUND_INVOKE, new ResultHandle[]{(ResultHandle)interceptorToResultHandle.get(interceptor.getIdentifier()), interceptorInstance});
                    bytecode.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, interceptorChainMap, new ResultHandle[]{bytecode.load(key), bytecode.invokeStaticMethod(MethodDescriptors.COLLECTIONS_SINGLETON_LIST, new ResultHandle[]{interceptionInvocation})});
                } else {
                    ResultHandle chainHandle = bytecode.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                    for (InterceptorInfo interceptor : interceptors) {
                        ResultHandle interceptorInstance = (ResultHandle)interceptorInstanceToResultHandle.get(interceptor.getIdentifier());
                        ResultHandle interceptionInvocation = bytecode.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_AROUND_INVOKE, new ResultHandle[]{(ResultHandle)interceptorToResultHandle.get(interceptor.getIdentifier()), interceptorInstance});
                        bytecode.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, chainHandle, new ResultHandle[]{interceptionInvocation});
                    }
                    bytecode.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, interceptorChainMap, new ResultHandle[]{bytecode.load(key), chainHandle});
                }
                return key;
            }
        };
    }

    private ResultHandle invokeInterceptorMethod(BytecodeCreator creator, MethodInfo interceptorMethod, boolean isApplicationClass, ResultHandle invocationContext, ResultHandle targetInstance) {
        ResultHandle ret;
        Class invocationContextClass = interceptorMethod.parameterType(0).name().equals((Object)DotNames.INVOCATION_CONTEXT) ? InvocationContext.class : ArcInvocationContext.class;
        if (Modifier.isPrivate(interceptorMethod.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Interceptor method %s#%s()", interceptorMethod.declaringClass().name(), interceptorMethod.name()));
            ResultHandle paramTypesArray = creator.newArray(Class.class, creator.load(1));
            creator.writeArrayValue(paramTypesArray, 0, creator.loadClass(invocationContextClass));
            ResultHandle argsArray = creator.newArray(Object.class, creator.load(1));
            creator.writeArrayValue(argsArray, 0, invocationContext);
            this.reflectionRegistration.registerMethod(interceptorMethod);
            ret = creator.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{creator.loadClass(interceptorMethod.declaringClass().name().toString()), creator.load(interceptorMethod.name()), paramTypesArray, targetInstance, argsArray});
        } else {
            ret = creator.invokeVirtualMethod(interceptorMethod, targetInstance, new ResultHandle[]{invocationContext});
        }
        return ret;
    }

    private void processDecorator(DecoratorInfo decorator, BeanInfo bean, Type providerType, String providerTypeName, ClassCreator subclass, ClassOutput classOutput, MethodCreator subclassConstructor, int paramIndex, Map<String, ResultHandle> decoratorToResultHandle, ResultHandle creationalContextHandle, Map<MethodDescriptor, MethodDescriptor> forwardingMethods) {
        ClassInfo decoratorClass = decorator.getTarget().get().asClass();
        Object baseName = decoratorClass.enclosingClass() != null ? DotNames.simpleName(decoratorClass.enclosingClass()) + "_" + DotNames.simpleName(decoratorClass) : DotNames.simpleName(decoratorClass);
        String generatedName = SubclassGenerator.generatedName(providerType.name(), (String)baseName + "_" + bean.getIdentifier() + "_Delegate");
        ClassCreator.Builder delegateSubclassBuilder = ClassCreator.builder().classOutput(classOutput).className(generatedName);
        ClassInfo delegateTypeClass = decorator.getDelegateTypeClass();
        boolean delegateTypeIsInterface = Modifier.isInterface(delegateTypeClass.flags());
        if (delegateTypeIsInterface) {
            delegateSubclassBuilder.interfaces(new String[]{delegateTypeClass.name().toString()});
        } else {
            delegateSubclassBuilder.superClass(delegateTypeClass.name().toString());
        }
        ClassCreator delegateSubclass = delegateSubclassBuilder.build();
        Map<MethodDescriptor, BeanInfo.DecoratorMethod> nextDecorators = bean.getNextDecorators(decorator);
        HashSet<DecoratorInfo> nextDecoratorsValues = new HashSet<DecoratorInfo>();
        for (BeanInfo.DecoratorMethod decoratorMethod : nextDecorators.values()) {
            nextDecoratorsValues.add(decoratorMethod.decorator);
        }
        ArrayList decoratorParameters = new ArrayList(nextDecoratorsValues);
        Collections.sort(decoratorParameters);
        Set<MethodInfo> decoratedMethods = bean.getDecoratedMethods(decorator);
        HashSet<MethodDescriptor> decoratedMethodDescriptors = new HashSet<MethodDescriptor>(decoratedMethods.size());
        for (MethodInfo m : decoratedMethods) {
            decoratedMethodDescriptors.add(MethodDescriptor.of((MethodInfo)m));
        }
        ArrayList<String> constructorParameterTypes = new ArrayList<String>();
        FieldCreator subclassField = (FieldCreator)delegateSubclass.getFieldCreator("subclass", subclass.getClassName()).setModifiers(18);
        constructorParameterTypes.add(subclass.getClassName());
        HashMap<DecoratorInfo, FieldDescriptor> nextDecoratorToField = new HashMap<DecoratorInfo, FieldDescriptor>();
        for (DecoratorInfo nextDecorator : decoratorParameters) {
            FieldCreator nextDecoratorField = (FieldCreator)delegateSubclass.getFieldCreator(nextDecorator.getIdentifier(), nextDecorator.getBeanClass().toString()).setModifiers(18);
            constructorParameterTypes.add(nextDecorator.getBeanClass().toString());
            nextDecoratorToField.put(nextDecorator, nextDecoratorField.getFieldDescriptor());
        }
        MethodCreator constructor = delegateSubclass.getMethodCreator("<init>", "V", constructorParameterTypes.toArray(new String[0]));
        int param = 0;
        if (delegateTypeIsInterface) {
            constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        } else {
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)delegateTypeClass.name().toString(), (String[])new String[0]), constructor.getThis(), new ResultHandle[0]);
        }
        constructor.writeInstanceField(subclassField.getFieldDescriptor(), constructor.getThis(), constructor.getMethodParam(param++));
        for (FieldDescriptor field : nextDecoratorToField.values()) {
            constructor.writeInstanceField(field, constructor.getThis(), constructor.getMethodParam(param++));
        }
        constructor.returnValue(null);
        IndexView index = bean.getDeployment().getBeanArchiveIndex();
        HashSet<Methods.MethodKey> methods = new HashSet<Methods.MethodKey>();
        Methods.addDelegateTypeMethods(index, delegateTypeClass, methods);
        List typeParameters = delegateTypeClass.typeParameters();
        Map<String, Type> resolvedTypeParameters = Collections.emptyMap();
        if (!typeParameters.isEmpty()) {
            resolvedTypeParameters = new HashMap();
            Type delegateType = decorator.getDelegateType();
            if (delegateType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                List typeArguments = delegateType.asParameterizedType().arguments();
                for (int i = 0; i < typeParameters.size(); ++i) {
                    resolvedTypeParameters.put(((TypeVariable)typeParameters.get(i)).identifier(), (Type)typeArguments.get(i));
                }
            }
        }
        for (Methods.MethodKey m : methods) {
            MethodDescriptor resolvedMethodDescriptor;
            MethodInfo method = m.method;
            MethodDescriptor methodDescriptor = MethodDescriptor.of((MethodInfo)method);
            MethodCreator forward = delegateSubclass.getMethodCreator(methodDescriptor);
            for (Type exception : method.exceptions()) {
                forward.addException(exception.toString());
            }
            ResultHandle ret = null;
            List parameters = method.parameterTypes();
            ResultHandle[] params = new ResultHandle[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                params[i] = forward.getMethodParam(i);
            }
            if (typeParameters.isEmpty() || !Methods.containsTypeVariableParameter(method) && !Types.containsTypeVariable(method.returnType())) {
                resolvedMethodDescriptor = null;
            } else {
                List<Type> paramTypes = Types.getResolvedParameters(delegateTypeClass, resolvedTypeParameters, method, index);
                Type returnType = Types.resolveTypeParam(method.returnType(), resolvedTypeParameters, index);
                String[] paramTypesArray = new String[paramTypes.size()];
                for (int i = 0; i < paramTypesArray.length; ++i) {
                    paramTypesArray[i] = DescriptorUtils.typeToString((Type)paramTypes.get(i));
                }
                resolvedMethodDescriptor = MethodDescriptor.ofMethod((String)method.declaringClass().toString(), (String)method.name(), (String)DescriptorUtils.typeToString((Type)returnType), (String[])paramTypesArray);
            }
            BeanInfo.DecoratorMethod nextDecorator = null;
            MethodDescriptor nextDecoratorDecorated = null;
            for (Map.Entry<MethodDescriptor, BeanInfo.DecoratorMethod> e : nextDecorators.entrySet()) {
                if (!Methods.descriptorMatches(e.getKey(), methodDescriptor) && (resolvedMethodDescriptor == null || !Methods.descriptorMatches(e.getKey(), resolvedMethodDescriptor)) && !Methods.descriptorMatches(MethodDescriptor.of((MethodInfo)e.getValue().method), methodDescriptor)) continue;
                nextDecorator = e.getValue();
                nextDecoratorDecorated = e.getKey();
                break;
            }
            if (nextDecorator != null && this.isDecorated(decoratedMethodDescriptors, methodDescriptor, resolvedMethodDescriptor, nextDecoratorDecorated)) {
                delegateTo = forward.readInstanceField((FieldDescriptor)nextDecoratorToField.get(nextDecorator.decorator), forward.getThis());
                if (delegateTypeIsInterface) {
                    ret = forward.invokeInterfaceMethod(methodDescriptor, delegateTo, params);
                } else {
                    MethodDescriptor virtualMethod = MethodDescriptor.ofMethod((Object)providerTypeName, (String)methodDescriptor.getName(), (Object)nextDecorator.method.returnType(), (Object[])new Object[]{nextDecorator.method.parameterTypes()});
                    ret = forward.invokeVirtualMethod(virtualMethod, delegateTo, params);
                }
            } else {
                MethodDescriptor forwardingMethod = null;
                MethodInfo decoratedMethod = bean.getDecoratedMethod(m.method, decorator);
                MethodDescriptor decoratedMethodDescriptor = decoratedMethod != null ? MethodDescriptor.of((MethodInfo)decoratedMethod) : null;
                for (Map.Entry<MethodDescriptor, MethodDescriptor> entry : forwardingMethods.entrySet()) {
                    if (!Methods.descriptorMatches(entry.getKey(), methodDescriptor) && (resolvedMethodDescriptor == null || !Methods.descriptorMatches(entry.getKey(), resolvedMethodDescriptor)) && (decoratedMethodDescriptor == null || !Methods.descriptorMatches(entry.getKey(), decoratedMethodDescriptor))) continue;
                    forwardingMethod = entry.getValue();
                    break;
                }
                if (forwardingMethod != null) {
                    delegateTo = forward.readInstanceField(subclassField.getFieldDescriptor(), forward.getThis());
                    ret = forward.invokeVirtualMethod(forwardingMethod, delegateTo, params);
                } else {
                    delegateTo = forward.readInstanceField(subclassField.getFieldDescriptor(), forward.getThis());
                    ret = Modifier.isInterface(method.declaringClass().flags()) ? forward.invokeInterfaceMethod(methodDescriptor, delegateTo, params) : forward.invokeVirtualMethod(methodDescriptor, delegateTo, params);
                }
            }
            forward.returnValue(ret);
        }
        delegateSubclass.close();
        ResultHandle constructorMethodParam = subclassConstructor.getMethodParam(paramIndex);
        ResultHandle creationalContext = subclassConstructor.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{creationalContextHandle});
        ResultHandle[] paramHandles = new ResultHandle[constructorParameterTypes.size()];
        int paramIdx = 0;
        paramHandles[paramIdx++] = subclassConstructor.getThis();
        for (DecoratorInfo decoratorParameter : decoratorParameters) {
            ResultHandle decoratorHandle = decoratorToResultHandle.get(decoratorParameter.getIdentifier());
            if (decoratorHandle == null) {
                throw new IllegalStateException("Decorator handle must not be null");
            }
            paramHandles[paramIdx++] = decoratorHandle;
        }
        ResultHandle delegateSubclassInstance = subclassConstructor.newInstance(MethodDescriptor.ofConstructor((String)delegateSubclass.getClassName(), (String[])constructorParameterTypes.toArray(new String[0])), paramHandles);
        ResultHandle prev = subclassConstructor.invokeStaticMethod(MethodDescriptors.DECORATOR_DELEGATE_PROVIDER_SET, new ResultHandle[]{creationalContext, delegateSubclassInstance});
        ResultHandle decoratorInstance = subclassConstructor.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, constructorMethodParam, new ResultHandle[]{creationalContext});
        subclassConstructor.invokeStaticMethod(MethodDescriptors.DECORATOR_DELEGATE_PROVIDER_SET, new ResultHandle[]{creationalContext, prev});
        decoratorToResultHandle.put(decorator.getIdentifier(), decoratorInstance);
        FieldCreator decoratorField = (FieldCreator)subclass.getFieldCreator(decorator.getIdentifier(), Object.class).setModifiers(18);
        subclassConstructor.writeInstanceField(decoratorField.getFieldDescriptor(), subclassConstructor.getThis(), decoratorInstance);
    }

    private boolean isDecorated(Set<MethodDescriptor> decoratedMethodDescriptors, MethodDescriptor original, MethodDescriptor resolved, MethodDescriptor nextDecoratorDecorated) {
        for (MethodDescriptor decorated : decoratedMethodDescriptors) {
            if (!Methods.descriptorMatches(decorated, original) && (resolved == null || !Methods.descriptorMatches(decorated, resolved)) && !Methods.descriptorMatches(decorated, nextDecoratorDecorated)) continue;
            return true;
        }
        return false;
    }

    static MethodDescriptor createForwardingMethod(ClassCreator subclass, String providerTypeName, MethodInfo method, ForwardInvokeGenerator forwardInvokeGenerator) {
        MethodDescriptor methodDescriptor = MethodDescriptor.of((MethodInfo)method);
        String forwardMethodName = method.name() + "$$superforward";
        MethodDescriptor forwardDescriptor = MethodDescriptor.ofMethod((String)subclass.getClassName(), (String)forwardMethodName, (String)methodDescriptor.getReturnType(), (String[])methodDescriptor.getParameterTypes());
        MethodCreator forward = subclass.getMethodCreator(forwardDescriptor);
        List parameters = method.parameterTypes();
        ResultHandle[] params = new ResultHandle[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            params[i] = forward.getMethodParam(i);
        }
        MethodDescriptor virtualMethod = MethodDescriptor.ofMethod((String)providerTypeName, (String)methodDescriptor.getName(), (String)methodDescriptor.getReturnType(), (String[])methodDescriptor.getParameterTypes());
        forward.returnValue(forwardInvokeGenerator.generate((BytecodeCreator)forward, virtualMethod, params));
        return forwardDescriptor;
    }

    static void createInterceptedMethod(MethodInfo method, ClassCreator subclass, FieldDescriptor metadataField, FieldDescriptor constructedField, MethodDescriptor forwardMethod, Function<BytecodeCreator, ResultHandle> getTarget) {
        ResultHandle paramsHandle;
        MethodDescriptor originalMethodDescriptor = MethodDescriptor.of((MethodInfo)method);
        MethodCreator interceptedMethod = subclass.getMethodCreator(originalMethodDescriptor);
        List parameters = method.parameterTypes();
        if (parameters.isEmpty()) {
            paramsHandle = interceptedMethod.loadNull();
        } else {
            paramsHandle = interceptedMethod.newArray(Object.class, interceptedMethod.load(parameters.size()));
            for (int i = 0; i < parameters.size(); ++i) {
                interceptedMethod.writeArrayValue(paramsHandle, i, interceptedMethod.getMethodParam(i));
            }
        }
        BytecodeCreator notConstructed = interceptedMethod.ifFalse(interceptedMethod.readInstanceField(constructedField, interceptedMethod.getThis())).trueBranch();
        ResultHandle[] params = new ResultHandle[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            params[i] = notConstructed.getMethodParam(i);
        }
        if (Modifier.isAbstract(method.flags())) {
            notConstructed.throwException(IllegalStateException.class, "Cannot delegate to an abstract method");
        } else {
            notConstructed.returnValue(notConstructed.invokeVirtualMethod(forwardMethod, notConstructed.getThis(), params));
        }
        for (Type declaredException : method.exceptions()) {
            interceptedMethod.addException(declaredException.name().toString());
        }
        TryBlock tryCatch = interceptedMethod.tryBlock();
        boolean addCatchRuntimeException = true;
        boolean addCatchException = true;
        LinkedHashSet<DotName> declaredExceptions = new LinkedHashSet<DotName>(method.exceptions().size());
        for (Type type : method.exceptions()) {
            declaredExceptions.add(type.name());
        }
        for (DotName dotName : declaredExceptions) {
            CatchBlockCreator catchDeclaredException = tryCatch.addCatch(dotName.toString());
            catchDeclaredException.throwException(catchDeclaredException.getCaughtException());
            if (JAVA_LANG_RUNTIME_EXCEPTION.equals((Object)dotName) || JAVA_LANG_THROWABLE.equals((Object)dotName)) {
                addCatchRuntimeException = false;
            }
            if (!JAVA_LANG_EXCEPTION.equals((Object)dotName) && !JAVA_LANG_THROWABLE.equals((Object)dotName)) continue;
            addCatchException = false;
        }
        if (addCatchRuntimeException) {
            CatchBlockCreator catchRuntimeException = tryCatch.addCatch(RuntimeException.class);
            catchRuntimeException.throwException(catchRuntimeException.getCaughtException());
        }
        if (addCatchException && !KotlinUtils.isKotlinMethod(method)) {
            CatchBlockCreator catchOtherExceptions = tryCatch.addCatch(Exception.class);
            catchOtherExceptions.throwException(ArcUndeclaredThrowableException.class, "Error invoking subclass method", catchOtherExceptions.getCaughtException());
        }
        ResultHandle methodMetadataHandle = tryCatch.readInstanceField(metadataField, tryCatch.getThis());
        ResultHandle resultHandle = tryCatch.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_PERFORM_AROUND_INVOKE, new ResultHandle[]{getTarget.apply((BytecodeCreator)tryCatch), paramsHandle, methodMetadataHandle});
        tryCatch.returnValue(resultHandle);
    }

    protected void createDestroy(ClassOutput classOutput, BeanInfo bean, ClassCreator subclass, FieldDescriptor preDestroysField) {
        if (preDestroysField != null) {
            MethodCreator destroy = subclass.getMethodCreator(MethodDescriptor.ofMethod((Object)subclass.getClassName(), (String)DESTROY_METHOD_NAME, Void.TYPE, (Object[])new Object[]{Runnable.class}));
            ResultHandle predestroysHandle = destroy.readInstanceField(preDestroysField, destroy.getThis());
            ResultHandle forward = destroy.getMethodParam(0);
            BeanInfo.InterceptionInfo preDestroy = bean.getLifecycleInterceptors(InterceptionType.PRE_DESTROY);
            ResultHandle bindingsArray = destroy.newArray(Object.class, preDestroy.bindings.size());
            int bindingsIndex = 0;
            for (AnnotationInstance binding : preDestroy.bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                destroy.writeArrayValue(bindingsArray, bindingsIndex++, this.annotationLiterals.create((BytecodeCreator)destroy, bindingClass, binding));
            }
            TryBlock tryCatch = destroy.tryBlock();
            CatchBlockCreator exception = tryCatch.addCatch(Exception.class);
            exception.throwException(RuntimeException.class, "Error destroying subclass", exception.getCaughtException());
            ResultHandle invocationContext = tryCatch.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_PRE_DESTROY, new ResultHandle[]{tryCatch.getThis(), predestroysHandle, tryCatch.invokeStaticMethod(MethodDescriptors.SETS_OF, new ResultHandle[]{bindingsArray}), forward});
            tryCatch.invokeInterfaceMethod(MethodDescriptors.INVOCATION_CONTEXT_PROCEED, invocationContext, new ResultHandle[0]);
            destroy.returnValue(null);
        }
    }

    @FunctionalInterface
    static interface ForwardInvokeGenerator {
        public ResultHandle generate(BytecodeCreator var1, MethodDescriptor var2, ResultHandle[] var3);
    }

    static class IntegerHolder {
        int i = 1;

        IntegerHolder() {
        }
    }
}

