/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.InstanceImpl;
import io.quarkus.arc.impl.SyntheticCreationalContextImpl;
import io.quarkus.arc.impl.bcextensions.ParametersImpl;
import io.quarkus.arc.processor.BeanArchives;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ConfiguratorBase;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.CustomAlterableContexts;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.InvokerFactory;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.arc.processor.ObserverRegistrar;
import io.quarkus.arc.processor.QualifierRegistrar;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.StereotypeRegistrar;
import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AllAnnotationTransformations;
import io.quarkus.arc.processor.bcextensions.BuildServicesImpl;
import io.quarkus.arc.processor.bcextensions.ExtensionInvoker;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseDiscovery;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseEnhancement;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseRegistration;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseSynthesis;
import io.quarkus.arc.processor.bcextensions.ExtensionPhaseValidation;
import io.quarkus.arc.processor.bcextensions.MetaAnnotationsImpl;
import io.quarkus.arc.processor.bcextensions.SharedErrors;
import io.quarkus.arc.processor.bcextensions.SyntheticBeanBuilderImpl;
import io.quarkus.arc.processor.bcextensions.SyntheticObserverBuilderImpl;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.Parameters;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanCreator;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanDisposer;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticObserver;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.util.Nonbinding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class ExtensionsEntryPoint {
    private final ExtensionInvoker invoker;
    private final AllAnnotationOverlays annotationOverlays;
    private final SharedErrors errors;
    private final Map<DotName, ClassConfig> qualifiers;
    private final Map<DotName, ClassConfig> interceptorBindings;
    private final Map<DotName, ClassConfig> stereotypes;
    private final List<MetaAnnotationsImpl.ContextData> contexts;
    private volatile AllAnnotationTransformations preAnnotationTransformations;
    private final List<SyntheticBeanBuilderImpl<?>> syntheticBeans;
    private final List<SyntheticObserverBuilderImpl<?>> syntheticObservers;

    public ExtensionsEntryPoint() {
        this(List.of());
    }

    public ExtensionsEntryPoint(List<BuildCompatibleExtension> extensions) {
        this.invoker = new ExtensionInvoker(extensions);
        if (this.invoker.isEmpty()) {
            this.annotationOverlays = null;
            this.errors = null;
            this.qualifiers = null;
            this.interceptorBindings = null;
            this.stereotypes = null;
            this.contexts = null;
            this.syntheticBeans = null;
            this.syntheticObservers = null;
        } else {
            this.annotationOverlays = new AllAnnotationOverlays();
            this.errors = new SharedErrors();
            this.qualifiers = new ConcurrentHashMap<DotName, ClassConfig>();
            this.interceptorBindings = new ConcurrentHashMap<DotName, ClassConfig>();
            this.stereotypes = new ConcurrentHashMap<DotName, ClassConfig>();
            this.contexts = Collections.synchronizedList(new ArrayList());
            this.syntheticBeans = Collections.synchronizedList(new ArrayList());
            this.syntheticObservers = Collections.synchronizedList(new ArrayList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDiscovery(IndexView applicationIndex, Set<String> additionalClasses) {
        if (this.invoker.isEmpty()) {
            return;
        }
        try {
            BuildServicesImpl.init(applicationIndex, this.annotationOverlays);
            this.preAnnotationTransformations = new AllAnnotationTransformations(applicationIndex, this.annotationOverlays);
            IndexView computingApplicationIndex = BeanArchives.buildComputingBeanArchiveIndex(Thread.currentThread().getContextClassLoader(), new ConcurrentHashMap<DotName, Optional<ClassInfo>>(), applicationIndex);
            new ExtensionPhaseDiscovery(this.invoker, computingApplicationIndex, this.errors, additionalClasses, this.preAnnotationTransformations, this.qualifiers, this.interceptorBindings, this.stereotypes, this.contexts).run();
        }
        finally {
            this.preAnnotationTransformations.freeze();
            BuildServicesImpl.reset();
        }
    }

    public void registerMetaAnnotations(BeanProcessor.Builder builder, final CustomAlterableContexts customAlterableContexts) {
        if (this.invoker.isEmpty()) {
            return;
        }
        builder.addAnnotationTransformer(this.preAnnotationTransformations.classes);
        builder.addAnnotationTransformer(this.preAnnotationTransformations.methods);
        builder.addAnnotationTransformer(this.preAnnotationTransformations.parameters);
        builder.addAnnotationTransformer(this.preAnnotationTransformations.fields);
        if (!this.qualifiers.isEmpty()) {
            builder.addQualifierRegistrar(new QualifierRegistrar(){

                @Override
                public Map<DotName, Set<String>> getAdditionalQualifiers() {
                    HashMap<DotName, Set<String>> result = new HashMap<DotName, Set<String>>();
                    for (Map.Entry<DotName, ClassConfig> entry : ExtensionsEntryPoint.this.qualifiers.entrySet()) {
                        DotName annotationName = entry.getKey();
                        ClassConfig config = entry.getValue();
                        Set nonbindingMembers = config.methods().stream().filter(it -> it.info().hasAnnotation(Nonbinding.class)).map(it -> it.info().name()).collect(Collectors.toUnmodifiableSet());
                        result.put(annotationName, nonbindingMembers);
                    }
                    return result;
                }
            });
        }
        if (!this.interceptorBindings.isEmpty()) {
            builder.addInterceptorBindingRegistrar(new InterceptorBindingRegistrar(){

                @Override
                public List<InterceptorBindingRegistrar.InterceptorBinding> getAdditionalBindings() {
                    return ExtensionsEntryPoint.this.interceptorBindings.entrySet().stream().map(entry -> {
                        DotName annotationName = (DotName)entry.getKey();
                        ClassConfig config = (ClassConfig)entry.getValue();
                        Set<String> nonbindingMembers = config.methods().stream().filter(it -> it.info().hasAnnotation(Nonbinding.class)).map(it -> it.info().name()).collect(Collectors.toUnmodifiableSet());
                        return InterceptorBindingRegistrar.InterceptorBinding.of(annotationName, nonbindingMembers);
                    }).collect(Collectors.toUnmodifiableList());
                }
            });
        }
        if (!this.stereotypes.isEmpty()) {
            builder.addStereotypeRegistrar(new StereotypeRegistrar(){

                @Override
                public Set<DotName> getAdditionalStereotypes() {
                    return ExtensionsEntryPoint.this.stereotypes.keySet();
                }
            });
        }
        if (!this.contexts.isEmpty()) {
            for (final MetaAnnotationsImpl.ContextData context : this.contexts) {
                builder.addContextRegistrar(new ContextRegistrar(){

                    @Override
                    public void register(ContextRegistrar.RegistrationContext registrationContext) {
                        Class<? extends Annotation> scopeAnnotation = context.scopeAnnotation;
                        Class<? extends AlterableContext> contextClass = context.contextClass;
                        ContextConfigurator config = registrationContext.configure(scopeAnnotation);
                        if (InjectableContext.class.isAssignableFrom(contextClass)) {
                            config.contextClass(contextClass);
                        } else {
                            CustomAlterableContexts.CustomAlterableContextInfo info = customAlterableContexts.add(contextClass, context.isNormal, scopeAnnotation);
                            config.creator(bytecode -> bytecode.newInstance(MethodDescriptor.ofConstructor((String)info.generatedName, (String[])new String[0]), new ResultHandle[0]));
                        }
                        if (context.isNormal != null) {
                            config.normal(context.isNormal);
                        }
                        config.done();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEnhancement(IndexView beanArchiveIndex, BeanProcessor.Builder builder) {
        if (this.invoker.isEmpty()) {
            return;
        }
        AllAnnotationTransformations annotationTransformations = new AllAnnotationTransformations(beanArchiveIndex, this.annotationOverlays);
        builder.addAnnotationTransformer(annotationTransformations.classes);
        builder.addAnnotationTransformer(annotationTransformations.methods);
        builder.addAnnotationTransformer(annotationTransformations.parameters);
        builder.addAnnotationTransformer(annotationTransformations.fields);
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlays);
        try {
            new ExtensionPhaseEnhancement(this.invoker, beanArchiveIndex, this.errors, annotationTransformations).run();
        }
        finally {
            annotationTransformations.freeze();
            BuildServicesImpl.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRegistration(IndexView beanArchiveIndex, Collection<BeanInfo> allBeans, Collection<InterceptorInfo> allInterceptors, Collection<ObserverInfo> allObservers, InvokerFactory invokerFactory) {
        if (this.invoker.isEmpty()) {
            return;
        }
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlays);
        try {
            new ExtensionPhaseRegistration(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlays, allBeans, allInterceptors, allObservers, invokerFactory).run();
        }
        finally {
            BuildServicesImpl.reset();
        }
    }

    public void runSynthesis(IndexView beanArchiveIndex) {
        if (this.invoker.isEmpty()) {
            return;
        }
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlays);
        try {
            new ExtensionPhaseSynthesis(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlays, this.syntheticBeans, this.syntheticObservers).run();
        }
        finally {
            BuildServicesImpl.reset();
        }
    }

    public void registerSyntheticBeans(BeanRegistrar.RegistrationContext context, Predicate<DotName> isApplicationClass) {
        if (this.invoker.isEmpty()) {
            return;
        }
        Map<DotName, StereotypeInfo> allStereotypes = context.get(BuildExtension.Key.STEREOTYPES);
        for (SyntheticBeanBuilderImpl<?> syntheticBean : this.syntheticBeans) {
            StereotypeInfo[] stereotypes = (StereotypeInfo[])syntheticBean.stereotypes.stream().map(allStereotypes::get).toArray(StereotypeInfo[]::new);
            boolean dependentByStereotype = false;
            for (StereotypeInfo stereotype : Beans.stereotypesWithTransitive(Arrays.asList(stereotypes), allStereotypes)) {
                ScopeInfo defaultScope = stereotype.getDefaultScope();
                if (defaultScope == null || !BuiltinScope.DEPENDENT.is(defaultScope)) continue;
                dependentByStereotype = true;
                break;
            }
            BeanConfigurator bean = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)context.configure(syntheticBean.implementationClass).types(syntheticBean.types.toArray(new Type[0]))).qualifiers(syntheticBean.qualifiers.toArray(new AnnotationInstance[0]))).stereotypes(stereotypes);
            if (syntheticBean.scope != null) {
                bean.scope(syntheticBean.scope);
            }
            if (syntheticBean.name != null) {
                bean.name(syntheticBean.name);
            }
            if (syntheticBean.isAlternative) {
                bean.alternative(true);
            }
            if (syntheticBean.priority != null) {
                bean.priority(syntheticBean.priority);
            }
            this.configureParams(bean, syntheticBean.params);
            boolean isDependent = syntheticBean.scope == null || Dependent.class.equals(syntheticBean.scope) || dependentByStereotype;
            bean.creator(mc -> {
                ResultHandle synthCC = mc.checkCast(mc.getMethodParam(0), SyntheticCreationalContextImpl.class);
                ResultHandle delegateCC = mc.invokeVirtualMethod(MethodDescriptor.ofMethod(SyntheticCreationalContextImpl.class, (String)"getDelegateCreationalContext", CreationalContext.class, (Class[])new Class[0]), synthCC, new ResultHandle[0]);
                ResultHandle ccImpl = mc.checkCast(delegateCC, CreationalContextImpl.class);
                ResultHandle lookup = mc.invokeStaticMethod(MethodDescriptor.ofMethod(InstanceImpl.class, (String)"forSynthesis", Instance.class, (Class[])new Class[]{CreationalContextImpl.class, Boolean.TYPE}), new ResultHandle[]{ccImpl, mc.load(isDependent)});
                ResultHandle paramsMap = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
                ResultHandle params = mc.newInstance(MethodDescriptor.ofConstructor(ParametersImpl.class, (Class[])new Class[]{Map.class}), new ResultHandle[]{paramsMap});
                ResultHandle creator = mc.newInstance(MethodDescriptor.ofConstructor(syntheticBean.creatorClass, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle[] args = new ResultHandle[]{lookup, params};
                ResultHandle instance = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(SyntheticBeanCreator.class, (String)"create", Object.class, (Class[])new Class[]{Instance.class, Parameters.class}), creator, args);
                mc.returnValue(instance);
            });
            if (syntheticBean.disposerClass != null) {
                bean.destroyer(mc -> {
                    ResultHandle creationalContextImpl = mc.checkCast(mc.getMethodParam(1), CreationalContextImpl.class);
                    ResultHandle lookup = mc.invokeStaticMethod(MethodDescriptor.ofMethod(InstanceImpl.class, (String)"forSynthesis", Instance.class, (Class[])new Class[]{CreationalContextImpl.class, Boolean.TYPE}), new ResultHandle[]{creationalContextImpl, mc.load(false)});
                    ResultHandle paramsMap = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
                    ResultHandle params = mc.newInstance(MethodDescriptor.ofConstructor(ParametersImpl.class, (Class[])new Class[]{Map.class}), new ResultHandle[]{paramsMap});
                    ResultHandle disposer = mc.newInstance(MethodDescriptor.ofConstructor(syntheticBean.disposerClass, (Class[])new Class[0]), new ResultHandle[0]);
                    ResultHandle[] args = new ResultHandle[]{mc.getMethodParam(0), lookup, params};
                    mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(SyntheticBeanDisposer.class, (String)"dispose", Void.TYPE, (Class[])new Class[]{Object.class, Instance.class, Parameters.class}), disposer, args);
                    mc.invokeVirtualMethod(MethodDescriptor.ofMethod(CreationalContextImpl.class, (String)"release", Void.TYPE, (Class[])new Class[0]), creationalContextImpl, new ResultHandle[0]);
                    mc.returnValue(null);
                });
            }
            if (isApplicationClass.test(DotName.createSimple(syntheticBean.creatorClass))) {
                bean.forceApplicationClass();
            }
            if (syntheticBean.disposerClass != null && isApplicationClass.test(DotName.createSimple(syntheticBean.disposerClass))) {
                bean.forceApplicationClass();
            }
            bean.done();
        }
    }

    public void registerSyntheticObservers(ObserverRegistrar.RegistrationContext context, Predicate<DotName> isApplicationClass) {
        if (this.invoker.isEmpty()) {
            return;
        }
        for (SyntheticObserverBuilderImpl<?> syntheticObserver : this.syntheticObservers) {
            if (syntheticObserver.isAsync && syntheticObserver.transactionPhase != TransactionPhase.IN_PROGRESS) {
                throw new IllegalStateException("Synthetic observer declared as asynchronous and transactional (event type " + syntheticObserver.type + ", \"declared\" by " + syntheticObserver.declaringClass + ", notified using " + syntheticObserver.implementationClass + ")");
            }
            ObserverConfigurator observer = context.configure().beanClass(syntheticObserver.declaringClass).observedType(syntheticObserver.type).qualifiers(syntheticObserver.qualifiers.toArray(new AnnotationInstance[0])).priority(syntheticObserver.priority).async(syntheticObserver.isAsync).transactionPhase(syntheticObserver.transactionPhase);
            this.configureParams(observer, syntheticObserver.params);
            observer.notify(mc -> {
                ResultHandle instance = mc.newInstance(MethodDescriptor.ofConstructor(syntheticObserver.implementationClass, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle paramsMap = mc.readInstanceField(FieldDescriptor.of((String)mc.getMethodDescriptor().getDeclaringClass(), (String)"params", Map.class), mc.getThis());
                ResultHandle params = mc.newInstance(MethodDescriptor.ofConstructor(ParametersImpl.class, (Class[])new Class[]{Map.class}), new ResultHandle[]{paramsMap});
                ResultHandle[] args = new ResultHandle[]{mc.getMethodParam(0), params};
                mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(SyntheticObserver.class, (String)"observe", Void.TYPE, (Class[])new Class[]{EventContext.class, Parameters.class}), instance, args);
                mc.returnValue(null);
            });
            if (isApplicationClass.test(DotName.createSimple(syntheticObserver.implementationClass))) {
                observer.forceApplicationClass();
            }
            observer.done();
        }
    }

    private void configureParams(ConfiguratorBase<?> configurator, Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                configurator.param(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof boolean[]) {
                configurator.param(entry.getKey(), (boolean[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Byte) {
                configurator.param(entry.getKey(), (Byte)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof byte[]) {
                configurator.param(entry.getKey(), (byte[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Short) {
                configurator.param(entry.getKey(), (Short)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof short[]) {
                configurator.param(entry.getKey(), (short[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                configurator.param(entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof int[]) {
                configurator.param(entry.getKey(), (int[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Long) {
                configurator.param(entry.getKey(), (Long)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof long[]) {
                configurator.param(entry.getKey(), (long[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Float) {
                configurator.param(entry.getKey(), ((Float)entry.getValue()).floatValue());
                continue;
            }
            if (entry.getValue() instanceof float[]) {
                configurator.param(entry.getKey(), (float[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Double) {
                configurator.param(entry.getKey(), (Double)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof double[]) {
                configurator.param(entry.getKey(), (double[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Character) {
                configurator.param(entry.getKey(), ((Character)entry.getValue()).charValue());
                continue;
            }
            if (entry.getValue() instanceof char[]) {
                configurator.param(entry.getKey(), (char[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof String) {
                configurator.param(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof String[]) {
                configurator.param(entry.getKey(), (String[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Enum) {
                configurator.param(entry.getKey(), (Enum)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Enum[]) {
                configurator.param(entry.getKey(), (Enum[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Class) {
                configurator.param(entry.getKey(), (Class)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Class[]) {
                configurator.param(entry.getKey(), (Class[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ClassInfo) {
                configurator.param(entry.getKey(), (ClassInfo)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ClassInfo[]) {
                configurator.param(entry.getKey(), (ClassInfo[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof AnnotationInstance) {
                configurator.param(entry.getKey(), (AnnotationInstance)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof AnnotationInstance[]) {
                configurator.param(entry.getKey(), (AnnotationInstance[])entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof InvokerInfo) {
                configurator.param(entry.getKey(), (InvokerInfo)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof InvokerInfo[]) {
                configurator.param(entry.getKey(), (InvokerInfo[])entry.getValue());
                continue;
            }
            throw new IllegalStateException("Unknown param: " + entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRegistrationAgain(IndexView beanArchiveIndex, Collection<BeanInfo> allBeans, Collection<ObserverInfo> allObservers, InvokerFactory invokerFactory) {
        if (this.invoker.isEmpty()) {
            return;
        }
        Collection syntheticBeans = allBeans.stream().filter(BeanInfo::isSynthetic).collect(Collectors.toUnmodifiableList());
        Collection syntheticObservers = allObservers.stream().filter(ObserverInfo::isSynthetic).collect(Collectors.toUnmodifiableList());
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlays);
        try {
            new ExtensionPhaseRegistration(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlays, syntheticBeans, Collections.emptyList(), syntheticObservers, invokerFactory).run();
        }
        finally {
            BuildServicesImpl.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runValidation(IndexView beanArchiveIndex, Collection<BeanInfo> allBeans, Collection<ObserverInfo> allObservers) {
        if (this.invoker.isEmpty()) {
            return;
        }
        BuildServicesImpl.init(beanArchiveIndex, this.annotationOverlays);
        try {
            new ExtensionPhaseValidation(this.invoker, beanArchiveIndex, this.errors, this.annotationOverlays, allBeans, allObservers).run();
        }
        finally {
            BuildServicesImpl.reset();
        }
    }

    public void registerValidationErrors(BeanDeploymentValidator.ValidationContext context) {
        if (this.invoker.isEmpty()) {
            return;
        }
        for (Throwable error : this.errors.list) {
            context.addDeploymentProblem(error);
        }
        this.invoker.invalidate();
        this.annotationOverlays.invalidate();
    }
}

