/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.All;
import io.quarkus.arc.Lock;
import io.quarkus.arc.impl.ActivateRequestContextInterceptor;
import io.quarkus.arc.impl.DefaultAsyncObserverExceptionHandler;
import io.quarkus.arc.impl.Identified;
import io.quarkus.arc.impl.InjectableRequestContextController;
import io.quarkus.arc.impl.LockInterceptor;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Types;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.control.ActivateRequestContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.Model;
import javax.inject.Named;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.ModuleInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public final class BeanArchives {
    private static final Logger LOGGER = Logger.getLogger(BeanArchives.class);

    public static IndexView buildImmutableBeanArchiveIndex(IndexView ... applicationIndexes) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        Collections.addAll(indexes, applicationIndexes);
        indexes.add(BeanArchives.buildAdditionalIndex());
        return CompositeIndex.create(indexes);
    }

    public static IndexView buildComputingBeanArchiveIndex(ClassLoader deploymentClassLoader, Map<DotName, Optional<ClassInfo>> additionalClasses, IndexView immutableIndex) {
        return new IndexWrapper(immutableIndex, deploymentClassLoader, additionalClasses);
    }

    private static IndexView buildAdditionalIndex() {
        Indexer indexer = new Indexer();
        BeanArchives.index(indexer, ActivateRequestContext.class.getName());
        BeanArchives.index(indexer, Default.class.getName());
        BeanArchives.index(indexer, Any.class.getName());
        BeanArchives.index(indexer, Named.class.getName());
        BeanArchives.index(indexer, Initialized.class.getName());
        BeanArchives.index(indexer, BeforeDestroyed.class.getName());
        BeanArchives.index(indexer, Destroyed.class.getName());
        BeanArchives.index(indexer, Intercepted.class.getName());
        BeanArchives.index(indexer, Model.class.getName());
        BeanArchives.index(indexer, Lock.class.getName());
        BeanArchives.index(indexer, All.class.getName());
        BeanArchives.index(indexer, Identified.class.getName());
        BeanArchives.index(indexer, ActivateRequestContextInterceptor.class.getName());
        BeanArchives.index(indexer, InjectableRequestContextController.class.getName());
        BeanArchives.index(indexer, LockInterceptor.class.getName());
        BeanArchives.index(indexer, DefaultAsyncObserverExceptionHandler.class.getName());
        return indexer.complete();
    }

    static boolean index(Indexer indexer, String className) {
        return BeanArchives.index(indexer, className, BeanArchives.class.getClassLoader());
    }

    static boolean index(Indexer indexer, String className, ClassLoader classLoader) {
        boolean result = false;
        if (Types.isPrimitiveClassName(className) || className.startsWith("[")) {
            return false;
        }
        if (BeanArchives.isInUnnamedPackage(className)) {
            LOGGER.debugf("Class %s is defined in an unnamed package; skipping indexing", (Object)className);
            return false;
        }
        try (InputStream stream = classLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
            if (stream != null) {
                indexer.index(stream);
                result = true;
            } else {
                LOGGER.warnf("Failed to index %s: Class does not exist in ClassLoader %s", (Object)className, (Object)classLoader);
            }
        }
        catch (IOException e) {
            LOGGER.warnf((Throwable)e, "Failed to index %s: %s", (Object)className, (Object)e.getMessage());
        }
        return result;
    }

    private static boolean isInUnnamedPackage(String className) {
        return !className.contains(".");
    }

    static class IndexWrapper
    implements IndexView {
        private final IndexView index;
        private final ClassLoader deploymentClassLoader;
        final Map<DotName, Optional<ClassInfo>> additionalClasses;

        public IndexWrapper(IndexView index, ClassLoader deploymentClassLoader, Map<DotName, Optional<ClassInfo>> additionalClasses) {
            this.index = index;
            this.deploymentClassLoader = deploymentClassLoader;
            this.additionalClasses = additionalClasses;
        }

        public Collection<ClassInfo> getKnownClasses() {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getKnownClasses();
            }
            ArrayList<ClassInfo> all = new ArrayList<ClassInfo>(this.index.getKnownClasses());
            for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
                if (!additional.isPresent()) continue;
                all.add(additional.get());
            }
            return all;
        }

        public ClassInfo getClassByName(DotName className) {
            ClassInfo classInfo = IndexClassLookupUtils.getClassByName(this.index, className, false);
            if (classInfo == null) {
                classInfo = this.additionalClasses.computeIfAbsent(className, this::computeAdditional).orElse(null);
            }
            return classInfo;
        }

        public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getKnownDirectSubclasses(className);
            }
            HashSet<ClassInfo> directSubclasses = new HashSet<ClassInfo>(this.index.getKnownDirectSubclasses(className));
            for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
                if (!additional.isPresent() || !className.equals((Object)additional.get().superName())) continue;
                directSubclasses.add(additional.get());
            }
            return directSubclasses;
        }

        public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getAllKnownSubclasses(className);
            }
            HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
            HashSet<DotName> processedClasses = new HashSet<DotName>();
            this.getAllKnownSubClasses(className, allKnown, processedClasses);
            return allKnown;
        }

        private void getAllKnownSubClasses(DotName className, Set<ClassInfo> allKnown, Set<DotName> processedClasses) {
            HashSet<DotName> subClassesToProcess = new HashSet<DotName>();
            subClassesToProcess.add(className);
            while (!subClassesToProcess.isEmpty()) {
                Iterator toProcess = subClassesToProcess.iterator();
                DotName name = (DotName)toProcess.next();
                toProcess.remove();
                processedClasses.add(name);
                this.getAllKnownSubClasses(name, allKnown, subClassesToProcess, processedClasses);
            }
        }

        private void getAllKnownSubClasses(DotName name, Set<ClassInfo> allKnown, Set<DotName> subClassesToProcess, Set<DotName> processedClasses) {
            Collection<ClassInfo> directSubclasses = this.getKnownDirectSubclasses(name);
            if (directSubclasses != null) {
                for (ClassInfo clazz : directSubclasses) {
                    DotName className = clazz.name();
                    if (processedClasses.contains(className)) continue;
                    allKnown.add(clazz);
                    subClassesToProcess.add(className);
                }
            }
        }

        public Collection<ClassInfo> getKnownDirectSubinterfaces(DotName interfaceName) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getKnownDirectSubinterfaces(interfaceName);
            }
            HashSet<ClassInfo> directSubinterfaces = new HashSet<ClassInfo>(this.index.getKnownDirectSubinterfaces(interfaceName));
            for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
                if (!additional.isPresent() || !additional.get().interfaceNames().contains(interfaceName)) continue;
                directSubinterfaces.add(additional.get());
            }
            return directSubinterfaces;
        }

        public Collection<ClassInfo> getAllKnownSubinterfaces(DotName interfaceName) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getAllKnownSubinterfaces(interfaceName);
            }
            HashSet<ClassInfo> result = new HashSet<ClassInfo>();
            ArrayDeque<DotName> workQueue = new ArrayDeque<DotName>();
            HashSet<DotName> alreadyProcessed = new HashSet<DotName>();
            workQueue.add(interfaceName);
            while (!workQueue.isEmpty()) {
                DotName iface = (DotName)workQueue.remove();
                if (!alreadyProcessed.add(iface)) continue;
                for (ClassInfo directSubinterface : this.getKnownDirectSubinterfaces(iface)) {
                    result.add(directSubinterface);
                    workQueue.add(directSubinterface.name());
                }
            }
            return result;
        }

        public Collection<ClassInfo> getKnownDirectImplementors(DotName className) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getKnownDirectImplementors(className);
            }
            HashSet<ClassInfo> directImplementors = new HashSet<ClassInfo>(this.index.getKnownDirectImplementors(className));
            block0: for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
                if (!additional.isPresent()) continue;
                for (Type interfaceType : additional.get().interfaceTypes()) {
                    if (!className.equals((Object)interfaceType.name())) continue;
                    directImplementors.add(additional.get());
                    continue block0;
                }
            }
            return directImplementors;
        }

        public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getAllKnownImplementors(interfaceName);
            }
            HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
            HashSet<DotName> subInterfacesToProcess = new HashSet<DotName>();
            HashSet<DotName> processedClasses = new HashSet<DotName>();
            subInterfacesToProcess.add(interfaceName);
            while (!subInterfacesToProcess.isEmpty()) {
                Iterator toProcess = subInterfacesToProcess.iterator();
                DotName name = (DotName)toProcess.next();
                toProcess.remove();
                processedClasses.add(name);
                this.getKnownImplementors(name, allKnown, subInterfacesToProcess, processedClasses);
            }
            return allKnown;
        }

        private void getKnownImplementors(DotName name, Set<ClassInfo> allKnown, Set<DotName> subInterfacesToProcess, Set<DotName> processedClasses) {
            Collection<ClassInfo> list = this.getKnownDirectImplementors(name);
            if (list != null) {
                for (ClassInfo clazz : list) {
                    DotName className = clazz.name();
                    if (processedClasses.contains(className)) continue;
                    if (Modifier.isInterface(clazz.flags())) {
                        subInterfacesToProcess.add(className);
                        continue;
                    }
                    if (allKnown.contains(clazz)) continue;
                    allKnown.add(clazz);
                    processedClasses.add(className);
                    this.getAllKnownSubClasses(className, allKnown, processedClasses);
                }
            }
        }

        public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
            return this.index.getAnnotations(annotationName);
        }

        public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName annotationName, IndexView index) {
            return this.index.getAnnotationsWithRepeatable(annotationName, index);
        }

        public Collection<ModuleInfo> getKnownModules() {
            return this.index.getKnownModules();
        }

        public ModuleInfo getModuleByName(DotName moduleName) {
            return this.index.getModuleByName(moduleName);
        }

        public Collection<ClassInfo> getKnownUsers(DotName className) {
            return this.index.getKnownUsers(className);
        }

        public Collection<ClassInfo> getClassesInPackage(DotName packageName) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getClassesInPackage(packageName);
            }
            HashSet<ClassInfo> classesInPackage = new HashSet<ClassInfo>(this.index.getClassesInPackage(packageName));
            for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
                if (additional.isEmpty() || !Objects.equals(packageName, additional.get().name().packagePrefixName())) continue;
                classesInPackage.add(additional.get());
            }
            return classesInPackage;
        }

        public Set<DotName> getSubpackages(DotName packageName) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getSubpackages(packageName);
            }
            HashSet<DotName> subpackages = new HashSet<DotName>(this.index.getSubpackages(packageName));
            for (Optional<ClassInfo> additional : this.additionalClasses.values()) {
                if (additional.isEmpty()) continue;
                DotName pkg = additional.get().name().packagePrefixName();
                while (pkg != null) {
                    DotName superPkg = pkg.packagePrefixName();
                    if (superPkg != null && superPkg.equals((Object)packageName)) {
                        subpackages.add(pkg);
                    }
                    pkg = superPkg;
                }
            }
            return subpackages;
        }

        private Optional<ClassInfo> computeAdditional(DotName className) {
            LOGGER.debugf("Index: %s", (Object)className);
            Indexer indexer = new Indexer();
            if (BeanArchives.index(indexer, className.toString(), this.deploymentClassLoader)) {
                Index index = indexer.complete();
                return Optional.of(index.getClassByName(className));
            }
            return Optional.empty();
        }
    }
}

