/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Step;
import io.qameta.allure.model.ExecutableItem;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.util.AspectUtils;
import io.qameta.allure.util.NamingUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.Objects;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class StepsAspects {
    private static AllureLifecycle lifecycle;

    @Pointcut(value="@annotation(io.qameta.allure.Step)")
    public void withStepAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation()")
    public void stepStart(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Step step = methodSignature.getMethod().getAnnotation(Step.class);
        String name = step.value().isEmpty() ? methodSignature.getName() : NamingUtils.processNameTemplate(step.value(), AspectUtils.getParametersMap(methodSignature, joinPoint.getArgs()));
        String uuid = UUID.randomUUID().toString();
        StepResult result = new StepResult().withName(name).withParameters(AspectUtils.getParameters(methodSignature, joinPoint.getArgs()));
        ResultsUtils.processDescription(this.getClass().getClassLoader(), methodSignature.getMethod(), (ExecutableItem)result);
        StepsAspects.getLifecycle().startStep(uuid, result);
    }

    @AfterThrowing(pointcut="anyMethod() && withStepAnnotation()", throwing="e")
    public void stepFailed(Throwable e) {
        StepsAspects.getLifecycle().updateStep(result -> result.withStatus(ResultsUtils.getStatus(e).orElse(Status.BROKEN)).withStatusDetails((StatusDetails)ResultsUtils.getStatusDetails(e).orElse(null)));
        StepsAspects.getLifecycle().stopStep();
    }

    @AfterReturning(value="anyMethod() && withStepAnnotation()")
    public void stepStop() {
        StepsAspects.getLifecycle().updateStep(step -> step.withStatus(Status.PASSED));
        StepsAspects.getLifecycle().stopStep();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle = allure;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }
}

