/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.aspects;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.ResultsUtils;
import io.qameta.allure.Step;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.StepResult;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class StepsAspects {
    private static AllureLifecycle lifecycle;

    @Pointcut(value="@annotation(io.qameta.allure.Step)")
    public void withStepAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation()")
    public void stepStart(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String uuid = UUID.randomUUID().toString();
        StepResult result = new StepResult().withName(StepsAspects.getName(methodSignature)).withParameters(StepsAspects.getParameters(methodSignature, joinPoint.getArgs()));
        StepsAspects.getLifecycle().startStep(uuid, result);
    }

    @AfterThrowing(pointcut="anyMethod() && withStepAnnotation()", throwing="e")
    public void stepFailed(Throwable e) {
        StepsAspects.getLifecycle().updateStep(result -> result.withStatus(ResultsUtils.getStatus(e).orElse(Status.BROKEN)).withStatusDetails((StatusDetails)ResultsUtils.getStatusDetails(e).orElse(null)));
        StepsAspects.getLifecycle().stopStep();
    }

    @AfterReturning(value="anyMethod() && withStepAnnotation()")
    public void stepStop() {
        StepsAspects.getLifecycle().updateStep(step -> step.withStatus(Status.PASSED));
        StepsAspects.getLifecycle().stopStep();
    }

    public static void setLifecycle(AllureLifecycle allure) {
        lifecycle = allure;
    }

    public static AllureLifecycle getLifecycle() {
        if (Objects.isNull(lifecycle)) {
            lifecycle = Allure.getLifecycle();
        }
        return lifecycle;
    }

    private static Parameter[] getParameters(MethodSignature signature, Object ... args) {
        return (Parameter[])IntStream.range(0, args.length).mapToObj(index -> {
            String name = signature.getParameterNames()[index];
            String value = Objects.toString(args[index]);
            return new Parameter().withName(name).withValue(value);
        }).toArray(Parameter[]::new);
    }

    private static String getName(MethodSignature signature) {
        return Optional.ofNullable(signature.getMethod().getAnnotation(Step.class)).map(Step::value).filter(s -> !s.isEmpty()).orElseGet(() -> ((MethodSignature)signature).getName());
    }
}

