/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.test;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.AllureResultsWriter;
import io.qameta.allure.aspects.AttachmentsAspects;
import io.qameta.allure.aspects.StepsAspects;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.test.AllureResults;
import io.qameta.allure.test.AllureResultsWriterStub;
import io.qameta.allure.test.AllureTestCommonsUtils;
import io.qameta.allure.util.ExceptionUtils;
import io.qameta.allure.util.ResultsUtils;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class RunUtils {
    private RunUtils() {
        throw new IllegalStateException("do not instance");
    }

    public static AllureResults runTests(Allure.ThrowableContextRunnableVoid<AllureLifecycle> runnable) {
        return RunUtils.runTests(runnable, Allure::setLifecycle, StepsAspects::setLifecycle, AttachmentsAspects::setLifecycle);
    }

    public static AllureResults runTests(Function<AllureResultsWriter, AllureLifecycle> lifecycleFactory, Allure.ThrowableContextRunnableVoid<AllureLifecycle> runnable) {
        return RunUtils.runTests(lifecycleFactory, runnable, Allure::setLifecycle, StepsAspects::setLifecycle, AttachmentsAspects::setLifecycle);
    }

    @SafeVarargs
    public static AllureResults runTests(Allure.ThrowableContextRunnableVoid<AllureLifecycle> runnable, Consumer<AllureLifecycle> ... configurers) {
        return RunUtils.runTests(AllureLifecycle::new, runnable, configurers);
    }

    @SafeVarargs
    public static AllureResults runTests(Function<AllureResultsWriter, AllureLifecycle> lifecycleFactory, Allure.ThrowableContextRunnableVoid<AllureLifecycle> runnable, Consumer<AllureLifecycle> ... configurers) {
        AllureResultsWriterStub writer = new AllureResultsWriterStub();
        AllureLifecycle lifecycle = lifecycleFactory.apply(writer);
        AllureLifecycle defaultLifecycle = Allure.getLifecycle();
        try {
            Stream.of(configurers).forEach(configurer -> configurer.accept(lifecycle));
            runnable.run((Object)lifecycle);
            AllureResultsWriterStub allureResultsWriterStub = writer;
            return allureResultsWriterStub;
        }
        catch (Throwable e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow((Throwable)e);
        }
        finally {
            Stream.of(configurers).forEach(configurer -> configurer.accept(defaultLifecycle));
            AllureTestCommonsUtils.attach(writer);
        }
    }

    public static AllureResults runWithinTestContext(Runnable runnable) {
        return RunUtils.runTests((Allure.ThrowableContextRunnableVoid<AllureLifecycle>)((Allure.ThrowableContextRunnableVoid)lifecycle -> RunUtils.withTestContext(runnable, lifecycle)));
    }

    public static AllureResults runWithinTestContext(Function<AllureResultsWriter, AllureLifecycle> lifecycleFactory, Runnable runnable) {
        return RunUtils.runTests(lifecycleFactory, (Allure.ThrowableContextRunnableVoid<AllureLifecycle>)((Allure.ThrowableContextRunnableVoid)lifecycle -> RunUtils.withTestContext(runnable, lifecycle)));
    }

    @SafeVarargs
    public static AllureResults runWithinTestContext(Runnable runnable, Consumer<AllureLifecycle> ... configurers) {
        return RunUtils.runTests((Allure.ThrowableContextRunnableVoid<AllureLifecycle>)((Allure.ThrowableContextRunnableVoid)lifecycle -> RunUtils.withTestContext(runnable, lifecycle)), configurers);
    }

    @SafeVarargs
    public static AllureResults runWithinTestContext(Function<AllureResultsWriter, AllureLifecycle> lifecycleFactory, Runnable runnable, Consumer<AllureLifecycle> ... configurers) {
        return RunUtils.runTests(lifecycleFactory, (Allure.ThrowableContextRunnableVoid<AllureLifecycle>)((Allure.ThrowableContextRunnableVoid)lifecycle -> RunUtils.withTestContext(runnable, lifecycle)), configurers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withTestContext(Runnable runnable, AllureLifecycle lifecycle) {
        String uuid = UUID.randomUUID().toString();
        TestResult result = new TestResult().setUuid(uuid);
        try {
            lifecycle.scheduleTestCase(result);
            lifecycle.startTestCase(uuid);
            runnable.run();
        }
        catch (Throwable e) {
            lifecycle.updateTestCase(uuid, testResult -> {
                ResultsUtils.getStatus((Throwable)e).ifPresent(arg_0 -> ((TestResult)testResult).setStatus(arg_0));
                ResultsUtils.getStatusDetails((Throwable)e).ifPresent(arg_0 -> ((TestResult)testResult).setStatusDetails(arg_0));
            });
        }
        finally {
            lifecycle.stopTestCase(uuid);
            lifecycle.writeTestCase(uuid);
        }
    }
}

