/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.test;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.AllureResultsWriter;
import io.qameta.allure.aspects.AttachmentsAspects;
import io.qameta.allure.aspects.StepsAspects;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.test.AllureResults;
import io.qameta.allure.test.AllureResultsWriterStub;
import io.qameta.allure.util.ResultsUtils;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class RunUtils {
    private RunUtils() {
        throw new IllegalStateException("do not instance");
    }

    public static AllureResults runWithinTestContext(Runnable runnable) {
        return RunUtils.runWithinTestContext(runnable, Allure::setLifecycle, StepsAspects::setLifecycle, AttachmentsAspects::setLifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static AllureResults runWithinTestContext(Runnable runnable, Consumer<AllureLifecycle> ... configurers) {
        AllureResultsWriterStub writer = new AllureResultsWriterStub();
        AllureLifecycle lifecycle = new AllureLifecycle((AllureResultsWriter)writer);
        String uuid = UUID.randomUUID().toString();
        TestResult result = new TestResult().setUuid(uuid);
        AllureLifecycle cached = Allure.getLifecycle();
        try {
            Stream.of(configurers).forEach(configurer -> configurer.accept(lifecycle));
            lifecycle.scheduleTestCase(result);
            lifecycle.startTestCase(uuid);
            runnable.run();
        }
        catch (Throwable e) {
            lifecycle.updateTestCase(uuid, testResult -> {
                ResultsUtils.getStatus((Throwable)e).ifPresent(arg_0 -> ((TestResult)testResult).setStatus(arg_0));
                ResultsUtils.getStatusDetails((Throwable)e).ifPresent(arg_0 -> ((TestResult)testResult).setStatusDetails(arg_0));
            });
        }
        finally {
            lifecycle.stopTestCase(uuid);
            lifecycle.writeTestCase(uuid);
            Stream.of(configurers).forEach(configurer -> configurer.accept(cached));
        }
        return writer;
    }
}

