/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.CollectionSchema;
import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.Message;
import io.protostuff.Morph;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import io.protostuff.Tag;
import io.protostuff.WireFormat;
import io.protostuff.runtime.Accessor;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.Field;
import io.protostuff.runtime.HasSchema;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.PolymorphicSchema;
import io.protostuff.runtime.PolymorphicSchemaFactories;
import io.protostuff.runtime.RuntimeCollectionField;
import io.protostuff.runtime.RuntimeFieldFactory;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.EnumSet;

final class RuntimeCollectionFieldFactory {
    static final Accessor.Factory AF = RuntimeFieldFactory.ACCESSOR_FACTORY;
    private static final RuntimeFieldFactory<Collection<?>> COLLECTION = new RuntimeFieldFactory<Collection<?>>(25){

        @Override
        public <T> Field<T> create(int number, String name, java.lang.reflect.Field f, IdStrategy strategy) {
            Class<?> clazz = f.getType();
            Morph morph = f.getAnnotation(Morph.class);
            if (0 != (0x80 & strategy.flags) && (morph == null || morph.value())) {
                if (!clazz.getName().startsWith("java.util") && 6.pojo(clazz, morph, strategy)) {
                    return POJO.create(number, name, f, strategy);
                }
                return OBJECT.create(number, name, f, strategy);
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                if (!clazz.isInterface()) {
                    return OBJECT.create(number, name, f, strategy);
                }
                if (morph == null ? 0 != (0x10 & strategy.flags) : morph.value()) {
                    return OBJECT.create(number, name, f, strategy);
                }
            }
            if (EnumSet.class.isAssignableFrom(f.getType())) {
                Class<?> enumType = 6.getGenericType(f, 0);
                if (enumType == null) {
                    return RuntimeFieldFactory.OBJECT.create(number, name, f, strategy);
                }
                return RuntimeCollectionFieldFactory.createCollectionEnumV(number, name, f, strategy.getEnumIO(enumType).getEnumSetFactory(), enumType, strategy);
            }
            CollectionSchema.MessageFactory messageFactory = strategy.getCollectionFactory(f.getType());
            Class<?> genericType = 6.getGenericType(f, 0);
            if (genericType == null) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, (Schema<Object>)strategy.OBJECT_ELEMENT_SCHEMA, (Pipe.Schema<Object>)strategy.OBJECT_ELEMENT_SCHEMA.pipeSchema, strategy);
            }
            Delegate<?> inline = 6.getDelegateOrInline(genericType, strategy);
            if (inline != null) {
                return RuntimeCollectionFieldFactory.createCollectionInlineV(number, name, f, messageFactory, inline);
            }
            if (Message.class.isAssignableFrom(genericType)) {
                return RuntimeCollectionFieldFactory.createCollectionPojoV(number, name, f, messageFactory, genericType, strategy);
            }
            if (genericType.isEnum()) {
                return RuntimeCollectionFieldFactory.createCollectionEnumV(number, name, f, messageFactory, genericType, strategy);
            }
            PolymorphicSchema ps = PolymorphicSchemaFactories.getSchemaFromCollectionOrMapGenericType(genericType, strategy);
            if (ps != null) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, (Schema<Object>)ps, (Pipe.Schema<Object>)ps.getPipeSchema(), strategy);
            }
            if (6.pojo(genericType, morph, strategy)) {
                return RuntimeCollectionFieldFactory.createCollectionPojoV(number, name, f, messageFactory, genericType, strategy);
            }
            if (genericType.isInterface()) {
                return RuntimeCollectionFieldFactory.createCollectionObjectV(number, name, f, messageFactory, (Schema<Object>)strategy.OBJECT_ELEMENT_SCHEMA, (Pipe.Schema<Object>)strategy.OBJECT_ELEMENT_SCHEMA.pipeSchema, strategy);
            }
            return RuntimeCollectionFieldFactory.createCollectionPolymorphicV(number, name, f, messageFactory, genericType, strategy);
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<?> readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(Output output, int number, Collection<?> value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };

    private RuntimeCollectionFieldFactory() {
    }

    static RuntimeFieldFactory<Collection<?>> getFactory() {
        return COLLECTION;
    }

    private static <T> Field<T> createCollectionInlineV(int number, String name, java.lang.reflect.Field f, CollectionSchema.MessageFactory messageFactory, final Delegate<Object> inline) {
        final Accessor accessor = AF.create(f);
        return new RuntimeCollectionField<T, Object>(inline.getFieldType(), number, name, f.getAnnotation(Tag.class), messageFactory){

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                accessor.set(message, input.mergeObject(accessor.get(message), (Schema)this.schema));
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing = (Collection)accessor.get(message);
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                collection.add(inline.readFrom(input));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                inline.writeTo(output, fieldNumber, value, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                inline.transfer(pipe, input, output, number, repeated);
            }
        };
    }

    private static <T> Field<T> createCollectionEnumV(int number, String name, java.lang.reflect.Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, final IdStrategy strategy) {
        final EnumIO<? extends Enum<?>> eio = strategy.getEnumIO(genericType);
        final Accessor accessor = AF.create(f);
        return new RuntimeCollectionField<T, Enum<?>>(WireFormat.FieldType.ENUM, number, name, f.getAnnotation(Tag.class), messageFactory){

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                accessor.set(message, input.mergeObject(accessor.get(message), (Schema)this.schema));
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing = (Collection)accessor.get(message);
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Enum<?>> collection) throws IOException {
                collection.add((Enum<?>)eio.readFrom(input));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Enum<?> value, boolean repeated) throws IOException {
                eio.writeTo(output, fieldNumber, repeated, value);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                EnumIO.transfer(pipe, input, output, number, repeated, strategy);
            }
        };
    }

    private static <T> Field<T> createCollectionPojoV(int number, String name, java.lang.reflect.Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, IdStrategy strategy) {
        final HasSchema<Object> schemaV = strategy.getSchemaWrapper(genericType, true);
        final Accessor accessor = AF.create(f);
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, f.getAnnotation(Tag.class), messageFactory){

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                accessor.set(message, input.mergeObject(accessor.get(message), (Schema)this.schema));
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing = (Collection)accessor.get(message);
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                collection.add(input.mergeObject(null, schemaV.getSchema()));
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, schemaV.getSchema(), repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, (Object)pipe, schemaV.getPipeSchema(), repeated);
            }
        };
    }

    private static <T> Field<T> createCollectionPolymorphicV(int number, String name, java.lang.reflect.Field f, CollectionSchema.MessageFactory messageFactory, Class<Object> genericType, final IdStrategy strategy) {
        final Accessor accessor = AF.create(f);
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, f.getAnnotation(Tag.class), messageFactory){

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                accessor.set(message, input.mergeObject(accessor.get(message), (Schema)this.schema));
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing = (Collection)accessor.get(message);
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                Object value = input.mergeObject(collection, (Schema)strategy.POLYMORPHIC_POJO_ELEMENT_SCHEMA);
                if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                    collection.add(value);
                }
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, (Schema)strategy.POLYMORPHIC_POJO_ELEMENT_SCHEMA, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, (Object)pipe, strategy.POLYMORPHIC_POJO_ELEMENT_SCHEMA.pipeSchema, repeated);
            }
        };
    }

    private static <T> Field<T> createCollectionObjectV(int number, String name, java.lang.reflect.Field f, CollectionSchema.MessageFactory messageFactory, final Schema<Object> valueSchema, final Pipe.Schema<Object> valuePipeSchema, IdStrategy strategy) {
        final Accessor accessor = AF.create(f);
        return new RuntimeCollectionField<T, Object>(WireFormat.FieldType.MESSAGE, number, name, f.getAnnotation(Tag.class), messageFactory){

            @Override
            protected void mergeFrom(Input input, T message) throws IOException {
                accessor.set(message, input.mergeObject(accessor.get(message), (Schema)this.schema));
            }

            @Override
            protected void writeTo(Output output, T message) throws IOException {
                Collection existing = (Collection)accessor.get(message);
                if (existing != null) {
                    output.writeObject(this.number, (Object)existing, (Schema)this.schema, false);
                }
            }

            @Override
            protected void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                output.writeObject(this.number, (Object)pipe, (Schema)this.schema.pipeSchema, repeated);
            }

            @Override
            protected void addValueFrom(Input input, Collection<Object> collection) throws IOException {
                Object value = input.mergeObject(collection, valueSchema);
                if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                    collection.add(value);
                }
            }

            @Override
            protected void writeValueTo(Output output, int fieldNumber, Object value, boolean repeated) throws IOException {
                output.writeObject(fieldNumber, value, valueSchema, repeated);
            }

            @Override
            protected void transferValue(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                output.writeObject(number, (Object)pipe, (Schema)valuePipeSchema, repeated);
            }
        };
    }
}

