/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.filter;

import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetricsFilter
implements Filter {
    static final String PATH_COMPONENT_PARAM = "path-components";
    static final String HELP_PARAM = "help";
    static final String METRIC_NAME_PARAM = "metric-name";
    static final String BUCKET_CONFIG_PARAM = "buckets";
    static final String UNKNOWN_HTTP_STATUS_CODE = "";
    private Histogram histogram = null;
    private Counter statusCounter = null;
    int pathComponents = 1;
    private String metricName = null;
    private String help = "The time taken fulfilling servlet requests";
    private double[] buckets = null;

    public MetricsFilter() {
    }

    public MetricsFilter(String metricName, String help, Integer pathComponents, double[] buckets) {
        this.metricName = metricName;
        this.buckets = buckets;
        if (help != null) {
            this.help = help;
        }
        if (pathComponents != null) {
            this.pathComponents = pathComponents;
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private String getComponents(String str) {
        if (str == null || this.pathComponents < 1) {
            return str;
        }
        int count = 0;
        int i = -1;
        do {
            if ((i = str.indexOf("/", i + 1)) >= 0) continue;
            return str;
        } while (++count <= this.pathComponents);
        return str.substring(0, i);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Histogram.Builder builder = (Histogram.Builder)Histogram.build().labelNames(new String[]{"path", "method"});
        if (filterConfig == null && this.isEmpty(this.metricName)) {
            throw new ServletException("No configuration object provided, and no metricName passed via constructor");
        }
        if (filterConfig != null) {
            if (this.isEmpty(this.metricName)) {
                this.metricName = filterConfig.getInitParameter(METRIC_NAME_PARAM);
                if (this.isEmpty(this.metricName)) {
                    throw new ServletException("Init parameter \"metric-name\" is required; please supply a value");
                }
            }
            if (!this.isEmpty(filterConfig.getInitParameter(HELP_PARAM))) {
                this.help = filterConfig.getInitParameter(HELP_PARAM);
            }
            if (!this.isEmpty(filterConfig.getInitParameter(PATH_COMPONENT_PARAM))) {
                this.pathComponents = Integer.valueOf(filterConfig.getInitParameter(PATH_COMPONENT_PARAM));
            }
            if (!this.isEmpty(filterConfig.getInitParameter(BUCKET_CONFIG_PARAM))) {
                String[] bucketParams = filterConfig.getInitParameter(BUCKET_CONFIG_PARAM).split(",");
                this.buckets = new double[bucketParams.length];
                for (int i = 0; i < bucketParams.length; ++i) {
                    this.buckets[i] = Double.parseDouble(bucketParams[i]);
                }
            }
        }
        if (this.buckets != null) {
            builder = builder.buckets(this.buckets);
        }
        this.histogram = (Histogram)((Histogram.Builder)((Histogram.Builder)builder.help(this.help)).name(this.metricName)).register();
        this.statusCounter = (Counter)((Counter.Builder)Counter.build((String)(this.metricName + "_status_total"), (String)("HTTP status codes of " + this.help)).labelNames(new String[]{"path", "method", "status"})).register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String path = request.getRequestURI();
        String components = this.getComponents(path);
        String method = request.getMethod();
        Histogram.Timer timer = ((Histogram.Child)this.histogram.labels(new String[]{components, method})).startTimer();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Throwable throwable) {
            timer.observeDuration();
            ((Counter.Child)this.statusCounter.labels(new String[]{components, method, this.getStatusCode(servletResponse)})).inc();
            throw throwable;
        }
        timer.observeDuration();
        ((Counter.Child)this.statusCounter.labels(new String[]{components, method, this.getStatusCode(servletResponse)})).inc();
    }

    private String getStatusCode(ServletResponse servletResponse) {
        if (!(servletResponse instanceof HttpServletResponse)) {
            return UNKNOWN_HTTP_STATUS_CODE;
        }
        return Integer.toString(((HttpServletResponse)servletResponse).getStatus());
    }

    public void destroy() {
    }
}

