/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.DoubleAdder;
import io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Summary
extends SimpleCollector<Child, Summary> {
    Summary(Builder b) {
        super(b);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child();
    }

    public void observe(double amt) {
        ((Child)this.noLabelsChild).observe(amt);
    }

    public Timer startTimer() {
        return ((Child)this.noLabelsChild).startTimer();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            Child.Value v = ((Child)c.getValue()).get();
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_count", this.labelNames, (List)c.getKey(), v.count));
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_sum", this.labelNames, (List)c.getKey(), v.sum));
        }
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(this.fullname, Collector.Type.SUMMARY, this.help, samples);
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>();
        mfsList.add(mfs);
        return mfsList;
    }

    static class TimeProvider {
        TimeProvider() {
        }

        long nanoTime() {
            return System.nanoTime();
        }
    }

    public static class Child {
        private DoubleAdder count = new DoubleAdder();
        private DoubleAdder sum = new DoubleAdder();
        static TimeProvider timeProvider = new TimeProvider();

        public void observe(double amt) {
            this.count.add(1.0);
            this.sum.add(amt);
        }

        public Timer startTimer() {
            return new Timer(this);
        }

        public Value get() {
            Value v = new Value();
            v.count = this.count.sum();
            v.sum = this.sum.sum();
            return v;
        }

        public static class Value {
            private double count;
            private double sum;
        }
    }

    public static class Timer {
        Child child;
        long start;

        private Timer(Child child) {
            this.child = child;
            this.start = Child.timeProvider.nanoTime();
        }

        public void observeDuration() {
            this.child.observe((double)(Child.timeProvider.nanoTime() - this.start) / 1.0E9);
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Summary> {
        @Override
        public Summary create() {
            return new Summary(this);
        }
    }
}

