/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SimpleCollector<Child>
extends Collector {
    final String fullname;
    final String help;
    final String[] labelNames;
    final ConcurrentHashMap<List<String>, Child> children = new ConcurrentHashMap();

    public Child labels(String ... labelValues) {
        if (labelValues.length != this.labelNames.length) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        List<String> key = Arrays.asList(labelValues);
        Child c = this.children.get(key);
        if (c != null) {
            return c;
        }
        this.children.putIfAbsent(key, this.newChild());
        return this.children.get(key);
    }

    public void remove(String ... labelValues) {
        this.children.remove(Arrays.asList(labelValues));
    }

    public void clear() {
        this.children.clear();
    }

    protected abstract Child newChild();

    protected SimpleCollector(Builder b) {
        if (b.name.isEmpty()) {
            throw new IllegalStateException("Name hasn't been set.");
        }
        String name = b.name;
        if (!b.subsystem.isEmpty()) {
            name = b.subsystem + '_' + name;
        }
        if (!b.namespace.isEmpty()) {
            name = b.namespace + '_' + name;
        }
        this.fullname = name;
        if (b.help.isEmpty()) {
            throw new IllegalStateException("Help hasn't been set.");
        }
        this.help = b.help;
        this.labelNames = b.labelNames;
    }

    public static abstract class Builder {
        String namespace = "";
        String subsystem = "";
        String name = "";
        String fullname = "";
        String help = "";
        String[] labelNames = new String[0];

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder subsystem(String subsystem) {
            this.subsystem = subsystem;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder help(String help) {
            this.help = help;
            return this;
        }

        public Builder labelNames(String ... labelNames) {
            this.labelNames = labelNames;
            return this;
        }

        public abstract SimpleCollector create();

        public SimpleCollector register() {
            return this.register(CollectorRegistry.defaultRegistry);
        }

        public SimpleCollector register(CollectorRegistry registry) {
            SimpleCollector sc = this.create();
            registry.register(sc);
            return sc;
        }
    }
}

