/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.SimpleCollector;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Counter
extends SimpleCollector<Child> {
    public Counter(Builder b) {
        super(b);
        if (this.labelNames.length == 0) {
            this.inc(0.0);
        }
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child();
    }

    public void inc() {
        this.inc(1.0);
    }

    public void inc(double amt) {
        ((Child)this.labels(new String[0])).inc(amt);
    }

    @Override
    public Collector.MetricFamilySamples[] collect() {
        Vector<Collector.MetricFamilySamples.Sample> samples = new Vector<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, this.labelNames, (List)c.getKey(), ((Child)c.getValue()).get()));
        }
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(this.fullname, Collector.Type.COUNTER, this.help, samples);
        return new Collector.MetricFamilySamples[]{mfs};
    }

    public static class Child {
        private volatile double value;

        public void inc() {
            this.inc(1.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inc(double amt) {
            if (amt < 0.0) {
                throw new IllegalArgumentException("Amount to increment must be non-negative.");
            }
            Child child = this;
            synchronized (child) {
                this.value += amt;
            }
        }

        public double get() {
            return this.value;
        }
    }

    public static class Builder
    extends SimpleCollector.Builder {
        @Override
        public SimpleCollector create() {
            return new Counter(this);
        }
    }
}

