/*
 * Decompiled with CFR 0.152.
 */
package io.polygenesis.models.apiimpl;

import io.polygenesis.commons.assertion.Assertion;
import io.polygenesis.commons.text.TextConverter;
import io.polygenesis.commons.valueobjects.ObjectName;
import io.polygenesis.commons.valueobjects.VariableName;
import io.polygenesis.core.Generatable;
import io.polygenesis.core.Metamodel;
import io.polygenesis.models.apiimpl.DomainObjectConverterMethod;
import io.polygenesis.models.apiimpl.ServiceDependency;
import io.polygenesis.models.domain.DomainObject;
import java.util.Objects;
import java.util.Set;

public class DomainObjectConverter
extends ServiceDependency
implements Metamodel,
Generatable {
    private DomainObject domainObject;
    private Set<DomainObjectConverterMethod> methods;

    public DomainObjectConverter(DomainObject domainObject, Set<DomainObjectConverterMethod> methods) {
        super(new ObjectName(String.format("%sConverter", TextConverter.toUpperCamel((String)domainObject.getObjectName().getText()))), domainObject.getPackageName(), new VariableName(String.format("%sConverter", TextConverter.toLowerCamel((String)domainObject.getObjectName().getText()))));
        this.setDomainObject(domainObject);
        this.setMethods(methods);
    }

    public DomainObject getDomainObject() {
        return this.domainObject;
    }

    public Set<DomainObjectConverterMethod> getMethods() {
        return this.methods;
    }

    private void setDomainObject(DomainObject domainObject) {
        Assertion.isNotNull((Object)domainObject, (String)"domainObject is required");
        this.domainObject = domainObject;
    }

    private void setMethods(Set<DomainObjectConverterMethod> methods) {
        Assertion.isNotNull(methods, (String)"methods is required");
        this.methods = methods;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DomainObjectConverter that = (DomainObjectConverter)o;
        return Objects.equals(this.domainObject, that.domainObject) && Objects.equals(this.methods, that.methods);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.domainObject, this.methods);
    }
}

